/*
 * Decompiled with CFR 0.152.
 */
package viz.graphics;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import viz.graphics.TreeDrawer;

public class SVGTreeDrawer
extends TreeDrawer {
    StringBuffer m_buf;
    public int m_branchStyle = 0;
    Color m_color;
    float m_fAlpha;

    public SVGTreeDrawer(StringBuffer buf) {
        this.m_buf = buf;
    }

    private void draw(int nX1, int nY1, int nX2, int nY2, float fWidth) {
        this.m_buf.append("<path fill='none' stroke='rgb(" + this.m_color.getRed() + "," + this.m_color.getGreen() + "," + this.m_color.getBlue() + ")' " + "stroke-width='" + fWidth + "' " + "opacity='" + this.m_fAlpha + "' " + " d='");
        this.m_buf.append("M" + nX1 + " " + nY1 + "L" + nX2 + " " + nY2);
        this.m_buf.append("'/>\n");
    }

    private void draw(int nX1, int nY1, int nX2, int nY2) {
        this.m_buf.append("M" + nX1 + " " + nY1 + "L" + nX2 + " " + nY2);
    }

    private void drawarc(int nX1, int nY1, int nX2, int nY2) {
        this.m_buf.append("M" + nX1 + " " + nY1 + "A" + (nX2 - nX1) + "," + (nY2 - nY1) + " 0 0,0 " + nX2 + "," + nY2);
    }

    @Override
    void drawBlockTree(float[] nX, float[] nY, int[] color, Graphics2D g, float fScaleX, float fScaleY) {
        if (nX == null || nY == null) {
            return;
        }
        float fLineWidth = ((BasicStroke)g.getStroke()).getLineWidth();
        float fAlpha = ((AlphaComposite)g.getComposite()).getAlpha();
        int nRed = color[0] >> 16 & 0xFF;
        int nGreen = color[0] >> 8 & 0xFF;
        int nBlue = color[0] >> 0 & 0xFF;
        this.m_buf.append("<path fill='none' stroke='rgb(" + nRed + "," + nGreen + "," + nBlue + ")' " + "stroke-width='" + fLineWidth + "' " + "opacity='" + fAlpha + "' " + " d='");
        if (this.m_nJitter <= 0) {
            int i = 0;
            while (i < nX.length - 1) {
                if (this.m_bRootAtTop) {
                    this.draw((int)(nX[i] * fScaleX), (int)(nY[i] * fScaleY), (int)(nX[i] * fScaleX), (int)(nY[i + 1] * fScaleY));
                    this.draw((int)(nX[i] * fScaleX), (int)(nY[i + 1] * fScaleY), (int)(nX[i + 3] * fScaleX), (int)(nY[i + 1] * fScaleY));
                    this.draw((int)(nX[i + 3] * fScaleX), (int)(nY[i + 2] * fScaleY), (int)(nX[i + 3] * fScaleX), (int)(nY[i + 3] * fScaleY));
                } else {
                    this.draw((int)(nY[i] * fScaleX), (int)(nX[i] * fScaleY), (int)(nY[i + 1] * fScaleX), (int)(nX[i] * fScaleY));
                    this.draw((int)(nY[i + 1] * fScaleX), (int)(nX[i] * fScaleY), (int)(nY[i + 1] * fScaleX), (int)(nX[i + 3] * fScaleY));
                    this.draw((int)(nY[i + 2] * fScaleX), (int)(nX[i + 3] * fScaleY), (int)(nY[i + 3] * fScaleX), (int)(nX[i + 3] * fScaleY));
                }
                i += 4;
            }
        } else {
            int[] nXJ = new int[nX.length];
            int i = 0;
            while (i < nX.length) {
                nXJ[i] = (int)(nX[i] * fScaleX) + this.m_random.nextInt(this.m_nJitter);
                ++i;
            }
            i = 0;
            while (i < nX.length - 1) {
                if (i % 4 != 3) {
                    this.draw(nXJ[i], (int)(nY[i] * fScaleY), nXJ[i + 1], (int)(nY[i + 1] * fScaleY));
                }
                ++i;
            }
        }
        this.m_buf.append("'/>\n");
    }

    @Override
    void drawBlockTree(float[] nX, float[] nY, float[] fLineWidth, float[] fTopLineWidth, int[] color, Graphics2D g, float fScaleX, float fScaleY) {
        if (nX == null || nY == null) {
            return;
        }
        if (this.m_nJitter <= 0) {
            int i = 0;
            while (i < nX.length - 2) {
                if (i % 4 != 3) {
                    if (i % 4 == 0 || i % 4 == 2) {
                        float fTopWidth2;
                        float fWidth = fLineWidth[i] * this.LINE_WIDTH_SCALE;
                        float fTopWidth = fTopLineWidth[i] * this.LINE_WIDTH_SCALE;
                        BasicStroke stroke = new BasicStroke(fWidth, 0, 2);
                        g.setStroke(stroke);
                        if (this.m_bViewBlockTree) {
                            if (i % 4 == 0) {
                                this.draw((int)(nX[i] * fScaleX), (int)(nY[i] * fScaleY - fWidth / 2.0f), (int)(nX[i + 1] * fScaleX), (int)(nY[i + 1] * fScaleY - fTopWidth / 2.0f), fWidth);
                            } else {
                                this.draw((int)(nX[i] * fScaleX), (int)(nY[i] * fScaleY - fTopWidth / 2.0f), (int)(nX[i + 1] * fScaleX), (int)(nY[i + 1] * fScaleY - fWidth / 2.0f), fWidth);
                            }
                        } else if (i % 4 == 0) {
                            fTopWidth2 = fTopLineWidth[i + 2] * this.LINE_WIDTH_SCALE;
                            if (nY[i + 1] < nY[i + 2]) {
                                this.draw((int)(nX[i] * fScaleX), (int)(nY[i] * fScaleY - fWidth / 2.0f), (int)(nX[i + 1] * fScaleX) - 1, (int)((double)(nY[i + 1] + nY[i + 2]) / 2.0 * (double)fScaleY - (double)((fTopWidth + fTopWidth2) / 2.0f)), fWidth);
                            } else {
                                this.draw((int)(nX[i] * fScaleX), (int)(nY[i] * fScaleY - fWidth / 2.0f), (int)(nX[i + 1] * fScaleX) - 1, (int)((double)(nY[i + 1] + nY[i + 2]) / 2.0 * (double)fScaleY - (double)((fTopWidth - fTopWidth2) / 2.0f)), fWidth);
                            }
                        } else {
                            fTopWidth2 = fTopLineWidth[i - 2] * this.LINE_WIDTH_SCALE;
                            if (nY[i - 1] < nY[i]) {
                                this.draw((int)(nX[i] * fScaleX) - 1, (int)((double)(nY[i] + nY[i - 1]) / 2.0 * (double)fScaleY - (double)((fTopWidth - fTopWidth2) / 2.0f)), (int)(nX[i + 1] * fScaleX), (int)(nY[i + 1] * fScaleY - fWidth / 2.0f), fWidth);
                            } else {
                                this.draw((int)(nX[i] * fScaleX) - 1, (int)((double)(nY[i] + nY[i - 1]) / 2.0 * (double)fScaleY - (double)((fTopWidth + fTopWidth2) / 2.0f)), (int)(nX[i + 1] * fScaleX), (int)(nY[i + 1] * fScaleY - fWidth / 2.0f), fWidth);
                            }
                        }
                    } else if (i % 4 == 1 && this.m_bViewBlockTree) {
                        BasicStroke stroke = new BasicStroke(this.m_nTreeWidth, 0, 2);
                        g.setStroke(stroke);
                        this.draw((int)(nX[i] * fScaleX), (int)(nY[i] * fScaleY), (int)(nX[i + 1] * fScaleX), (int)(nY[i + 1] * fScaleY), this.m_nTreeWidth);
                    }
                }
                ++i;
            }
        } else {
            int[] nXJ = new int[nX.length];
            int i = 0;
            while (i < nX.length) {
                nXJ[i] = (int)(nX[i] * fScaleX) + this.m_random.nextInt(this.m_nJitter);
                ++i;
            }
            i = 0;
            while (i < nX.length - 1) {
                if (i % 4 != 3) {
                    this.draw(nXJ[i], (int)(nY[i] * fScaleY), nXJ[i + 1], (int)(nY[i + 1] * fScaleY), this.m_nTreeWidth);
                }
                if (i % 4 == 0 || i % 4 == 2) {
                    float fWidth = fLineWidth[i] * this.LINE_WIDTH_SCALE;
                    BasicStroke stroke = new BasicStroke(fWidth, 0, 2);
                    g.setStroke(stroke);
                    this.draw(nXJ[i], (int)(nY[i] * fScaleY - fWidth / 2.0f), nXJ[i + 1], (int)(nY[i + 1] * fScaleY - fWidth / 2.0f), fWidth);
                } else if (i % 4 == 1) {
                    BasicStroke stroke = new BasicStroke(this.m_nTreeWidth, 0, 2);
                    g.setStroke(stroke);
                    this.draw(nXJ[i], (int)(nY[i] * fScaleY), nXJ[i + 1], (int)(nY[i + 1] * fScaleY), this.m_nTreeWidth);
                }
                ++i;
            }
        }
    }

    @Override
    void drawTriangleTree(float[] nX, float[] nY, int[] color, Graphics2D g, float fScaleX, float fScaleY) {
        if (nX == null || nY == null) {
            return;
        }
        float fLineWidth = ((BasicStroke)g.getStroke()).getLineWidth();
        float fAlpha = ((AlphaComposite)g.getComposite()).getAlpha();
        int nRed = color[0] >> 16 & 0xFF;
        int nGreen = color[0] >> 8 & 0xFF;
        int nBlue = color[0] >> 0 & 0xFF;
        this.m_buf.append("<path fill='none' stroke='rgb(" + nRed + "," + nGreen + "," + nBlue + ")' " + "stroke-width='" + fLineWidth + "' " + "opacity='" + fAlpha + "' " + " d='");
        if (this.m_bRootAtTop) {
            int i = 0;
            while (i < nX.length - 4) {
                float fWidth = 0.0f;
                float fTopWidth = 0.0f;
                float fTopWidth2 = 0.0f;
                if (i % 4 != 3 && (i % 4 == 0 || i % 4 == 2)) {
                    if (this.m_branchStyle == 2) {
                        if (i % 4 == 0) {
                            if (nX[i + 1] < nX[i + 2]) {
                                this.drawarc((int)(nX[i] * fScaleX - fWidth / 2.0f), (int)(nY[i] * fScaleY), (int)((double)(nX[i + 1] + nX[i + 2]) / 2.0 * (double)fScaleX - (double)((fTopWidth + fTopWidth2) / 2.0f)), (int)(nY[i + 1] * fScaleY) - 1);
                            } else {
                                this.drawarc((int)(nX[i] * fScaleX - fWidth / 2.0f), (int)(nY[i] * fScaleY), (int)((double)(nX[i + 1] + nX[i + 2]) / 2.0 * (double)fScaleX - (double)((fTopWidth - fTopWidth2) / 2.0f)), (int)(nY[i + 1] * fScaleY) - 1);
                            }
                        } else if (nX[i - 1] < nX[i]) {
                            this.drawarc((int)((double)(nX[i] + nX[i - 1]) / 2.0 * (double)fScaleX - (double)((fTopWidth - fTopWidth2) / 2.0f)), (int)(nY[i] * fScaleY) - 1, (int)(nX[i + 1] * fScaleX - fWidth / 2.0f), (int)(nY[i + 1] * fScaleY) - 1);
                        } else {
                            this.drawarc((int)((double)(nX[i] + nX[i - 1]) / 2.0 * (double)fScaleX - (double)((fTopWidth + fTopWidth2) / 2.0f)), (int)(nY[i] * fScaleY) - 1, (int)(nX[i + 1] * fScaleX - fWidth / 2.0f), (int)(nY[i + 1] * fScaleY) - 1);
                        }
                    } else if (i % 4 == 0) {
                        if (nX[i + 1] < nX[i + 2]) {
                            this.draw((int)(nX[i] * fScaleX - fWidth / 2.0f), (int)(nY[i] * fScaleY), (int)((double)(nX[i + 1] + nX[i + 2]) / 2.0 * (double)fScaleX - (double)((fTopWidth + fTopWidth2) / 2.0f)), (int)(nY[i + 1] * fScaleY) - 1);
                        } else {
                            this.draw((int)(nX[i] * fScaleX - fWidth / 2.0f), (int)(nY[i] * fScaleY), (int)((double)(nX[i + 1] + nX[i + 2]) / 2.0 * (double)fScaleX - (double)((fTopWidth - fTopWidth2) / 2.0f)), (int)(nY[i + 1] * fScaleY) - 1);
                        }
                    } else if (nX[i - 1] < nX[i]) {
                        this.draw((int)((double)(nX[i] + nX[i - 1]) / 2.0 * (double)fScaleX - (double)((fTopWidth - fTopWidth2) / 2.0f)), (int)(nY[i] * fScaleY) - 1, (int)(nX[i + 1] * fScaleX - fWidth / 2.0f), (int)(nY[i + 1] * fScaleY) - 1);
                    } else {
                        this.draw((int)((double)(nX[i] + nX[i - 1]) / 2.0 * (double)fScaleX - (double)((fTopWidth + fTopWidth2) / 2.0f)), (int)(nY[i] * fScaleY) - 1, (int)(nX[i + 1] * fScaleX - fWidth / 2.0f), (int)(nY[i + 1] * fScaleY) - 1);
                    }
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < nX.length - 4) {
                float fWidth = 0.0f;
                float fTopWidth = 0.0f;
                float fTopWidth2 = 0.0f;
                if (i % 4 != 3 && (i % 4 == 0 || i % 4 == 2)) {
                    if (this.m_branchStyle == 2) {
                        if (i % 4 == 0) {
                            if (nY[i + 1] < nY[i + 2]) {
                                this.drawarc((int)(nX[i] * fScaleX), (int)(nY[i] * fScaleY - fWidth / 2.0f), (int)(nX[i + 1] * fScaleX) - 1, (int)((double)(nY[i + 1] + nY[i + 2]) / 2.0 * (double)fScaleY - (double)((fTopWidth + fTopWidth2) / 2.0f)));
                            } else {
                                this.drawarc((int)(nX[i] * fScaleX), (int)(nY[i] * fScaleY - fWidth / 2.0f), (int)(nX[i + 1] * fScaleX) - 1, (int)((double)(nY[i + 1] + nY[i + 2]) / 2.0 * (double)fScaleY - (double)((fTopWidth - fTopWidth2) / 2.0f)));
                            }
                        } else if (nY[i - 1] < nY[i]) {
                            this.drawarc((int)(nX[i] * fScaleX) - 1, (int)((double)(nY[i] + nY[i - 1]) / 2.0 * (double)fScaleY - (double)((fTopWidth - fTopWidth2) / 2.0f)), (int)(nX[i + 1] * fScaleX), (int)(nY[i + 1] * fScaleY - fWidth / 2.0f));
                        } else {
                            this.drawarc((int)(nX[i] * fScaleX) - 1, (int)((double)(nY[i] + nY[i - 1]) / 2.0 * (double)fScaleY - (double)((fTopWidth + fTopWidth2) / 2.0f)), (int)(nX[i + 1] * fScaleX), (int)(nY[i + 1] * fScaleY - fWidth / 2.0f));
                        }
                    } else if (i % 4 == 0) {
                        if (nY[i + 1] < nY[i + 2]) {
                            this.draw((int)(nX[i] * fScaleX), (int)(nY[i] * fScaleY - fWidth / 2.0f), (int)(nX[i + 1] * fScaleX) - 1, (int)((double)(nY[i + 1] + nY[i + 2]) / 2.0 * (double)fScaleY - (double)((fTopWidth + fTopWidth2) / 2.0f)));
                        } else {
                            this.draw((int)(nX[i] * fScaleX), (int)(nY[i] * fScaleY - fWidth / 2.0f), (int)(nX[i + 1] * fScaleX) - 1, (int)((double)(nY[i + 1] + nY[i + 2]) / 2.0 * (double)fScaleY - (double)((fTopWidth - fTopWidth2) / 2.0f)));
                        }
                    } else if (nY[i - 1] < nY[i]) {
                        this.draw((int)(nX[i] * fScaleX) - 1, (int)((double)(nY[i] + nY[i - 1]) / 2.0 * (double)fScaleY - (double)((fTopWidth - fTopWidth2) / 2.0f)), (int)(nX[i + 1] * fScaleX), (int)(nY[i + 1] * fScaleY - fWidth / 2.0f));
                    } else {
                        this.draw((int)(nX[i] * fScaleX) - 1, (int)((double)(nY[i] + nY[i - 1]) / 2.0 * (double)fScaleY - (double)((fTopWidth + fTopWidth2) / 2.0f)), (int)(nX[i + 1] * fScaleX), (int)(nY[i + 1] * fScaleY - fWidth / 2.0f));
                    }
                }
                ++i;
            }
        }
        this.m_buf.append("'/>\n");
    }
}

