/*
 * Decompiled with CFR 0.152.
 */
package viz;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.text.DecimalFormat;
import viz.DensiTree;
import viz.RotationPoint;

public class CladeDrawer {
    DensiTree m_dt;
    public Font m_font;
    public Color m_color;
    public int m_nSignificantDigits = 3;
    public boolean m_bDrawMean = false;
    public boolean m_bDrawSupport = true;
    public boolean m_bDraw95HPD = false;
    public boolean m_bTextMean = false;
    public boolean m_bTextSupport = false;
    public boolean m_bText95HPD = false;
    public boolean m_bSelectedOnly = false;

    CladeDrawer(DensiTree dt) {
        this.m_dt = dt;
        this.m_font = Font.getFont("default");
        this.m_color = Color.black;
    }

    void viewClades(Graphics g) {
        float fScaleX = this.m_dt.m_fScaleX;
        float fScaleY = this.m_dt.m_fScaleY;
        g.setFont(this.m_font);
        g.setColor(this.m_color);
        if (this.m_dt.m_bUseLogScale) {
            if (this.m_dt.m_treeDrawer.m_bRootAtTop) {
                fScaleY *= this.m_dt.m_fHeight / (float)Math.log((double)this.m_dt.m_fHeight + 1.0);
            } else {
                fScaleX *= this.m_dt.m_fHeight / (float)Math.log((double)this.m_dt.m_fHeight + 1.0);
            }
        }
        int x = 0;
        int y = 0;
        BasicStroke stroke = new BasicStroke(1.0f, 0, 2);
        ((Graphics2D)g).setStroke(stroke);
        ((Graphics2D)g).setComposite(AlphaComposite.getInstance(3, 1.0f));
        int h = this.m_dt.m_rotate.getHeight(null);
        int w = this.m_dt.m_rotate.getWidth(null);
        boolean bUpdatePoints = false;
        if (this.m_dt.m_Panel.m_rotationPoints == null) {
            this.m_dt.m_Panel.m_rotationPoints = new RotationPoint[this.m_dt.m_cladeHeight.size()];
            bUpdatePoints = true;
        }
        String format = this.m_nSignificantDigits > 0 ? "##." : "##";
        int i = 0;
        while (i < this.m_nSignificantDigits) {
            format = String.valueOf(format) + "#";
            ++i;
        }
        DecimalFormat formatter = new DecimalFormat(format);
        formatter.setMinimumFractionDigits(this.m_nSignificantDigits);
        formatter.setMaximumFractionDigits(this.m_nSignificantDigits);
        DecimalFormat supportFormatter = new DecimalFormat(format);
        int i22 = 0;
        while (i22 < this.m_dt.m_cladeHeight.size()) {
            if (this.m_dt.m_cladeWeight.get(i22) > this.m_dt.m_smallestCladeSupport && (this.m_dt.m_Xmode == 1 && (this.m_dt.m_clades.get(i22).length > 1 || this.m_dt.m_bLeafCladeSelection) || this.m_dt.m_Xmode == 2 && this.m_dt.m_clades.get(i22).length == 1)) {
                if (!this.m_dt.m_treeDrawer.m_bRootAtTop) {
                    x = (int)((this.m_dt.m_cladeHeight.get(i22) - (double)this.m_dt.m_fTreeOffset) * (double)fScaleX * (double)this.m_dt.m_fTreeScale);
                    y = (int)(this.m_dt.m_cladePosition[i22] * fScaleY);
                    if (this.m_bDrawMean && (!this.m_bSelectedOnly || this.m_dt.m_cladeSelection.contains(i22))) {
                        g.drawLine(x, y - 3, x, y + 6);
                    }
                    if (this.m_bTextMean && (!this.m_bSelectedOnly || this.m_dt.m_cladeSelection.contains(i22))) {
                        g.drawString(formatter.format(((double)(this.m_dt.m_gridDrawer.m_fGridOrigin + this.m_dt.m_fHeight) - this.m_dt.m_cladeHeight.get(i22)) * (double)this.m_dt.m_fUserScale), x, y - 1);
                    }
                    if (this.m_bTextSupport && (!this.m_bSelectedOnly || this.m_dt.m_cladeSelection.contains(i22))) {
                        g.drawString(supportFormatter.format(100.0 * this.m_dt.m_cladeWeight.get(i22)), x, y + g.getFont().getSize() + 1);
                    }
                } else {
                    x = (int)(this.m_dt.m_cladePosition[i22] * fScaleX);
                    y = (int)((this.m_dt.m_cladeHeight.get(i22) - (double)this.m_dt.m_fTreeOffset) * (double)fScaleY * (double)this.m_dt.m_fTreeScale);
                    if (this.m_bDrawMean && (!this.m_bSelectedOnly || this.m_dt.m_cladeSelection.contains(i22))) {
                        g.drawLine(x - 3, y, x + 3, y);
                    }
                    if (this.m_bTextMean && (!this.m_bSelectedOnly || this.m_dt.m_cladeSelection.contains(i22))) {
                        g.drawString(formatter.format(((double)(this.m_dt.m_gridDrawer.m_fGridOrigin + this.m_dt.m_fHeight) - this.m_dt.m_cladeHeight.get(i22)) * (double)this.m_dt.m_fUserScale), x, y - 1);
                    }
                    if (this.m_bTextSupport && (!this.m_bSelectedOnly || this.m_dt.m_cladeSelection.contains(i22))) {
                        g.drawString(supportFormatter.format(100.0 * this.m_dt.m_cladeWeight.get(i22)), x, y + g.getFont().getSize() + 1);
                    }
                }
            } else {
                x = -100;
                y = -100;
            }
            h = w = (int)(10.0 + this.m_dt.m_cladeWeight.get(i22) * 10.0);
            if (this.m_bDrawSupport && (!this.m_bSelectedOnly || this.m_dt.m_cladeSelection.contains(i22))) {
                g.drawOval(x - w / 2, y - h / 2, w, h);
            }
            if (bUpdatePoints) {
                this.m_dt.m_Panel.m_rotationPoints[i22] = new RotationPoint(x, y);
            }
            if (!this.m_dt.m_treeDrawer.m_bRootAtTop) {
                x = (int)((this.m_dt.m_cladeHeight95HPDdown.get(i22) - (double)this.m_dt.m_fTreeOffset) * (double)fScaleX * (double)this.m_dt.m_fTreeScale);
                w = -x + (int)((this.m_dt.m_cladeHeight95HPDup.get(i22) - (double)this.m_dt.m_fTreeOffset) * (double)fScaleX * (double)this.m_dt.m_fTreeScale);
                h = 3;
                if (this.m_bText95HPD && (!this.m_bSelectedOnly || this.m_dt.m_cladeSelection.contains(i22))) {
                    g.drawString(formatter.format((this.m_dt.m_cladeHeight95HPDup.get(i22) - this.m_dt.m_cladeHeight95HPDdown.get(i22)) * (double)this.m_dt.m_fUserScale), x, y - 1);
                }
            } else {
                y = (int)((this.m_dt.m_cladeHeight95HPDdown.get(i22) - (double)this.m_dt.m_fTreeOffset) * (double)fScaleY * (double)this.m_dt.m_fTreeScale);
                w = 3;
                h = -y + (int)((this.m_dt.m_cladeHeight95HPDup.get(i22) - (double)this.m_dt.m_fTreeOffset) * (double)fScaleY * (double)this.m_dt.m_fTreeScale);
                if (this.m_bText95HPD && (!this.m_bSelectedOnly || this.m_dt.m_cladeSelection.contains(i22))) {
                    g.drawString(formatter.format((this.m_dt.m_cladeHeight95HPDup.get(i22) - this.m_dt.m_cladeHeight95HPDdown.get(i22)) * (double)this.m_dt.m_fUserScale), x, y - 1);
                }
            }
            if (this.m_bDraw95HPD && (!this.m_bSelectedOnly || this.m_dt.m_cladeSelection.contains(i22))) {
                g.drawRect(x, y, w, h);
            }
            ++i22;
        }
        if (!this.m_bSelectedOnly) {
            stroke = new BasicStroke(3.0f, 0, 2);
            ((Graphics2D)g).setStroke(stroke);
            ((Graphics2D)g).setComposite(AlphaComposite.getInstance(3, 1.0f));
            for (int i22 : this.m_dt.m_cladeSelection) {
                if (!this.m_dt.m_treeDrawer.m_bRootAtTop) {
                    x = (int)((this.m_dt.m_cladeHeight.get(i22) - (double)this.m_dt.m_fTreeOffset) * (double)fScaleX * (double)this.m_dt.m_fTreeScale);
                    y = (int)(this.m_dt.m_cladePosition[i22] * fScaleY);
                } else {
                    x = (int)(this.m_dt.m_cladePosition[i22] * fScaleX);
                    y = (int)((this.m_dt.m_cladeHeight.get(i22) - (double)this.m_dt.m_fTreeOffset) * (double)fScaleY * (double)this.m_dt.m_fTreeScale);
                }
                h = w = (int)(10.0 + this.m_dt.m_cladeWeight.get(i22) * 10.0);
                g.drawOval(x - w / 2, y - h / 2, w, h);
            }
        }
    }
}

