/*
 * Decompiled with CFR 0.152.
 */
package jam.util;

import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.RescaleOp;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.GrayFilter;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;

public class IconUtils {
    public static Image getImage(String string) {
        return IconUtils.getImage(IconUtils.class, string);
    }

    private static void showWarning(final String string) {
        if (EventQueue.isDispatchThread()) {
            JOptionPane.showMessageDialog(null, string, "Warning", 2);
        } else {
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    public void run() {
                        JOptionPane.showMessageDialog(null, string, "Warning", 2);
                    }
                });
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
            }
        }
    }

    public static Image getImage(Class clazz, String string) {
        URL uRL = clazz.getResource(string);
        if (uRL != null) {
            return Toolkit.getDefaultToolkit().createImage(uRL);
        }
        IconUtils.showWarning("Image " + string + " could not be loaded.");
        return null;
    }

    public static BufferedImage getBufferedImage(String string) {
        return IconUtils.getBufferedImage(IconUtils.class, string);
    }

    public static BufferedImage getBufferedImage(Class clazz, String string) {
        URL uRL = clazz.getResource(string);
        if (uRL != null) {
            try {
                return ImageIO.read(uRL);
            }
            catch (IOException iOException) {
                IconUtils.showWarning("Image " + string + " could not be loaded.");
                return null;
            }
        }
        return null;
    }

    public static Icon getIcon(String string) {
        return IconUtils.getIcon(IconUtils.class, string);
    }

    public static Icon getIcon(Class clazz, String string) {
        Image image = IconUtils.getImage(clazz, string);
        if (image != null) {
            return new ImageIcon(image);
        }
        return null;
    }

    public static Icon brighten(Icon icon) {
        BufferedImage bufferedImage = IconUtils.getBufferedImageFromIcon(icon);
        if (bufferedImage == null) {
            return icon;
        }
        RescaleOp rescaleOp = new RescaleOp(1.25f, 0.0f, null);
        return new ImageIcon(rescaleOp.filter(bufferedImage, null));
    }

    public static Icon darken(Icon icon) {
        BufferedImage bufferedImage = IconUtils.getBufferedImageFromIcon(icon);
        if (bufferedImage == null) {
            return icon;
        }
        RescaleOp rescaleOp = new RescaleOp(0.75f, 0.0f, null);
        return new ImageIcon(rescaleOp.filter(bufferedImage, null));
    }

    public static Icon gray(Icon icon) {
        BufferedImage bufferedImage = IconUtils.getBufferedImageFromIcon(icon);
        if (bufferedImage == null) {
            return icon;
        }
        return new ImageIcon(GrayFilter.createDisabledImage(bufferedImage));
    }

    public static Icon resize(Icon icon, int n, int n2) {
        Image image = IconUtils.getImageFromIcon(icon);
        if (image == null) {
            return icon;
        }
        image = image.getScaledInstance(n, n2, 4);
        return new ImageIcon(image);
    }

    public static Image getImageFromIcon(Icon icon) {
        if (icon instanceof ImageIcon) {
            return ((ImageIcon)icon).getImage();
        }
        return IconUtils.getBufferedImageFromIcon(icon);
    }

    public static BufferedImage getBufferedImageFromIcon(Icon icon) {
        BufferedImage bufferedImage = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
        Graphics graphics = bufferedImage.getGraphics();
        icon.paintIcon(new JLabel(), graphics, 0, 0);
        graphics.dispose();
        return bufferedImage;
    }
}

