/*
 * Decompiled with CFR 0.152.
 */
package beast.app.beastapp;

import beast.app.beastapp.BeastMain;
import beast.app.util.Utils6;
import java.awt.GraphicsEnvironment;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import javax.swing.JOptionPane;

public class BeastLauncher {
    private static String pathDelimiter;

    private static String getVersion() {
        return "2.4.7";
    }

    private static String getMajorVersion() {
        return "2.4";
    }

    public static void main(String[] stringArray) throws NoSuchMethodException, SecurityException, ClassNotFoundException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, IOException {
        if (BeastLauncher.javaVersionCheck("BEAST")) {
            BeastLauncher.loadBEASTJars();
            Utils6.testCudaStatusOnMac();
            BeastMain.main((String[])stringArray);
        }
    }

    protected static void loadBEASTJars() throws IOException, NoSuchMethodException, SecurityException, ClassNotFoundException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        BeastLauncher beastLauncher = new BeastLauncher();
        String string = BeastLauncher.getPackageUserDir();
        pathDelimiter = BeastLauncher.isWindows() ? "\\\\" : "/";
        string = string + pathDelimiter + "BEAST" + pathDelimiter;
        String string2 = string + "lib";
        boolean bl = BeastLauncher.checkForBEAST(new File(string2), beastLauncher);
        String string3 = beastLauncher.getClass().getProtectionDomain().getCodeSource().getLocation().getPath();
        string3 = URLDecoder.decode(string3, "UTF-8");
        System.err.println("jardir = " + string3);
        for (File file = new File(string3).getParentFile(); !bl && file != null; file = file.getParentFile()) {
            bl = BeastLauncher.checkForBEAST(file, beastLauncher);
            boolean bl2 = bl = bl || BeastLauncher.checkForBEAST(new File(file.getAbsolutePath() + pathDelimiter + "lib"), beastLauncher);
            if (!bl) continue;
            BeastLauncher.createBeastPackage(file);
        }
        if (!bl) {
            System.err.println("WARNING: could not find beast.jar");
        }
        Method method = Class.forName("beast.evolution.alignment.Alignment").getMethod("findDataTypes", new Class[0]);
        method.invoke(null, new Object[0]);
    }

    private static void createBeastPackage(File file) {
        try {
            String string;
            File file2;
            if (file.toString().toLowerCase().endsWith("lib")) {
                file = file.getParentFile();
            }
            if (!(file2 = new File((string = BeastLauncher.getPackageUserDir()) + pathDelimiter + "BEAST" + pathDelimiter + "lib")).exists() && !file2.mkdirs()) {
                return;
            }
            File file3 = new File(string + pathDelimiter + "BEAST" + pathDelimiter + "examples" + pathDelimiter + "nexus");
            if (!file3.exists() && !file3.mkdirs()) {
                return;
            }
            File file4 = new File(string + pathDelimiter + "BEAST" + pathDelimiter + "templates");
            if (!file4.exists() && !file4.mkdirs()) {
                return;
            }
            File file5 = new File(file + pathDelimiter + "lib" + pathDelimiter + "beast.jar");
            File file6 = new File(file2 + pathDelimiter + "beast.jar");
            BeastLauncher.copyFileUsingStream(file5, file6);
            String string2 = "<addon name='BEAST' version='" + BeastLauncher.getVersion() + "'>\n" + "</addon>";
            FileWriter fileWriter = new FileWriter(string + pathDelimiter + "BEAST" + pathDelimiter + "version.xml");
            fileWriter.write(string2);
            fileWriter.close();
            File file7 = new File(file + pathDelimiter + "lib" + pathDelimiter + "beast.src.jar");
            File file8 = new File(file2 + pathDelimiter + "beast.src.jar");
            BeastLauncher.copyFileUsingStream(file7, file8);
            BeastLauncher.copyFilesInDir(new File(file + pathDelimiter + "examples"), new File(string + pathDelimiter + "BEAST" + pathDelimiter + "examples"));
            BeastLauncher.copyFilesInDir(new File(file + pathDelimiter + "examples" + pathDelimiter + "nexus"), file3);
            BeastLauncher.copyFilesInDir(new File(file + pathDelimiter + "templates"), file4);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static void copyFilesInDir(File file, File file2) throws IOException {
        String string = file2.getAbsolutePath();
        for (File file3 : file.listFiles()) {
            if (!file3.isFile()) continue;
            BeastLauncher.copyFileUsingStream(file3, new File(string + pathDelimiter + file3.getName()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyFileUsingStream(File file, File file2) throws IOException {
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            int n;
            inputStream = new FileInputStream(file);
            outputStream = new FileOutputStream(file2);
            byte[] byArray = new byte[1024];
            while ((n = inputStream.read(byArray)) > 0) {
                outputStream.write(byArray, 0, n);
            }
        }
        finally {
            inputStream.close();
            outputStream.close();
        }
    }

    private static boolean checkForBEAST(File file, Object object) throws IOException {
        System.err.println("Checking out " + file.getAbsolutePath());
        boolean bl = false;
        if (file.exists()) {
            URL uRL = new URL("file://" + (BeastLauncher.isWindows() ? "/" : "") + file.getAbsolutePath() + "/beast.jar");
            if (new File(file.getAbsoluteFile() + File.separator + "beast.jar").exists()) {
                Object object2;
                Object object3;
                Object object4;
                Closeable closeable;
                File file2 = new File(file.getParent() + pathDelimiter + "version.xml");
                if (file2.exists()) {
                    closeable = new BufferedReader(new FileReader(file2));
                    object4 = null;
                    while (((BufferedReader)closeable).ready()) {
                        object4 = object4 + ((BufferedReader)closeable).readLine();
                    }
                    ((BufferedReader)closeable).close();
                    int n = ((String)object4).indexOf("version=");
                    int n2 = ((String)object4).indexOf("'", n + 9);
                    String string = ((String)object4).substring(n + 9, n2);
                    double d = BeastLauncher.parseVersion(string);
                    double d2 = BeastLauncher.parseVersion(BeastLauncher.getVersion());
                    if (d < d2) {
                        return false;
                    }
                }
                closeable = (URLClassLoader)object.getClass().getClassLoader();
                object4 = URLClassLoader.class;
                try {
                    object3 = new Class[]{URL.class};
                    object2 = ((Class)object4).getDeclaredMethod("addURL", (Class<?>)object3);
                    ((Method)object2).setAccessible(true);
                    ((Method)object2).invoke((Object)closeable, uRL);
                    System.err.println("Loaded URL " + uRL);
                    bl = true;
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    throw new IOException("Error, could not add URL to system classloader");
                }
                object3 = System.getProperty("java.class.path");
                object2 = uRL + "";
                object3 = (String)object3 + System.getProperty("path.separator") + ((String)object2).substring(5);
                System.setProperty("java.class.path", (String)object3);
            }
        }
        return bl;
    }

    static boolean isMac() {
        return System.getProperty("os.name").toLowerCase().startsWith("mac");
    }

    static boolean isWindows() {
        return System.getProperty("os.name").toLowerCase().startsWith("windows");
    }

    static boolean isLinux() {
        return System.getProperty("os.name").toLowerCase().startsWith("linux");
    }

    protected static boolean javaVersionCheck(String string) {
        String string2 = System.getProperty("java.version");
        String[] stringArray = string2.split("\\.");
        if (stringArray.length > 2) {
            try {
                int n = Integer.parseInt(stringArray[1]);
                if (n <= 7) {
                    String string3 = "<html>" + string + " requires Java version 8,<br>" + "but the current version is " + n + ".<br><br>" + "You can get Java from <a href='https://www.java.com/en/'>https://www.java.com/</a>.<br><br> " + "Continuing, but expect the unexpected.</html>";
                    if (!GraphicsEnvironment.isHeadless()) {
                        JOptionPane.showMessageDialog(null, string3);
                    } else {
                        string3 = string3.replaceAll("<br>", "\n");
                        string3 = string3.replaceAll("<[^<]*>", "");
                        System.err.println(string3);
                    }
                    return true;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return true;
        }
        return true;
    }

    public static String getPackageUserDir() {
        if (System.getProperty("beast.user.package.dir") != null) {
            return System.getProperty("beast.user.package.dir");
        }
        if (Utils6.isWindows()) {
            return System.getProperty("user.home") + "\\BEAST\\" + BeastLauncher.getMajorVersion();
        }
        if (Utils6.isMac()) {
            return System.getProperty("user.home") + "/Library/Application Support/BEAST/" + BeastLauncher.getMajorVersion();
        }
        return System.getProperty("user.home") + "/.beast/" + BeastLauncher.getMajorVersion();
    }

    private static double parseVersion(String string) {
        String[] stringArray = string.split("\\.");
        double d = 0.0;
        double d2 = 1.0;
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                d += Double.parseDouble(stringArray[i]) / d2;
                d2 *= 100.0;
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return d;
    }
}

