/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.distribution;

import java.io.Serializable;
import org.apache.commons.math.MathException;
import org.apache.commons.math.MathRuntimeException;
import org.apache.commons.math.MaxIterationsExceededException;
import org.apache.commons.math.distribution.AbstractContinuousDistribution;
import org.apache.commons.math.distribution.NormalDistribution;
import org.apache.commons.math.special.Erf;

public class NormalDistributionImpl
extends AbstractContinuousDistribution
implements NormalDistribution,
Serializable {
    public static final double DEFAULT_INVERSE_ABSOLUTE_ACCURACY = 1.0E-9;
    private static final long serialVersionUID = 8589540077390120676L;
    private static final double SQRT2PI = Math.sqrt(Math.PI * 2);
    private double mean = 0.0;
    private double standardDeviation = 1.0;
    private final double solverAbsoluteAccuracy;

    public NormalDistributionImpl(double d, double d2) {
        this(d, d2, 1.0E-9);
    }

    public NormalDistributionImpl(double d, double d2, double d3) {
        this.setMeanInternal(d);
        this.setStandardDeviationInternal(d2);
        this.solverAbsoluteAccuracy = d3;
    }

    public NormalDistributionImpl() {
        this(0.0, 1.0);
    }

    @Override
    public double getMean() {
        return this.mean;
    }

    @Override
    @Deprecated
    public void setMean(double d) {
        this.setMeanInternal(d);
    }

    private void setMeanInternal(double d) {
        this.mean = d;
    }

    @Override
    public double getStandardDeviation() {
        return this.standardDeviation;
    }

    @Override
    @Deprecated
    public void setStandardDeviation(double d) {
        this.setStandardDeviationInternal(d);
    }

    private void setStandardDeviationInternal(double d) {
        if (d <= 0.0) {
            throw MathRuntimeException.createIllegalArgumentException("standard deviation must be positive ({0})", d);
        }
        this.standardDeviation = d;
    }

    @Override
    @Deprecated
    public double density(Double d) {
        return this.density((double)d);
    }

    @Override
    public double density(double d) {
        double d2 = d - this.mean;
        return Math.exp(-d2 * d2 / (2.0 * this.standardDeviation * this.standardDeviation)) / (this.standardDeviation * SQRT2PI);
    }

    @Override
    public double logDensity(double d) {
        double d2 = 1.0 / (Math.sqrt(Math.PI * 2) * this.standardDeviation);
        double d3 = -(d - this.mean) * (d - this.mean) / (2.0 * this.standardDeviation * this.standardDeviation);
        return Math.log(d2) + d3;
    }

    @Override
    public double cumulativeProbability(double d) throws MathException {
        try {
            return 0.5 * (1.0 + Erf.erf((d - this.mean) / (this.standardDeviation * Math.sqrt(2.0))));
        }
        catch (MaxIterationsExceededException maxIterationsExceededException) {
            if (d < this.mean - 20.0 * this.standardDeviation) {
                return 0.0;
            }
            if (d > this.mean + 20.0 * this.standardDeviation) {
                return 1.0;
            }
            throw maxIterationsExceededException;
        }
    }

    @Override
    protected double getSolverAbsoluteAccuracy() {
        return this.solverAbsoluteAccuracy;
    }

    @Override
    public double inverseCumulativeProbability(double d) throws MathException {
        if (d == 0.0) {
            return Double.NEGATIVE_INFINITY;
        }
        if (d == 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        return super.inverseCumulativeProbability(d);
    }

    @Override
    protected double getDomainLowerBound(double d) {
        double d2 = d < 0.5 ? -1.7976931348623157E308 : this.mean;
        return d2;
    }

    @Override
    protected double getDomainUpperBound(double d) {
        double d2 = d < 0.5 ? this.mean : Double.MAX_VALUE;
        return d2;
    }

    @Override
    protected double getInitialDomain(double d) {
        double d2 = d < 0.5 ? this.mean - this.standardDeviation : (d > 0.5 ? this.mean + this.standardDeviation : this.mean);
        return d2;
    }
}

