/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.distribution;

import org.apache.commons.math.MathException;
import org.apache.commons.math.MathRuntimeException;
import org.apache.commons.math.distribution.AbstractContinuousDistribution;
import org.apache.commons.math.distribution.BetaDistribution;
import org.apache.commons.math.special.Beta;
import org.apache.commons.math.special.Gamma;

public class BetaDistributionImpl
extends AbstractContinuousDistribution
implements BetaDistribution {
    public static final double DEFAULT_INVERSE_ABSOLUTE_ACCURACY = 1.0E-9;
    private static final long serialVersionUID = -1221965979403477668L;
    private double alpha;
    private double beta;
    private double z;
    private final double solverAbsoluteAccuracy;

    public BetaDistributionImpl(double d, double d2, double d3) {
        this.alpha = d;
        this.beta = d2;
        this.z = Double.NaN;
        this.solverAbsoluteAccuracy = d3;
    }

    public BetaDistributionImpl(double d, double d2) {
        this(d, d2, 1.0E-9);
    }

    @Override
    @Deprecated
    public void setAlpha(double d) {
        this.alpha = d;
        this.z = Double.NaN;
    }

    @Override
    public double getAlpha() {
        return this.alpha;
    }

    @Override
    @Deprecated
    public void setBeta(double d) {
        this.beta = d;
        this.z = Double.NaN;
    }

    @Override
    public double getBeta() {
        return this.beta;
    }

    private void recomputeZ() {
        if (Double.isNaN(this.z)) {
            this.z = Gamma.logGamma(this.alpha) + Gamma.logGamma(this.beta) - Gamma.logGamma(this.alpha + this.beta);
        }
    }

    @Override
    @Deprecated
    public double density(Double d) {
        return this.density((double)d);
    }

    @Override
    public double density(double d) {
        this.recomputeZ();
        if (d < 0.0 || d > 1.0) {
            return 0.0;
        }
        if (d == 0.0) {
            if (this.alpha < 1.0) {
                throw MathRuntimeException.createIllegalArgumentException("Cannot compute beta density at 0 when alpha = {0,number}", this.alpha);
            }
            return 0.0;
        }
        if (d == 1.0) {
            if (this.beta < 1.0) {
                throw MathRuntimeException.createIllegalArgumentException("Cannot compute beta density at 1 when beta = %.3g", this.beta);
            }
            return 0.0;
        }
        double d2 = Math.log(d);
        double d3 = Math.log1p(-d);
        return Math.exp((this.alpha - 1.0) * d2 + (this.beta - 1.0) * d3 - this.z);
    }

    @Override
    public double inverseCumulativeProbability(double d) throws MathException {
        if (d == 0.0) {
            return 0.0;
        }
        if (d == 1.0) {
            return 1.0;
        }
        return super.inverseCumulativeProbability(d);
    }

    @Override
    protected double getInitialDomain(double d) {
        return d;
    }

    @Override
    protected double getDomainLowerBound(double d) {
        return 0.0;
    }

    @Override
    protected double getDomainUpperBound(double d) {
        return 1.0;
    }

    @Override
    public double cumulativeProbability(double d) throws MathException {
        if (d <= 0.0) {
            return 0.0;
        }
        if (d >= 1.0) {
            return 1.0;
        }
        return Beta.regularizedBeta(d, this.alpha, this.beta);
    }

    @Override
    public double cumulativeProbability(double d, double d2) throws MathException {
        return this.cumulativeProbability(d2) - this.cumulativeProbability(d);
    }

    @Override
    protected double getSolverAbsoluteAccuracy() {
        return this.solverAbsoluteAccuracy;
    }
}

