/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.distribution;

import java.io.Serializable;
import org.apache.commons.math.ConvergenceException;
import org.apache.commons.math.FunctionEvaluationException;
import org.apache.commons.math.MathException;
import org.apache.commons.math.MathRuntimeException;
import org.apache.commons.math.analysis.UnivariateRealFunction;
import org.apache.commons.math.analysis.solvers.UnivariateRealSolverUtils;
import org.apache.commons.math.distribution.AbstractDistribution;
import org.apache.commons.math.distribution.ContinuousDistribution;

public abstract class AbstractContinuousDistribution
extends AbstractDistribution
implements ContinuousDistribution,
Serializable {
    private static final long serialVersionUID = -38038050983108802L;
    private double solverAbsoluteAccuracy = 1.0E-6;

    protected AbstractContinuousDistribution() {
    }

    @Override
    public double density(double d) throws MathRuntimeException {
        throw new MathRuntimeException(new UnsupportedOperationException(), "This distribution does not have a density function implemented", new Object[0]);
    }

    @Override
    public double logDensity(double d) {
        return Math.log(this.density(d));
    }

    @Override
    public double inverseCumulativeProbability(final double d) throws MathException {
        if (d < 0.0 || d > 1.0) {
            throw MathRuntimeException.createIllegalArgumentException("{0} out of [{1}, {2}] range", d, 0.0, 1.0);
        }
        UnivariateRealFunction univariateRealFunction = new UnivariateRealFunction(){

            @Override
            public double value(double d3) throws FunctionEvaluationException {
                double d2 = Double.NaN;
                try {
                    d2 = AbstractContinuousDistribution.this.cumulativeProbability(d3) - d;
                }
                catch (MathException mathException) {
                    throw new FunctionEvaluationException((Throwable)mathException, d3, mathException.getPattern(), mathException.getArguments());
                }
                if (Double.isNaN(d2)) {
                    throw new FunctionEvaluationException(d3, "Cumulative probability function returned NaN for argument {0} p = {1}", d3, d);
                }
                return d2;
            }
        };
        double d2 = this.getDomainLowerBound(d);
        double d3 = this.getDomainUpperBound(d);
        double[] dArray = null;
        try {
            dArray = UnivariateRealSolverUtils.bracket(univariateRealFunction, this.getInitialDomain(d), d2, d3);
        }
        catch (ConvergenceException convergenceException) {
            if (Math.abs(univariateRealFunction.value(d2)) < this.getSolverAbsoluteAccuracy()) {
                return d2;
            }
            if (Math.abs(univariateRealFunction.value(d3)) < this.getSolverAbsoluteAccuracy()) {
                return d3;
            }
            throw new MathException(convergenceException);
        }
        double d4 = 10.0 * this.getSolverAbsoluteAccuracy();
        double d5 = 0.0;
        while (Math.abs(d5) < 1000.0 * d4 && d4 > 1.0E-320) {
            d5 = UnivariateRealSolverUtils.solve(univariateRealFunction, dArray[0], dArray[1], d4 /= 10.0);
        }
        if (Math.abs(d5) < d4) {
            d5 = 0.0;
        }
        return d5;
    }

    protected abstract double getInitialDomain(double var1);

    protected abstract double getDomainLowerBound(double var1);

    protected abstract double getDomainUpperBound(double var1);

    protected double getSolverAbsoluteAccuracy() {
        return this.solverAbsoluteAccuracy;
    }
}

