/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.analysis.solvers;

import org.apache.commons.math.ConvergenceException;
import org.apache.commons.math.FunctionEvaluationException;
import org.apache.commons.math.MaxIterationsExceededException;
import org.apache.commons.math.analysis.UnivariateRealFunction;
import org.apache.commons.math.analysis.solvers.UnivariateRealSolverImpl;
import org.apache.commons.math.util.MathUtils;

public class RiddersSolver
extends UnivariateRealSolverImpl {
    @Deprecated
    public RiddersSolver(UnivariateRealFunction univariateRealFunction) {
        super(univariateRealFunction, 100, 1.0E-6);
    }

    public RiddersSolver() {
        super(100, 1.0E-6);
    }

    @Override
    @Deprecated
    public double solve(double d, double d2) throws ConvergenceException, FunctionEvaluationException {
        return this.solve(this.f, d, d2);
    }

    @Override
    @Deprecated
    public double solve(double d, double d2, double d3) throws ConvergenceException, FunctionEvaluationException {
        return this.solve(this.f, d, d2, d3);
    }

    @Override
    public double solve(UnivariateRealFunction univariateRealFunction, double d, double d2, double d3) throws MaxIterationsExceededException, FunctionEvaluationException {
        if (univariateRealFunction.value(d) == 0.0) {
            return d;
        }
        if (univariateRealFunction.value(d2) == 0.0) {
            return d2;
        }
        if (univariateRealFunction.value(d3) == 0.0) {
            return d3;
        }
        this.verifyBracketing(d, d2, univariateRealFunction);
        this.verifySequence(d, d3, d2);
        if (this.isBracketing(d, d3, univariateRealFunction)) {
            return this.solve(univariateRealFunction, d, d3);
        }
        return this.solve(univariateRealFunction, d3, d2);
    }

    @Override
    public double solve(UnivariateRealFunction univariateRealFunction, double d, double d2) throws MaxIterationsExceededException, FunctionEvaluationException {
        double d3 = d;
        double d4 = univariateRealFunction.value(d3);
        double d5 = d2;
        double d6 = univariateRealFunction.value(d5);
        if (d4 == 0.0) {
            return d;
        }
        if (d6 == 0.0) {
            return d2;
        }
        this.verifyBracketing(d, d2, univariateRealFunction);
        double d7 = Double.POSITIVE_INFINITY;
        for (int i = 1; i <= this.maximalIterationCount; ++i) {
            double d8 = 0.5 * (d3 + d5);
            double d9 = univariateRealFunction.value(d8);
            if (Math.abs(d9) <= this.functionValueAccuracy) {
                this.setResult(d8, i);
                return this.result;
            }
            double d10 = 1.0 - d4 * d6 / (d9 * d9);
            double d11 = MathUtils.sign(d6) * MathUtils.sign(d9) * (d8 - d3) / Math.sqrt(d10);
            double d12 = d8 - d11;
            double d13 = univariateRealFunction.value(d12);
            double d14 = Math.max(this.relativeAccuracy * Math.abs(d12), this.absoluteAccuracy);
            if (Math.abs(d12 - d7) <= d14) {
                this.setResult(d12, i);
                return this.result;
            }
            if (Math.abs(d13) <= this.functionValueAccuracy) {
                this.setResult(d12, i);
                return this.result;
            }
            if (d11 > 0.0) {
                if (MathUtils.sign(d4) + MathUtils.sign(d13) == 0.0) {
                    d5 = d12;
                    d6 = d13;
                } else {
                    d3 = d12;
                    d5 = d8;
                    d4 = d13;
                    d6 = d9;
                }
            } else if (MathUtils.sign(d6) + MathUtils.sign(d13) == 0.0) {
                d3 = d12;
                d4 = d13;
            } else {
                d3 = d8;
                d5 = d12;
                d4 = d9;
                d6 = d13;
            }
            d7 = d12;
        }
        throw new MaxIterationsExceededException(this.maximalIterationCount);
    }
}

