/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.analysis.integration;

import org.apache.commons.math.ConvergingAlgorithmImpl;
import org.apache.commons.math.MathRuntimeException;
import org.apache.commons.math.analysis.UnivariateRealFunction;
import org.apache.commons.math.analysis.integration.UnivariateRealIntegrator;

public abstract class UnivariateRealIntegratorImpl
extends ConvergingAlgorithmImpl
implements UnivariateRealIntegrator {
    protected int minimalIterationCount;
    protected int defaultMinimalIterationCount;
    protected boolean resultComputed = false;
    protected double result;
    @Deprecated
    protected UnivariateRealFunction f;

    @Deprecated
    protected UnivariateRealIntegratorImpl(UnivariateRealFunction univariateRealFunction, int n) throws IllegalArgumentException {
        super(n, 1.0E-15);
        if (univariateRealFunction == null) {
            throw MathRuntimeException.createIllegalArgumentException("function is null", new Object[0]);
        }
        this.f = univariateRealFunction;
        this.setRelativeAccuracy(1.0E-6);
        this.minimalIterationCount = this.defaultMinimalIterationCount = 3;
        this.verifyIterationCount();
    }

    protected UnivariateRealIntegratorImpl(int n) throws IllegalArgumentException {
        super(n, 1.0E-15);
        this.setRelativeAccuracy(1.0E-6);
        this.minimalIterationCount = this.defaultMinimalIterationCount = 3;
        this.verifyIterationCount();
    }

    @Override
    public double getResult() throws IllegalStateException {
        if (this.resultComputed) {
            return this.result;
        }
        throw MathRuntimeException.createIllegalStateException("no result available", new Object[0]);
    }

    protected final void setResult(double d, int n) {
        this.result = d;
        this.iterationCount = n;
        this.resultComputed = true;
    }

    protected final void clearResult() {
        this.iterationCount = 0;
        this.resultComputed = false;
    }

    @Override
    public void setMinimalIterationCount(int n) {
        this.minimalIterationCount = n;
    }

    @Override
    public int getMinimalIterationCount() {
        return this.minimalIterationCount;
    }

    @Override
    public void resetMinimalIterationCount() {
        this.minimalIterationCount = this.defaultMinimalIterationCount;
    }

    protected void verifyInterval(double d, double d2) throws IllegalArgumentException {
        if (d >= d2) {
            throw MathRuntimeException.createIllegalArgumentException("endpoints do not specify an interval: [{0}, {1}]", d, d2);
        }
    }

    protected void verifyIterationCount() throws IllegalArgumentException {
        if (this.minimalIterationCount <= 0 || this.maximalIterationCount <= this.minimalIterationCount) {
            throw MathRuntimeException.createIllegalArgumentException("invalid iteration limits: min={0}, max={1}", this.minimalIterationCount, this.maximalIterationCount);
        }
    }
}

