/*
 * Decompiled with CFR 0.152.
 */
package jam.panels;

import jam.panels.StatusListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public interface StatusProvider {
    public void addStatusListener(StatusListener var1);

    public void removeStatusListener(StatusListener var1);

    public void fireStatusChanged(int var1, String var2);

    public void statusButtonPressed();

    public String getStatusText();

    public int getStatus();

    public void fireStatusButtonPressed();

    public void addOverrideProvider(StatusProvider var1);

    public void removeOverrideProvider(StatusProvider var1);

    public static class Helper
    implements StatusProvider {
        private int lastStatus = 0;
        private String lastStatusText = "";
        private List listeners = new ArrayList();
        private List overrideListeners = new ArrayList();
        private List overrideProviders = new ArrayList();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addStatusListener(StatusListener statusListener) {
            Helper helper = this;
            synchronized (helper) {
                this.listeners.add(statusListener);
            }
            statusListener.statusChanged(this.lastStatus, this.lastStatusText);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void removeStatusListener(StatusListener statusListener) {
            Helper helper = this;
            synchronized (helper) {
                this.listeners.remove(statusListener);
            }
            statusListener.statusChanged(0, "");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void realFireStatusChanged() {
            ArrayList listeners;
            String statusText;
            int status;
            StatusProvider override = null;
            Helper helper = this;
            synchronized (helper) {
                status = this.lastStatus;
                statusText = this.lastStatusText;
                int index = this.overrideProviders.size() - 1;
                if (index >= 0) {
                    override = (StatusProvider)this.overrideProviders.get(index);
                }
                listeners = new ArrayList(this.listeners);
            }
            if (override != null) {
                status = override.getStatus();
                statusText = override.getStatusText();
            }
            Iterator i = listeners.iterator();
            while (i.hasNext()) {
                ((StatusListener)i.next()).statusChanged(status, statusText);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void fireStatusChanged(int status, String statusText) {
            Helper helper = this;
            synchronized (helper) {
                this.lastStatus = status;
                this.lastStatusText = statusText;
            }
            this.realFireStatusChanged();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addOverrideProvider(final StatusProvider provider) {
            StatusListener listener = new StatusListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void statusChanged(int status, String statusText) {
                    boolean needToFireStatusChange;
                    Helper helper = this;
                    synchronized (helper) {
                        needToFireStatusChange = overrideProviders.size() > 0 && overrideProviders.get(overrideProviders.size() - 1) == provider;
                    }
                    if (needToFireStatusChange) {
                        this.realFireStatusChanged();
                    }
                }
            };
            Helper helper = this;
            synchronized (helper) {
                provider.addStatusListener(listener);
                this.overrideProviders.add(provider);
                this.overrideListeners.add(listener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeOverrideProvider(StatusProvider provider) {
            Helper helper = this;
            synchronized (helper) {
                int i = 0;
                while (i < this.overrideProviders.size()) {
                    if (this.overrideProviders.get(i) == provider) {
                        this.overrideProviders.remove(i);
                        StatusListener listener = (StatusListener)this.overrideListeners.get(i);
                        provider.removeStatusListener(listener);
                        this.overrideListeners.remove(i);
                        break;
                    }
                    ++i;
                }
            }
            this.realFireStatusChanged();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void fireStatusButtonPressed() {
            StatusProvider override = null;
            Helper helper = this;
            synchronized (helper) {
                int index = this.overrideProviders.size();
                if (index > 0) {
                    override = (StatusProvider)this.overrideProviders.get(index - 1);
                }
            }
            if (override != null) {
                override.fireStatusButtonPressed();
            } else {
                this.statusButtonPressed();
            }
        }

        @Override
        public void statusButtonPressed() {
        }

        @Override
        public synchronized int getStatus() {
            return this.lastStatus;
        }

        @Override
        public synchronized String getStatusText() {
            return this.lastStatusText;
        }

        public synchronized boolean hasOverrideProvider() {
            return !this.overrideProviders.isEmpty();
        }
    }
}

