/*
 * Decompiled with CFR 0.152.
 */
package beast.util;

import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class XMLParserException
extends Exception {
    private static final long serialVersionUID = 1L;
    Node _node;
    String msg;
    int errorNr;

    public XMLParserException(String string) {
        super(string);
    }

    public XMLParserException(Node node, String string, int n) {
        super(string);
        this._node = node;
        string = "";
        this.errorNr = n;
    }

    @Override
    public String getMessage() {
        String string = "\nError " + this.errorNr + " parsing the xml input file\n\n" + (this.msg != null ? this.msg : "") + super.getMessage();
        if (this._node == null) {
            return "at unknown node (null)\n" + string;
        }
        String string2 = "";
        for (Node node = this._node; node != null && node.getNodeType() == 1; node = node.getParentNode()) {
            String string3 = this.getAttribute(node, "id");
            string3 = string3 != null ? " id='" + string3 + "'" : "";
            String string4 = this.getAttribute(node, "name");
            string4 = string4 != null ? " name='" + string4 + "'" : "";
            String string5 = this.getAttribute(node, "spec");
            string5 = string5 != null ? " spec='" + string5 + "'" : "";
            string2 = string2.replaceAll("  <", "      <");
            string2 = "  <" + node.getNodeName() + string3 + string4 + string5 + ">\n" + string2;
        }
        string = string + "\n\nError detected about here:\n" + string2;
        return string;
    }

    String getAttribute(Node node, String string) {
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap == null) {
            return null;
        }
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            String string2 = namedNodeMap.item(i).getNodeName();
            if (!string2.equals(string)) continue;
            String string3 = namedNodeMap.item(i).getNodeValue();
            return string3;
        }
        return null;
    }

    public String getOriginalMessage() {
        return super.getMessage();
    }
}

