/*
 * Decompiled with CFR 0.152.
 */
package beast.util;

import beast.app.BEASTVersion2;
import beast.core.BEASTInterface;
import beast.core.Input;
import beast.core.Runnable;
import beast.core.State;
import beast.core.parameter.BooleanParameter;
import beast.core.parameter.IntegerParameter;
import beast.core.parameter.Parameter;
import beast.core.parameter.RealParameter;
import beast.evolution.alignment.Alignment;
import beast.evolution.tree.TraitSet;
import beast.util.XMLParser;
import beast.util.XMLParserException;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class JSONProducer {
    Set<BEASTInterface> isDone;
    Map<BEASTInterface, Set<String>> isInputsDone;
    HashSet<String> IDs;
    int indentCount;
    public static final String DEFAULT_NAMESPACE = "beast.core:beast.evolution.alignment:beast.evolution.tree.coalescent:beast.core.util:beast.evolution.nuc:beast.evolution.operators:beast.evolution.sitemodel:beast.evolution.substitutionmodel:beast.evolution.likelihood";

    public String toJSON(BEASTInterface bEASTInterface) {
        return this.toJSON(bEASTInterface, new ArrayList<BEASTInterface>());
    }

    /*
     * WARNING - void declaration
     */
    public String toJSON(BEASTInterface bEASTInterface, Collection<BEASTInterface> collection) {
        try {
            void var6_9;
            String[] stringArray;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("{version: \"" + new BEASTVersion2().getMajorVersion() + "\",\nnamespace: \"" + DEFAULT_NAMESPACE + "\",\n\n" + "beast" + ": [\n");
            this.isDone = new HashSet<BEASTInterface>();
            this.isInputsDone = new HashMap<BEASTInterface, Set<String>>();
            this.IDs = new HashSet();
            this.indentCount = 1;
            ArrayList<BEASTInterface> arrayList = new ArrayList<BEASTInterface>();
            this.findPriorityBeastObjects(bEASTInterface, arrayList);
            for (BEASTInterface object2 : arrayList) {
                if (this.isDone.contains(object2)) continue;
                this.beastObjectToJSON(object2, BEASTInterface.class, stringBuffer, null, true);
                stringBuffer.append(",");
            }
            stringBuffer.append("\n\n");
            this.beastObjectToJSON(bEASTInterface, BEASTInterface.class, stringBuffer, null, true);
            String string = "\n]\n}";
            stringBuffer.append(string);
            String string2 = stringBuffer.toString();
            for (String string3 : stringArray = DEFAULT_NAMESPACE.split(":")) {
                String string4 = var6_9.replaceAll("spec: \"" + string3 + ".", "spec: \"");
            }
            return var6_9;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private void findPriorityBeastObjects(BEASTInterface bEASTInterface, List<BEASTInterface> list) throws IllegalArgumentException, IllegalAccessException {
        if (bEASTInterface.getClass().equals(Alignment.class)) {
            list.add(bEASTInterface);
        }
        if (bEASTInterface instanceof TraitSet) {
            list.add(bEASTInterface);
        }
        for (BEASTInterface bEASTInterface2 : bEASTInterface.listActiveBEASTObjects()) {
            this.findPriorityBeastObjects(bEASTInterface2, list);
        }
    }

    public String stateNodeToJSON(BEASTInterface bEASTInterface) {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            this.isDone = new HashSet<BEASTInterface>();
            this.IDs = new HashSet();
            this.indentCount = 1;
            this.beastObjectToJSON(bEASTInterface, null, stringBuffer, null, false);
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    void beastObjectToJSON(BEASTInterface bEASTInterface, Class<?> clazz, StringBuffer stringBuffer, String string, boolean bl) {
        String string2;
        int n;
        String string3 = "";
        for (n = 0; n < this.indentCount; ++n) {
            string3 = string3 + "\t";
        }
        ++this.indentCount;
        n = 0;
        if (string != null) {
            stringBuffer.append((this.indentCount == 1 ? "" : string3.substring(1)) + " " + string + ": {");
        } else {
            stringBuffer.append(string3 + "{");
        }
        boolean bl2 = false;
        if (this.isDone.contains(bEASTInterface)) {
            stringBuffer.append(n == 1 ? ",\n" + string3 + " " : "");
            stringBuffer.append("idref: \"" + bEASTInterface.getID() + "\" ");
            n = 1;
            bl2 = true;
        } else {
            if (bEASTInterface.getID() != null && !bEASTInterface.getID().equals("")) {
                string2 = bEASTInterface.getID();
                if (this.IDs.contains(string2)) {
                    int n2 = 1;
                    while (this.IDs.contains(string2 + n2)) {
                        ++n2;
                    }
                    string2 = string2 + n2;
                }
                stringBuffer.append(n == 1 ? ",\n" + string3 + " " : "");
                stringBuffer.append("id: \"" + this.normalise(null, string2) + "\"");
                n = 1;
                this.IDs.add(string2);
            }
            this.isDone.add(bEASTInterface);
        }
        string2 = bEASTInterface.getClass().getName();
        if (!bl2 && clazz != null && !clazz.getName().equals(string2)) {
            stringBuffer.append(n == 1 ? ",\n" + string3 + " " : "");
            stringBuffer.append("spec: \"" + string2 + "\"");
            n = 1;
        }
        if (!bl2) {
            Object object;
            List<Input<?>> list = bEASTInterface.listInputs();
            for (Input<?> object2 : list) {
                StringBuffer stringBuffer2 = new StringBuffer();
                object = object2.get();
                this.inputToJSON(object2, object, bEASTInterface, stringBuffer2, true, string3);
                if (stringBuffer2.length() <= 0) continue;
                stringBuffer.append(n == 1 ? "," : "");
                stringBuffer.append(stringBuffer2);
                n = 1;
            }
            StringBuffer stringBuffer2 = new StringBuffer();
            for (Input<?> input : list) {
                object = new StringBuffer();
                Object obj = input.get();
                this.inputToJSON(input, obj, bEASTInterface, (StringBuffer)object, false, string3);
                if (((StringBuffer)object).length() <= 0) continue;
                stringBuffer2.append(n == 1 ? ",\n" : "\n");
                stringBuffer2.append((StringBuffer)object);
                n = 1;
            }
            if (stringBuffer2.length() != 0) {
                stringBuffer.append(stringBuffer2);
            }
            --this.indentCount;
            if (n != 0) {
                stringBuffer.append("\n" + string3);
            }
            n = 1;
        } else {
            --this.indentCount;
            stringBuffer.append("");
            n = 1;
        }
        String string4 = stringBuffer.toString();
        if (string4.indexOf(125) < 0 && string4.length() < 1024) {
            string4 = string4.replaceAll("\\s+", " ");
            stringBuffer.delete(0, stringBuffer.length());
            stringBuffer.append(string3);
            stringBuffer.append(string4);
        }
        stringBuffer.append("}");
    }

    private void inputToJSON(Input input, Object object, BEASTInterface bEASTInterface, StringBuffer stringBuffer, boolean bl, String string) {
        if (object != null) {
            if (object instanceof Map) {
                if (!bl) {
                    Object object22;
                    Map map = (Map)object;
                    StringBuffer stringBuffer2 = new StringBuffer();
                    int n = 0;
                    for (Object object22 : map.keySet()) {
                        n = Math.max(n, ((String)object22).length());
                    }
                    boolean bl2 = false;
                    object22 = new ArrayList();
                    object22.addAll(map.keySet());
                    Collections.sort(object22);
                    Iterator iterator = object22.iterator();
                    while (iterator.hasNext()) {
                        String string2 = (String)iterator.next();
                        if (bl2) {
                            stringBuffer2.append(",\n");
                        }
                        stringBuffer2.append(string + " " + string2);
                        for (int i = string2.length(); i < n; ++i) {
                            stringBuffer2.append(' ');
                        }
                        stringBuffer2.append(" :\"" + map.get(string2) + "\"");
                        bl2 = true;
                    }
                    stringBuffer.append(stringBuffer2);
                }
                return;
            }
            if (input.getName().startsWith("*")) {
                return;
            }
            if (object instanceof List) {
                if (!bl) {
                    StringBuffer stringBuffer3 = new StringBuffer();
                    stringBuffer3.append(string + " " + input.getName() + ": [\n");
                    boolean bl3 = false;
                    int n = stringBuffer3.length();
                    for (Object e : (List)object) {
                        if (bl3) {
                            stringBuffer3.append(",\n");
                        }
                        StringBuffer stringBuffer4 = new StringBuffer();
                        if (e instanceof BEASTInterface) {
                            this.beastObjectToJSON((BEASTInterface)e, input.getType(), stringBuffer4, null, false);
                        } else {
                            stringBuffer3.append(e.toString());
                        }
                        stringBuffer3.append(stringBuffer4);
                        bl3 = n < stringBuffer3.length();
                    }
                    if (stringBuffer3.length() != n) {
                        stringBuffer.append(stringBuffer3);
                        stringBuffer.append("\n" + string + "  ]");
                    }
                }
                return;
            }
            if (object instanceof BEASTInterface) {
                if (!object.equals(input.defaultValue)) {
                    if (object instanceof BooleanParameter || object instanceof IntegerParameter || object instanceof RealParameter) {
                        Parameter.Base base = (Parameter.Base)object;
                        boolean bl4 = false;
                        for (BEASTInterface bEASTInterface2 : base.getOutputs()) {
                            if (!(bEASTInterface2 instanceof State)) continue;
                            bl4 = true;
                            break;
                        }
                        if (!bl4 && base.getDimension() == 1 && base.getMinorDimension1() == 1) {
                            if (bl) {
                                stringBuffer.append(" " + input.getName() + ": \"" + base.getValue() + "\"");
                            } else {
                                return;
                            }
                        }
                    }
                    if (bl && this.isDone.contains(object)) {
                        stringBuffer.append(" " + input.getName() + ": \"@" + ((BEASTInterface)object).getID() + "\"");
                        if (!this.isInputsDone.containsKey(bEASTInterface)) {
                            this.isInputsDone.put(bEASTInterface, new HashSet());
                        }
                        this.isInputsDone.get(bEASTInterface).add(input.getName());
                    }
                    if (!(bl || this.isInputsDone.containsKey(bEASTInterface) && this.isInputsDone.get(bEASTInterface).contains(input.getName()))) {
                        this.beastObjectToJSON((BEASTInterface)object, input.getType(), stringBuffer, input.getName(), false);
                    }
                }
                return;
            }
            if (!object.equals(input.defaultValue)) {
                String string3 = object.toString();
                if (bl) {
                    if (string3.indexOf(10) < 0) {
                        stringBuffer.append(" " + input.getName() + ": " + this.normalise(input, object.toString()) + "");
                    }
                } else if (string3.indexOf(10) >= 0) {
                    stringBuffer.append(string + "" + input.getName() + ": " + this.normalise(input, object.toString()) + "");
                }
            }
            return;
        }
    }

    private String normalise(Input<?> input, String string) {
        string = string.replaceAll("\\\\", "\\\\\\\\");
        string = string.replaceAll("/", "\\\\/");
        string = string.replaceAll("\b", "\\\\b");
        string = string.replaceAll("\f", "\\\\f");
        string = string.replaceAll("\t", "\\\\t");
        string = string.replaceAll("\\r", "\\\\r");
        string = string.replaceAll("\"", "\\\\\"");
        string = string.replaceAll("\n", "\\\\n");
        if (!(input == null || input.getType().equals(Double.class) || input.getType().equals(Integer.class) || input.getType().equals(Boolean.class))) {
            string = "\"" + string + "\"";
        }
        return string;
    }

    public static void main(String[] stringArray) throws SAXException, IOException, ParserConfigurationException, XMLParserException {
        XMLParser xMLParser = new XMLParser();
        Runnable runnable = xMLParser.parseFile(new File(stringArray[0]));
        String string = stringArray[0].replace(".xml", ".json");
        PrintStream printStream = string.endsWith(".json") ? new PrintStream(new File(string)) : System.out;
        JSONProducer jSONProducer = new JSONProducer();
        String string2 = jSONProducer.toJSON(runnable);
        printStream.println(string2);
        printStream.close();
    }
}

