/*
 * Decompiled with CFR 0.152.
 */
package beast.util;

import beast.app.beauti.PartitionContext;
import beast.core.BEASTInterface;
import beast.core.Input;
import beast.core.Param;
import beast.core.Runnable;
import beast.core.State;
import beast.core.parameter.Map;
import beast.core.parameter.Parameter;
import beast.core.parameter.RealParameter;
import beast.core.util.Log;
import beast.util.InputType;
import beast.util.JSONParserException;
import beast.util.Randomizer;
import beast.util.XMLParser;
import beast.util.XMLParserUtils;
import beast.util.XMLProducer;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JSONParser {
    static final String INPUT_CLASS = Input.class.getName();
    static final String BEAST_OBJECT_CLASS = BEASTInterface.class.getName();
    static final String RUNNABLE_CLASS = Runnable.class.getName();
    Runnable runnable;
    State state;
    JSONObject doc;
    String DataMap;
    HashMap<String, BEASTInterface> IDMap;
    HashMap<String, Integer[]> likelihoodMap;
    HashMap<String, JSONObject> IDNodeMap;
    static HashMap<String, String> element2ClassMap = new HashMap();
    static Set<String> reservedElements = new HashSet<String>();
    List<BEASTObjectWrapper> objectsWaitingToInit = new ArrayList<BEASTObjectWrapper>();
    String[] nameSpaces;
    boolean initialise = true;
    RequiredInputProvider requiredInputProvider = null;
    PartitionContext partitionContext = null;

    public HashMap<String, String> getElement2ClassMap() {
        return element2ClassMap;
    }

    public Runnable parseFile(File file) throws IOException, JSONException, JSONParserException {
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        StringBuffer stringBuffer = new StringBuffer();
        String string = null;
        while (bufferedReader.ready()) {
            string = bufferedReader.readLine();
            if (!string.matches("^\\s*//.*")) {
                stringBuffer.append(string);
            }
            stringBuffer.append('\n');
        }
        bufferedReader.close();
        this.doc = new JSONObject(stringBuffer.toString());
        this.processPlates(this.doc);
        int n = file.getName().lastIndexOf(46);
        String string2 = n < 0 ? file.getName() : file.getName().substring(0, n);
        JSONParser.replaceVariable(this.doc, "filebase", string2);
        JSONParser.replaceVariable(this.doc, "seed", String.valueOf(Randomizer.getSeed()));
        this.IDMap = new HashMap();
        this.likelihoodMap = new HashMap();
        this.IDNodeMap = new HashMap();
        this.parse();
        if (this.runnable != null) {
            return this.runnable;
        }
        throw new IOException("Run element does not point to a runnable object.");
    }

    public static void replaceVariable(Object object, String string, String string2) {
        try {
            if (object instanceof JSONObject) {
                JSONObject jSONObject = (JSONObject)object;
                for (String string3 : jSONObject.keySet()) {
                    Object object2 = jSONObject.get(string3);
                    if (object2 instanceof String) {
                        if (!((String)object2).contains("$(" + string + ")")) continue;
                        String string4 = (String)object2;
                        string4 = string4.replaceAll("\\$\\(" + string + "\\)", string2);
                        jSONObject.put(string3, string4);
                        continue;
                    }
                    if (object2 instanceof JSONObject) {
                        JSONParser.replaceVariable(object2, string, string2);
                        continue;
                    }
                    if (!(object2 instanceof JSONArray)) continue;
                    JSONParser.replaceVariable(object2, string, string2);
                }
            } else if (object instanceof JSONArray) {
                JSONArray jSONArray = (JSONArray)object;
                for (int i = 0; i < jSONArray.length(); ++i) {
                    Object object3 = jSONArray.get(i);
                    JSONParser.replaceVariable(object3, string, string2);
                }
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    private void initBEASTObjects() throws JSONParserException {
        JSONObject jSONObject = null;
        try {
            for (int i = 0; i < this.objectsWaitingToInit.size(); ++i) {
                BEASTObjectWrapper bEASTObjectWrapper = this.objectsWaitingToInit.get(i);
                jSONObject = bEASTObjectWrapper.node;
                bEASTObjectWrapper.object.initAndValidate();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new JSONParserException(jSONObject, "validate and intialize error: " + exception.getMessage(), 110);
        }
    }

    void processPlates(JSONObject jSONObject) throws IOException, JSONException, JSONParserException {
        for (String string : jSONObject.keySet()) {
            Object object;
            Object object2 = jSONObject.get(string);
            if (object2 instanceof JSONObject) {
                object = (JSONObject)object2;
                this.processPlates((JSONObject)object);
            }
            if (!(object2 instanceof JSONArray)) continue;
            object = (JSONArray)object2;
            for (int i = 0; i < ((JSONArray)object).length(); ++i) {
                Object object3 = ((JSONArray)object).get(i);
                if (!(object3 instanceof JSONObject)) continue;
                JSONObject jSONObject2 = (JSONObject)object3;
                this.processPlates(jSONObject2);
                if (!jSONObject2.has("plate")) continue;
                this.unrollPlate((JSONArray)object, jSONObject2);
            }
        }
    }

    private void unrollPlate(JSONArray jSONArray, JSONObject jSONObject) throws IOException, JSONParserException, JSONException {
        int n = jSONArray.indexOf(jSONObject);
        if (n < 0) {
            throw new RuntimeException("Programmer error: plate should be in list");
        }
        jSONArray.remove(n);
        if (!(jSONObject.keySet().size() == 3 && jSONObject.has("plate") && jSONObject.has("range") && jSONObject.has("var"))) {
            throw new JSONParserException(jSONObject, "Plate should only have tree attributes: plate,  range and var", 1007);
        }
        Object object = jSONObject.get("range");
        if (!(object instanceof JSONArray)) {
            throw new JSONParserException(jSONObject, "Plate attribute range should be a list", 1008);
        }
        JSONArray jSONArray2 = (JSONArray)object;
        object = jSONObject.get("var");
        if (!(object instanceof String)) {
            throw new JSONParserException(jSONObject, "Plate attribute var should be a string", 1009);
        }
        String string = (String)object;
        for (int i = 0; i < jSONArray2.length(); ++i) {
            object = jSONArray2.get(i);
            if (!(object instanceof String)) {
                throw new JSONParserException(jSONObject, "Plate range value should be a string", 1010);
            }
            String string2 = (String)object;
            Object object2 = this.copyReplace(jSONObject, string, string2);
            jSONArray.insert(n + i, object2);
        }
    }

    private Object copyReplace(Object object, String string, String string2) {
        if (object instanceof Number) {
            return object;
        }
        if (object instanceof Boolean) {
            return object;
        }
        if (object instanceof String) {
            String string3 = (String)object;
            string3 = string3.replaceAll("\\$\\(" + string + "\\)", string2);
            return string3;
        }
        if (object instanceof JSONObject) {
            JSONObject jSONObject = (JSONObject)object;
            JSONObject jSONObject2 = new JSONObject();
            for (String string4 : jSONObject.keySet()) {
                try {
                    Object object2 = jSONObject.get(string4);
                    Object object3 = this.copyReplace(object2, string, string2);
                    jSONObject2.put(string4, object3);
                }
                catch (JSONException jSONException) {
                    jSONException.printStackTrace();
                }
            }
            return jSONObject2;
        }
        if (object instanceof JSONArray) {
            JSONArray jSONArray = (JSONArray)object;
            JSONArray jSONArray2 = new JSONArray();
            for (int i = 0; i < jSONArray.length(); ++i) {
                try {
                    Object object4 = jSONArray.get(i);
                    Object object5 = this.copyReplace(object4, string, string2);
                    jSONArray2.add(object5);
                    continue;
                }
                catch (JSONException jSONException) {
                    jSONException.printStackTrace();
                }
            }
            return jSONArray2;
        }
        throw new RuntimeException("How did we get here?");
    }

    public List<Object> parseFragment(String string, boolean bl) throws JSONParserException, JSONException {
        this.initialise = bl;
        this.doc = new JSONObject(string);
        JSONObject jSONObject = this.doc;
        if (jSONObject == null || jSONObject.keySet().size() == 0) {
            throw new JSONParserException(this.doc, "Expected top level 'beast' element in JSON fragment", 1001);
        }
        double d = JSONParser.getAttributeAsDouble(jSONObject, "version");
        if (d < 2.0 || d == Double.MAX_VALUE) {
            throw new JSONParserException(jSONObject, "Wrong version: only versions > 2.0 are supported", 101);
        }
        this.initIDNodeMap(this.doc);
        this.parseNameSpaceAndMap(this.doc);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        try {
            Object object = this.doc.get("beast");
            if (object == null) {
                throw new JSONParserException(jSONObject, "Expected beast top level object in file", 102);
            }
            if (!(object instanceof JSONArray)) {
                throw new JSONParserException(jSONObject, "Expected beast to be a list", 1020);
            }
            JSONArray jSONArray = (JSONArray)object;
            for (int i = 0; i < jSONArray.length(); ++i) {
                object = jSONArray.get(i);
                if (!(object instanceof JSONObject)) {
                    throw new JSONParserException(jSONObject, "beast should only contain objects", 1021);
                }
                JSONObject jSONObject2 = (JSONObject)object;
                object = this.createObject(jSONObject2, Object.class.getName());
                arrayList.add(object);
            }
        }
        catch (JSONException jSONException) {
            throw new JSONParserException(jSONObject, jSONException.getMessage(), 1004);
        }
        if (bl) {
            this.initBEASTObjects();
        }
        return arrayList;
    }

    public void parse() throws JSONParserException {
        JSONObject jSONObject = this.doc;
        if (jSONObject == null || jSONObject.keySet().size() == 0) {
            throw new JSONParserException(this.doc, "Expected top level beast element in JSON", 1001);
        }
        double d = JSONParser.getAttributeAsDouble(jSONObject, "version");
        if (d < 2.0 || d == Double.MAX_VALUE) {
            throw new JSONParserException(jSONObject, "Wrong version: only versions > 2.0 are supported", 101);
        }
        this.initIDNodeMap(this.doc);
        this.parseNameSpaceAndMap(this.doc);
        this.parseRunElement(this.doc);
        this.initBEASTObjects();
    }

    void initIDNodeMap(JSONObject jSONObject) throws JSONParserException {
        String string = JSONParser.getID(jSONObject);
        if (string != null) {
            if (this.IDNodeMap.containsKey(string)) {
                throw new JSONParserException(jSONObject, "IDs should be unique. Duplicate id '" + string + "' found", 104);
            }
            this.IDNodeMap.put(string, jSONObject);
        }
        for (String string2 : jSONObject.keySet()) {
            try {
                Object object = jSONObject.get(string2);
                if (object instanceof JSONObject) {
                    this.initIDNodeMap((JSONObject)object);
                }
                if (!(object instanceof JSONArray)) continue;
                JSONArray jSONArray = (JSONArray)object;
                for (int i = 0; i < jSONArray.length(); ++i) {
                    Object object2 = jSONArray.get(i);
                    if (!(object2 instanceof JSONObject)) continue;
                    this.initIDNodeMap((JSONObject)object2);
                }
            }
            catch (JSONException jSONException) {
                throw new JSONParserException(jSONObject, jSONException.getMessage(), 1002);
            }
        }
    }

    void parseNameSpaceAndMap(JSONObject jSONObject) throws JSONParserException {
        block13: {
            Object object;
            if (jSONObject.has("namespace")) {
                object = JSONParser.getAttribute(jSONObject, "namespace");
                this.setNameSpace((String)object);
            } else if (this.nameSpaces == null) {
                this.nameSpaces = new String[1];
                this.nameSpaces[0] = "";
            }
            if (jSONObject.has("map")) {
                try {
                    object = jSONObject.get("map");
                    if (object instanceof JSONArray) {
                        JSONArray jSONArray = (JSONArray)object;
                        for (int i = 0; i < jSONArray.length(); ++i) {
                            Object object2 = jSONArray.get(i);
                            if (object2 instanceof JSONObject) {
                                JSONObject jSONObject2 = (JSONObject)object2;
                                if (jSONObject2.has("name") && jSONObject2.has("value") && jSONObject2.length() == 2) {
                                    String string = jSONObject2.getString("name");
                                    String string2 = jSONObject2.getString("value");
                                    string2 = string2.replaceAll("\\s", "");
                                    boolean bl = false;
                                    for (String string3 : this.nameSpaces) {
                                        try {
                                            if (bl || Class.forName(string3 + string2) == null) continue;
                                            element2ClassMap.put(string, string2);
                                            Log.warning.println(string + " => " + string3 + string2);
                                            bl = true;
                                        }
                                        catch (ClassNotFoundException classNotFoundException) {
                                            // empty catch block
                                        }
                                    }
                                    if (bl) continue;
                                    Log.warning.println("WARNING: no class could be found for map " + string + " => " + string2 + ". This map is ignored.");
                                    continue;
                                }
                                throw new JSONParserException(jSONObject2, "Expected a name and a value and nothing else", 1016);
                            }
                            throw new JSONParserException(jSONObject, "map should be a list of JSONObjects. Use for example map:[{name:\"OneOnX\", value:\"beast.math.distributions.OneOnX\"}] for a single map", 1013);
                        }
                        break block13;
                    }
                    throw new JSONParserException(jSONObject, "map should be a list. Use for example map:[{name:\"OneOnX\", value:\"beast.math.distributions.OneOnX\"}] for a single map", 1014);
                }
                catch (JSONException jSONException) {
                    jSONException.printStackTrace();
                    throw new RuntimeException(jSONException);
                }
            }
        }
    }

    public void setNameSpace(String string) {
        String[] stringArray = string.split(":");
        this.nameSpaces = new String[stringArray.length + 1];
        int n = 0;
        for (String string2 : stringArray) {
            if (string2.length() > 0 && string2.charAt(string2.length() - 1) != '.') {
                string2 = string2 + '.';
            }
            this.nameSpaces[n++] = string2;
        }
        this.nameSpaces[n] = "";
    }

    void parseRunElement(JSONObject jSONObject) throws JSONParserException {
        try {
            Object object = this.doc.get("beast");
            if (object == null) {
                throw new JSONParserException(jSONObject, "Expected beast top level object in file", 102);
            }
            if (!(object instanceof JSONArray)) {
                throw new JSONParserException(jSONObject, "Expected beast to be a list", 1020);
            }
            JSONArray jSONArray = (JSONArray)object;
            this.runnable = null;
            for (int i = 0; i < jSONArray.length(); ++i) {
                object = jSONArray.get(i);
                if (!(object instanceof JSONObject)) {
                    throw new JSONParserException(jSONObject, "beast should only contain objects", 1021);
                }
                JSONObject jSONObject2 = (JSONObject)object;
                if (!((object = this.createObject(jSONObject2, RUNNABLE_CLASS)) instanceof Runnable)) continue;
                if (this.runnable != null) {
                    throw new JSONParserException(jSONObject2, "Expected only one runnable element in file", 103);
                }
                this.runnable = (Runnable)object;
            }
            if (this.runnable == null) {
                throw new JSONParserException(jSONObject, "Expected at least one runnable element in file", 1030);
            }
        }
        catch (JSONException jSONException) {
            throw new JSONParserException(jSONObject, jSONException.getMessage(), 1004);
        }
    }

    boolean checkType(String string, BEASTInterface bEASTInterface) throws JSONParserException {
        if (bEASTInterface instanceof Parameter) {
            for (String string2 : this.nameSpaces) {
                if (!(string2 + string).equals(RealParameter.class.getName())) continue;
                return true;
            }
        }
        if (string.equals(INPUT_CLASS)) {
            return true;
        }
        for (String string2 : this.nameSpaces) {
            try {
                if (!Class.forName(string2 + string).isInstance(bEASTInterface)) continue;
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    BEASTInterface createObject(JSONObject jSONObject, String string) throws JSONParserException {
        String string2;
        String string3 = JSONParser.getID(jSONObject);
        if (string3 != null && this.IDMap.containsKey(string3)) {
            BEASTInterface bEASTInterface = this.IDMap.get(string3);
            if (this.checkType(string, bEASTInterface)) {
                return bEASTInterface;
            }
            throw new JSONParserException(jSONObject, "id=" + string3 + ". Expected object of type " + string + " instead of " + bEASTInterface.getClass().getName(), 105);
        }
        String string4 = JSONParser.getIDRef(jSONObject);
        if (string4 != null) {
            if (jSONObject.keySet().size() > 1) {
                Log.warning.println("Element " + JSONParser.getAttribute((JSONObject)jSONObject.getParent(), "name") + " found with idref='" + string4 + "'. All other attributes are ignored.\n");
            }
            if (this.IDMap.containsKey(string4)) {
                BEASTInterface bEASTInterface = this.IDMap.get(string4);
                if (this.checkType(string, bEASTInterface)) {
                    return bEASTInterface;
                }
                throw new JSONParserException(jSONObject, "id=" + string4 + ". Expected object of type " + string + " instead of " + bEASTInterface.getClass().getName(), 106);
            }
            if (this.IDNodeMap.containsKey(string4)) {
                BEASTInterface bEASTInterface = this.createObject(this.IDNodeMap.get(string4), string);
                if (this.checkType(string, bEASTInterface)) {
                    return bEASTInterface;
                }
                throw new JSONParserException(jSONObject, "id=" + string4 + ". Expected object of type " + string + " instead of " + bEASTInterface.getClass().getName(), 107);
            }
            throw new JSONParserException(jSONObject, "Could not find object associated with idref " + string4, 170);
        }
        String string5 = string;
        String string6 = this.getElementName(jSONObject);
        if (element2ClassMap.containsKey(string6)) {
            string5 = element2ClassMap.get(string6);
        }
        if ((string2 = JSONParser.getAttribute(jSONObject, "spec")) != null) {
            string5 = string2;
        }
        String string7 = null;
        for (String string8 : this.nameSpaces) {
            if (string7 != null || !XMLParserUtils.beastObjectNames.contains(string8 + string5)) continue;
            string7 = string8 + string5;
            break;
        }
        if (string7 == null) {
            boolean bl = false;
            for (String string9 : this.nameSpaces) {
                try {
                    boolean classNotFoundException;
                    if (classNotFoundException) continue;
                    Class.forName(string9 + string5);
                    string7 = string9 + string5;
                    classNotFoundException = true;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
        }
        if (string7 == null) {
            throw new JSONParserException(jSONObject, "Class could not be found. Did you mean " + XMLParserUtils.guessClass(string5) + "?", 1017);
        }
        try {
            Class<?> clazz = Class.forName(string7);
            if (!BEASTInterface.class.isAssignableFrom(clazz)) {
                throw new JSONParserException(jSONObject, "Expected object to be instance of BEASTObject", 108);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
            throw new RuntimeException(classNotFoundException);
        }
        List<XMLParser.NameValuePair> list = this.parseInputs(jSONObject, string7);
        BEASTInterface bEASTInterface = this.createBeastObject(jSONObject, string3, string7, list);
        if (this.initialise) {
            try {
                bEASTInterface.determindClassOfInputs();
                bEASTInterface.validateInputs();
                this.objectsWaitingToInit.add(new BEASTObjectWrapper(bEASTInterface, jSONObject));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                illegalArgumentException.printStackTrace();
                throw new JSONParserException(jSONObject, "validate and intialize error: " + illegalArgumentException.getMessage(), 110);
            }
        }
        return bEASTInterface;
    }

    private String getElementName(JSONObject jSONObject) {
        Object object;
        Object object2 = jSONObject.getParent();
        if (object2 == null) {
            return null;
        }
        if (object2 instanceof JSONObject) {
            object = (JSONObject)object2;
            for (String object3 : ((JSONObject)object).keySet()) {
                try {
                    if (((JSONObject)object).get(object3) != jSONObject) continue;
                    return object3;
                }
                catch (JSONException jSONException) {
                    jSONException.printStackTrace();
                }
            }
        }
        if (object2 instanceof JSONArray) {
            object = (JSONArray)object2;
            Object object4 = ((JSONArray)object).getParent();
            if (object4 == null) {
                return null;
            }
            if (object4 instanceof JSONObject) {
                JSONObject jSONObject2 = (JSONObject)object4;
                for (String string : jSONObject2.keySet()) {
                    try {
                        if (jSONObject2.get(string) != object) continue;
                        return string;
                    }
                    catch (JSONException jSONException) {
                        jSONException.printStackTrace();
                    }
                }
            }
        }
        return null;
    }

    private BEASTInterface createBeastObject(JSONObject jSONObject, String string, String string2, List<XMLParser.NameValuePair> list) throws JSONParserException {
        BEASTInterface bEASTInterface = this.useAnnotatedConstructor(jSONObject, string, string2, list);
        if (bEASTInterface != null) {
            return bEASTInterface;
        }
        Object var6_6 = null;
        try {
            Iterator<Object> iterator = Class.forName(string2);
            var6_6 = ((Class)((Object)iterator)).newInstance();
        }
        catch (InstantiationException instantiationException) {
            throw new JSONParserException(jSONObject, "Cannot instantiate class. Please check the spec attribute.", 1006);
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
            throw new JSONParserException(jSONObject, "Cannot access class. Please check the spec attribute.", 1011);
        }
        bEASTInterface = var6_6;
        bEASTInterface.setID(string);
        if (var6_6 instanceof State) {
            this.state = var6_6;
        }
        for (XMLParser.NameValuePair object : list) {
            this.setInput(jSONObject, bEASTInterface, object.name, object.value);
        }
        try {
            if (this.requiredInputProvider != null) {
                for (Input input : bEASTInterface.listInputs()) {
                    Object object;
                    if (input.get() != null || input.getRule() != Input.Validate.REQUIRED || (object = this.requiredInputProvider.createInput(bEASTInterface, input, this.partitionContext)) == null) continue;
                    input.setValue(object, bEASTInterface);
                }
            }
        }
        catch (Exception exception) {
            throw new JSONParserException(jSONObject, exception.getMessage(), 1008);
        }
        if (!(bEASTInterface instanceof Map)) {
            for (String string3 : jSONObject.keySet()) {
                if (string3.equals("id") || string3.equals("idref") || string3.equals("spec") || string3.equals("name")) continue;
                try {
                    bEASTInterface.getInput(string3);
                }
                catch (Exception exception) {
                    throw new JSONParserException(jSONObject, exception.getMessage(), 1009);
                }
            }
        }
        for (XMLParser.NameValuePair nameValuePair : list) {
            if (!(nameValuePair.value instanceof BEASTInterface)) continue;
            ((BEASTInterface)nameValuePair.value).getOutputs().add(var6_6);
        }
        this.register(jSONObject, bEASTInterface);
        return bEASTInterface;
    }

    private BEASTInterface useAnnotatedConstructor(JSONObject jSONObject, String string, String string2, List<XMLParser.NameValuePair> list) throws JSONParserException {
        Constructor<?>[] constructorArray;
        Class<?> clazz = null;
        try {
            clazz = Class.forName(string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        for (Constructor<?> constructor : constructorArray = clazz.getDeclaredConstructors()) {
            Annotation[][] annotationArray = constructor.getParameterAnnotations();
            ArrayList<Param> arrayList = new ArrayList<Param>();
            for (Object object2 : annotationArray) {
                for (Annotation annotation : object2) {
                    if (!(annotation instanceof Param)) continue;
                    arrayList.add((Param)annotation);
                }
            }
            for (XMLParser.NameValuePair nameValuePair : list) {
                nameValuePair.processed = false;
            }
            Class<?>[] classArray = constructor.getParameterTypes();
            if (classArray.length <= 0 || arrayList.size() != classArray.length) continue;
            try {
                Object object;
                int n;
                Object object2;
                Object[] objectArray = new Object[classArray.length];
                for (n = 0; n < classArray.length; ++n) {
                    object2 = (Param)arrayList.get(n);
                    object = classArray[n];
                    if (object.getTypeName().equals("java.util.List")) {
                        if (objectArray[n] == null) {
                            objectArray[n] = new ArrayList();
                        }
                        List<Object> list2 = XMLParser.getListOfValues((Param)object2, list);
                        ((List)objectArray[n]).addAll(list2);
                        continue;
                    }
                    objectArray[n] = this.getValue((Param)object2, (Class)object, list);
                }
                n = 1;
                object2 = list.iterator();
                while (object2.hasNext()) {
                    object = (XMLParser.NameValuePair)object2.next();
                    if (((XMLParser.NameValuePair)object).processed) continue;
                    n = 0;
                }
                if (n == 0) continue;
                try {
                    object2 = constructor.newInstance(objectArray);
                    object = (BEASTInterface)object2;
                    this.register(jSONObject, (BEASTInterface)object);
                    return object;
                }
                catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException exception) {
                    throw new JSONParserException(jSONObject, "Could not create object: " + exception.getMessage(), 1012);
                }
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
                // empty catch block
            }
        }
        return null;
    }

    private Object getValue(Param param, Class<?> clazz, List<XMLParser.NameValuePair> list) throws NoSuchMethodException, SecurityException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Constructor<?> constructor;
        for (XMLParser.NameValuePair object2 : list) {
            if (!object2.name.equals(param.name())) continue;
            object2.processed = true;
            return object2.value;
        }
        if (!param.optional()) {
            throw new IllegalArgumentException();
        }
        String string = param.defaultValue();
        Object object = string;
        try {
            constructor = clazz.getDeclaredConstructor(String.class);
        }
        catch (NoSuchMethodException obj) {
            try {
                object = string.startsWith("0x") ? Integer.valueOf(Integer.parseInt(string.substring(2), 16)) : Integer.valueOf(Integer.parseInt(string));
                constructor = clazz.getDeclaredConstructor(Integer.TYPE);
            }
            catch (NumberFormatException numberFormatException) {
                object = Double.parseDouble(string);
                constructor = clazz.getDeclaredConstructor(Double.TYPE);
            }
        }
        constructor.setAccessible(true);
        Object obj = constructor.newInstance(object);
        return obj;
    }

    List<XMLParser.NameValuePair> parseInputs(JSONObject jSONObject, String string) throws JSONParserException {
        ArrayList<XMLParser.NameValuePair> arrayList = new ArrayList<XMLParser.NameValuePair>();
        if (jSONObject.keySet() != null) {
            try {
                List<InputType> list = XMLParserUtils.listInputs(Class.forName(string), null);
                HashSet<String> hashSet = new HashSet<String>();
                for (InputType object : list) {
                    String string2 = object.name;
                    this.processInput(string2, jSONObject, arrayList, list);
                    hashSet.add(string2);
                }
                for (String string3 : jSONObject.keySet()) {
                    if (hashSet.contains(string3)) continue;
                    this.processInput(string3, jSONObject, arrayList, list);
                }
            }
            catch (JSONParserException jSONParserException) {
                throw jSONParserException;
            }
            catch (Exception exception) {
                throw new JSONParserException(jSONObject, exception.getMessage(), 1005);
            }
        }
        return arrayList;
    }

    private void processInput(String string, JSONObject jSONObject, List<XMLParser.NameValuePair> list, List<InputType> list2) throws JSONParserException, JSONException {
        if (!(!jSONObject.has(string) || string.equals("id") || string.equals("idref") || string.equals("spec") || string.equals("name"))) {
            Object object = jSONObject.get(string);
            if (object instanceof String) {
                String string2 = (String)object;
                if (string2.startsWith("@")) {
                    String string3 = string2.substring(1);
                    JSONObject jSONObject2 = new JSONObject();
                    jSONObject2.put("idref", string3);
                    BEASTInterface bEASTInterface = this.createObject(jSONObject2, BEAST_OBJECT_CLASS);
                    list.add(new XMLParser.NameValuePair(string, bEASTInterface));
                } else {
                    list.add(new XMLParser.NameValuePair(string, string2));
                }
            } else if (object instanceof Number) {
                list.add(new XMLParser.NameValuePair(string, object));
            } else if (object instanceof Boolean) {
                list.add(new XMLParser.NameValuePair(string, object));
            } else if (object instanceof JSONObject) {
                JSONObject jSONObject3 = (JSONObject)object;
                String string4 = this.getClassName(jSONObject3, string, list2);
                BEASTInterface bEASTInterface = this.createObject(jSONObject3, string4);
                if (bEASTInterface != null) {
                    list.add(new XMLParser.NameValuePair(string, bEASTInterface));
                }
            } else if (object instanceof JSONArray) {
                JSONArray jSONArray = (JSONArray)object;
                for (int i = 0; i < jSONArray.length(); ++i) {
                    Object object2 = jSONArray.get(i);
                    if (object2 instanceof JSONObject) {
                        JSONObject jSONObject4 = (JSONObject)object2;
                        String string5 = this.getClassName(jSONObject4, string, list2);
                        BEASTInterface bEASTInterface = this.createObject(jSONObject4, string5);
                        if (bEASTInterface == null) continue;
                        list.add(new XMLParser.NameValuePair(string, bEASTInterface));
                        continue;
                    }
                    list.add(new XMLParser.NameValuePair(string, object2));
                }
            } else {
                throw new RuntimeException("Developer error: Don't know how to handle this JSON construction");
            }
        }
    }

    private void setInput(JSONObject jSONObject, BEASTInterface bEASTInterface, String string, Object object) throws JSONParserException {
        try {
            Input<?> input = bEASTInterface.getInput(string);
            if (input.get() != input.defaultValue) {
                throw new IOException("Multiple entries for non-list input " + input.getName());
            }
            bEASTInterface.setInputValue(string, object);
            return;
        }
        catch (Exception exception) {
            if (string.equals("xml:base")) {
                return;
            }
            if (exception.getMessage().contains("101")) {
                String string2 = "?";
                try {
                    string2 = bEASTInterface.getInput(string).getType().getName().replaceAll(".*\\.", "");
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                throw new JSONParserException(jSONObject, exception.getMessage() + " expected '" + string2 + "' but got '" + object.getClass().getName().replaceAll(".*\\.", "") + "'", 123);
            }
            throw new JSONParserException(jSONObject, exception.getMessage(), 130);
        }
    }

    void register(JSONObject jSONObject, BEASTInterface bEASTInterface) {
        String string = JSONParser.getID(jSONObject);
        if (string != null) {
            this.IDMap.put(string, bEASTInterface);
        }
    }

    public static String getID(JSONObject jSONObject) {
        return JSONParser.getAttribute(jSONObject, "id");
    }

    public static String getIDRef(JSONObject jSONObject) {
        return JSONParser.getAttribute(jSONObject, "idref");
    }

    public static String getAttribute(JSONObject jSONObject, String string) {
        if (jSONObject.has(string)) {
            try {
                return jSONObject.get(string).toString();
            }
            catch (JSONException jSONException) {
                return null;
            }
        }
        return null;
    }

    public static int getAttributeAsInt(JSONObject jSONObject, String string) {
        String string2 = JSONParser.getAttribute(jSONObject, string);
        if (string2 == null) {
            return -1;
        }
        return Integer.parseInt(string2);
    }

    public static double getAttributeAsDouble(JSONObject jSONObject, String string) throws JSONParserException {
        String string2 = JSONParser.getAttribute(jSONObject, string);
        if (string2 == null) {
            return Double.MAX_VALUE;
        }
        try {
            return Double.parseDouble(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new JSONParserException(jSONObject, "Could not parse number " + string2, 1003);
        }
    }

    public void setRequiredInputProvider(RequiredInputProvider requiredInputProvider, PartitionContext partitionContext) {
        this.requiredInputProvider = requiredInputProvider;
        this.partitionContext = partitionContext;
    }

    String getClassName(JSONObject jSONObject, String string, BEASTInterface bEASTInterface) {
        String string2 = JSONParser.getAttribute(jSONObject, "spec");
        if (string2 == null) {
            Input<?> input = bEASTInterface.getInput(string);
            Class<?> clazz = input.getType();
            if (clazz == null) {
                input.determineClass(bEASTInterface);
                clazz = input.getType();
            }
            string2 = clazz.getName();
        }
        if (element2ClassMap.containsKey(string2)) {
            string2 = element2ClassMap.get(string2);
        }
        return string2;
    }

    private String getClassName(JSONObject jSONObject, String string, List<InputType> list) {
        String string2 = JSONParser.getAttribute(jSONObject, "spec");
        if (string2 == null) {
            for (InputType inputType : list) {
                if (!inputType.name.equals(string)) continue;
                Class<?> clazz = inputType.type;
                if (clazz == null) {
                    throw new RuntimeException("Programmer error: inputs should have their type set");
                }
                string2 = clazz.getName();
            }
        }
        if (element2ClassMap.containsKey(string2)) {
            string2 = element2ClassMap.get(string2);
        }
        return string2;
    }

    public static void main(String[] stringArray) {
        try {
            PrintStream printStream = System.out;
            System.setOut(System.err);
            JSONParser jSONParser = new JSONParser();
            Runnable runnable = jSONParser.parseFile(new File(stringArray[0]));
            System.setOut(printStream);
            if (stringArray.length > 1) {
                FileWriter fileWriter = new FileWriter(stringArray[1]);
                fileWriter.write(new XMLProducer().toXML(runnable));
                fileWriter.close();
            } else {
                System.out.println(new XMLProducer().toXML(runnable));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static {
        for (String string : element2ClassMap.keySet()) {
            reservedElements.add(string);
        }
    }

    public static interface RequiredInputProvider {
        public Object createInput(BEASTInterface var1, Input<?> var2, PartitionContext var3);
    }

    class BEASTObjectWrapper {
        BEASTInterface object;
        JSONObject node;

        public BEASTObjectWrapper(BEASTInterface bEASTInterface, JSONObject jSONObject) {
            this.object = bEASTInterface;
            this.node = jSONObject;
        }
    }
}

