/*
 * Decompiled with CFR 0.152.
 */
package beast.math.distributions;

import beast.core.CalculationNode;
import beast.core.Description;
import beast.core.Function;
import beast.core.Input;
import beast.util.Randomizer;
import org.apache.commons.math.MathException;
import org.apache.commons.math.distribution.ContinuousDistribution;
import org.apache.commons.math.distribution.Distribution;
import org.apache.commons.math.distribution.IntegerDistribution;

@Description(value="A class that describes a parametric distribution, that is, a distribution that takes some parameters/valuables as inputs and can produce (cumulative) densities and inverse cumulative densities.")
public abstract class ParametricDistribution
extends CalculationNode
implements ContinuousDistribution {
    public final Input<Double> offsetInput = new Input<Double>("offset", "offset of origin (defaults to 0)", 0.0);

    public abstract Distribution getDistribution();

    public double calcLogP(Function function) {
        double d = this.offsetInput.get();
        double d2 = 0.0;
        for (int i = 0; i < function.getDimension(); ++i) {
            double d3 = function.getArrayValue(i);
            d2 += this.logDensity(d3, d);
        }
        return d2;
    }

    public Double[][] sample(int n) throws MathException {
        Double[][] doubleArray = new Double[n][];
        for (int i = 0; i < doubleArray.length; ++i) {
            double d = Randomizer.nextDouble();
            doubleArray[i] = new Double[]{this.inverseCumulativeProbability(d)};
        }
        return doubleArray;
    }

    @Override
    public double inverseCumulativeProbability(double d) throws MathException {
        Distribution distribution = this.getDistribution();
        double d2 = this.getOffset();
        if (distribution instanceof ContinuousDistribution) {
            return d2 + ((ContinuousDistribution)distribution).inverseCumulativeProbability(d);
        }
        if (distribution instanceof IntegerDistribution) {
            return d2 + (double)((IntegerDistribution)distribution).inverseCumulativeProbability(d);
        }
        return 0.0;
    }

    @Override
    public double density(double d) {
        double d2 = this.getOffset();
        d -= d2;
        Distribution distribution = this.getDistribution();
        if (distribution instanceof ContinuousDistribution) {
            return ((ContinuousDistribution)distribution).density(d);
        }
        if (distribution instanceof IntegerDistribution) {
            return ((IntegerDistribution)distribution).probability(d);
        }
        return 0.0;
    }

    private double logDensity(double d, double d2) {
        double d3;
        d -= d2;
        Distribution distribution = this.getDistribution();
        if (distribution instanceof ContinuousDistribution) {
            return ((ContinuousDistribution)distribution).logDensity(d);
        }
        if (distribution instanceof IntegerDistribution && (d3 = ((IntegerDistribution)distribution).probability(d)) > 0.0) {
            return Math.log(d3);
        }
        return Double.NEGATIVE_INFINITY;
    }

    @Override
    public double logDensity(double d) {
        return this.logDensity(d, this.getOffset());
    }

    @Override
    public double cumulativeProbability(double d) throws MathException {
        return this.getDistribution().cumulativeProbability(d);
    }

    @Override
    public double cumulativeProbability(double d, double d2) throws MathException {
        return this.getDistribution().cumulativeProbability(d, d2);
    }

    private double getOffset() {
        return this.offsetInput.get();
    }

    public double getMean() {
        throw new RuntimeException("Not implemented yet");
    }

    public boolean isIntegerDistribution() {
        return this.getDistribution() instanceof IntegerDistribution;
    }
}

