/*
 * Decompiled with CFR 0.152.
 */
package beast.math;

public class GammaFunction {
    public static double lnGamma(double d) {
        double d2;
        double d3 = d;
        double d4 = 0.0;
        if (d3 < 7.0) {
            d4 = 1.0;
            d2 = d3 - 1.0;
            while (true) {
                double d5;
                d2 += 1.0;
                if (!(d5 < 7.0)) break;
                d4 *= d2;
            }
            d3 = d2;
            d4 = -Math.log(d4);
        }
        d2 = 1.0 / (d3 * d3);
        return d4 + (d3 - 0.5) * Math.log(d3) - d3 + 0.918938533204673 + (((-5.95238095238E-4 * d2 + 7.93650793651E-4) * d2 - 0.002777777777778) * d2 + 0.083333333333333) / d3;
    }

    public static double incompleteGammaQ(double d, double d2) {
        return 1.0 - GammaFunction.incompleteGamma(d2, d, GammaFunction.lnGamma(d));
    }

    public static double incompleteGammaP(double d, double d2) {
        return GammaFunction.incompleteGamma(d2, d, GammaFunction.lnGamma(d));
    }

    public static double incompleteGammaP(double d, double d2, double d3) {
        return GammaFunction.incompleteGamma(d2, d, d3);
    }

    private static double incompleteGamma(double d, double d2, double d3) {
        double d4;
        if (d == 0.0) {
            return 0.0;
        }
        if (d < 0.0 || d2 <= 0.0) {
            throw new IllegalArgumentException("Arguments out of bounds");
        }
        double d5 = Math.exp(d2 * Math.log(d) - d - d3);
        if (d > 1.0 && d >= d2) {
            double d6 = 1.0 - d2;
            double d7 = d6 + d + 1.0;
            double d8 = 0.0;
            double d9 = 1.0;
            double d10 = d;
            double d11 = d + 1.0;
            double d12 = d * d7;
            d4 = d11 / d12;
            while (true) {
                double d13 = (d6 += 1.0) * (d8 += 1.0);
                double d14 = (d7 += 2.0) * d11 - d13 * d9;
                double d15 = d7 * d12 - d13 * d10;
                if (d15 != 0.0) {
                    double d16 = d14 / d15;
                    double d17 = Math.abs(d4 - d16);
                    if (d17 <= 1.0E-8 && d17 <= 1.0E-8 * d16) break;
                    d4 = d16;
                }
                d9 = d11;
                d10 = d12;
                d11 = d14;
                d12 = d15;
                if (!(Math.abs(d14) >= 1.0E30)) continue;
                d9 /= 1.0E30;
                d10 /= 1.0E30;
                d11 /= 1.0E30;
                d12 /= 1.0E30;
            }
            d4 = 1.0 - d5 * d4;
        } else {
            d4 = 1.0;
            double d18 = 1.0;
            double d19 = d2;
            do {
                d4 += (d18 *= d / (d19 += 1.0));
            } while (d18 > 1.0E-8);
            d4 *= d5 / d2;
        }
        return d4;
    }
}

