/*
 * Decompiled with CFR 0.152.
 */
package beast.evolution.substitutionmodel;

import beast.core.CalculationNode;
import beast.core.Description;
import beast.core.Input;
import beast.evolution.datatype.DataType;
import beast.evolution.substitutionmodel.EigenDecomposition;
import beast.evolution.substitutionmodel.Frequencies;
import beast.evolution.tree.Node;

@Description(value="Specifies substitution model from which a transition probability matrix for a given distance can be obtained.")
public interface SubstitutionModel {
    public void getTransitionProbabilities(Node var1, double var2, double var4, double var6, double[] var8);

    public double[] getRateMatrix(Node var1);

    public double[] getFrequencies();

    public int getStateCount();

    public EigenDecomposition getEigenDecomposition(Node var1);

    public boolean canReturnComplexDiagonalization();

    public boolean canHandleDataType(DataType var1);

    @Description(value="Base implementation of a nucleotide substitution model.", isInheritable=false)
    public static abstract class NucleotideBase
    extends Base {
        public double freqA;
        public double freqC;
        public double freqG;
        public double freqT;
        public double freqR;
        public double freqY;

        @Override
        public int getStateCount() {
            assert (this.nrOfStates == 4);
            return this.nrOfStates;
        }

        protected void calculateFreqRY() {
            double[] dArray = this.frequencies.getFreqs();
            this.freqA = dArray[0];
            this.freqC = dArray[1];
            this.freqG = dArray[2];
            this.freqT = dArray[3];
            this.freqR = this.freqA + this.freqG;
            this.freqY = this.freqC + this.freqT;
        }
    }

    @Description(value="Base implementation of a substitution model.", isInheritable=false)
    public static abstract class Base
    extends CalculationNode
    implements SubstitutionModel {
        public final Input<Frequencies> frequenciesInput = new Input("frequencies", "substitution model equilibrium state frequencies", Input.Validate.REQUIRED);
        protected Frequencies frequencies;
        protected int nrOfStates;

        @Override
        public void initAndValidate() {
            this.frequencies = this.frequenciesInput.get();
        }

        @Override
        public double[] getFrequencies() {
            return this.frequencies.getFreqs();
        }

        @Override
        public int getStateCount() {
            return this.nrOfStates;
        }

        @Override
        public boolean canReturnComplexDiagonalization() {
            return false;
        }

        @Override
        public double[] getRateMatrix(Node node) {
            return null;
        }
    }
}

