/*
 * Decompiled with CFR 0.152.
 */
package beast.evolution.substitutionmodel;

import beast.core.util.Log;
import beast.evolution.substitutionmodel.EigenDecomposition;
import beast.evolution.substitutionmodel.EigenSystem;
import beast.math.MachineAccuracy;
import java.util.Arrays;

public class DefaultEigenSystem
implements EigenSystem {
    private final int stateCount;
    private double[] Eval;
    private double[][] Evec;
    private double[][] Ievc;
    private int[] ordr;
    private double[] evali;
    private double cr;
    private double ci;

    public DefaultEigenSystem(int n) {
        this.stateCount = n;
        this.ordr = new int[n];
        this.evali = new double[n];
    }

    @Override
    public EigenDecomposition decomposeMatrix(double[][] dArray) {
        this.Eval = new double[this.stateCount];
        this.Evec = new double[this.stateCount][this.stateCount];
        this.Ievc = new double[this.stateCount][this.stateCount];
        this.elmhes(dArray, this.ordr, this.stateCount);
        this.eltran(dArray, this.Evec, this.ordr, this.stateCount);
        this.hqr2(this.stateCount, 1, this.stateCount, dArray, this.Evec, this.Eval, this.evali);
        this.luinverse(this.Evec, this.Ievc, this.stateCount);
        double[] dArray2 = new double[this.stateCount * this.stateCount];
        double[] dArray3 = new double[this.stateCount * this.stateCount];
        for (int i = 0; i < this.stateCount; ++i) {
            System.arraycopy(this.Evec[i], 0, dArray2, i * this.stateCount, this.stateCount);
            System.arraycopy(this.Ievc[i], 0, dArray3, i * this.stateCount, this.stateCount);
        }
        return new EigenDecomposition(dArray2, dArray3, this.Eval);
    }

    private void elmhes(double[][] dArray, int[] nArray, int n) {
        int n2;
        for (n2 = 0; n2 < n; ++n2) {
            nArray[n2] = 0;
        }
        for (int i = 2; i < n; ++i) {
            double d;
            int n3;
            double d2 = 0.0;
            n2 = i;
            for (n3 = i; n3 <= n; ++n3) {
                if (!(Math.abs(dArray[n3 - 1][i - 2]) > Math.abs(d2))) continue;
                d2 = dArray[n3 - 1][i - 2];
                n2 = n3;
            }
            nArray[i - 1] = n2;
            if (n2 != i) {
                for (n3 = i - 2; n3 < n; ++n3) {
                    d = dArray[n2 - 1][n3];
                    dArray[n2 - 1][n3] = dArray[i - 1][n3];
                    dArray[i - 1][n3] = d;
                }
                for (n3 = 0; n3 < n; ++n3) {
                    d = dArray[n3][n2 - 1];
                    dArray[n3][n2 - 1] = dArray[n3][i - 1];
                    dArray[n3][i - 1] = d;
                }
            }
            if (d2 == 0.0) continue;
            for (n2 = i; n2 < n; ++n2) {
                d = dArray[n2][i - 2];
                if (d == 0.0) continue;
                dArray[n2][i - 2] = d /= d2;
                for (n3 = i - 1; n3 < n; ++n3) {
                    double[] dArray2 = dArray[n2];
                    int n4 = n3;
                    dArray2[n4] = dArray2[n4] - d * dArray[i - 1][n3];
                }
                for (n3 = 0; n3 < n; ++n3) {
                    double[] dArray3 = dArray[n3];
                    int n5 = i - 1;
                    dArray3[n5] = dArray3[n5] + d * dArray[n3][n2];
                }
            }
        }
    }

    private void mcdiv(double d, double d2, double d3, double d4) {
        double d5 = Math.abs(d3) + Math.abs(d4);
        double d6 = d / d5;
        double d7 = d2 / d5;
        double d8 = d3 / d5;
        double d9 = d4 / d5;
        d5 = d8 * d8 + d9 * d9;
        this.cr = (d6 * d8 + d7 * d9) / d5;
        this.ci = (d7 * d8 - d6 * d9) / d5;
    }

    private void hqr2(int n, int n2, int n3, double[][] dArray, double[][] dArray2, double[] dArray3, double[] dArray4) throws ArithmeticException {
        int n4;
        double d;
        double d2;
        double d3;
        double d4;
        int n5;
        int n6;
        int n7;
        int n8 = 0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = 0.0;
        double d10 = 0.0;
        double d11 = 0.0;
        int n9 = 1;
        for (n7 = 0; n7 < n; ++n7) {
            for (n6 = n9 - 1; n6 < n; ++n6) {
                d11 += Math.abs(dArray[n7][n6]);
            }
            n9 = n7 + 1;
            if (n7 + 1 >= n2 && n7 + 1 <= n3) continue;
            dArray3[n7] = dArray[n7][n7];
            dArray4[n7] = 0.0;
        }
        int n10 = n3;
        double d12 = 0.0;
        int n11 = n * 30;
        while (n10 >= n2) {
            int n12 = 0;
            n5 = n10 - 1;
            while (n10 >= 1) {
                boolean bl = true;
                for (n8 = n10; n8 > n2; --n8) {
                    d8 = Math.abs(dArray[n8 - 2][n8 - 2]) + Math.abs(dArray[n8 - 1][n8 - 1]);
                    if (d8 == 0.0) {
                        d8 = d11;
                    }
                    if ((d4 = (d3 = d8) + Math.abs(dArray[n8 - 1][n8 - 2])) != d3) continue;
                    bl = false;
                    break;
                }
                if (bl) {
                    n8 = n2;
                }
                d9 = dArray[n10 - 1][n10 - 1];
                if (n8 == n10 || n8 == n5) break;
                if (n11 == 0) {
                    Log.warning.println("Eigenvalues not converged for Q-matrix");
                    for (n7 = 0; n7 < n; ++n7) {
                        Log.warning.println(Arrays.toString(dArray[n7]));
                    }
                    throw new ArithmeticException();
                }
                d2 = dArray[n5 - 1][n5 - 1];
                d = dArray[n10 - 1][n5 - 1] * dArray[n5 - 1][n10 - 1];
                if (n12 == 10 || n12 == 20) {
                    d12 += d9;
                    n7 = n2 - 1;
                    while (n7 < n10) {
                        double[] dArray5 = dArray[n7];
                        int n13 = n7++;
                        dArray5[n13] = dArray5[n13] - d9;
                    }
                    d8 = Math.abs(dArray[n10 - 1][n5 - 1]) + Math.abs(dArray[n5 - 1][n10 - 3]);
                    d2 = d9 = 0.75 * d8;
                    d = -0.4375 * d8 * d8;
                }
                ++n12;
                --n11;
                for (n4 = n10 - 2; n4 >= n8; --n4) {
                    d10 = dArray[n4 - 1][n4 - 1];
                    d7 = d9 - d10;
                    d8 = d2 - d10;
                    d5 = (d7 * d8 - d) / dArray[n4][n4 - 1] + dArray[n4 - 1][n4];
                    d6 = dArray[n4][n4] - d10 - d7 - d8;
                    d7 = dArray[n4 + 1][n4];
                    d8 = Math.abs(d5) + Math.abs(d6) + Math.abs(d7);
                    if (n4 == n8 || (d4 = (d3 = Math.abs(d5 /= d8) * (Math.abs(dArray[n4 - 2][n4 - 2]) + Math.abs(d10) + Math.abs(dArray[n4][n4]))) + Math.abs(dArray[n4 - 1][n4 - 2]) * (Math.abs(d6 /= d8) + Math.abs(d7 /= d8))) == d3) break;
                }
                for (n7 = n4 + 2; n7 <= n10; ++n7) {
                    dArray[n7 - 1][n7 - 3] = 0.0;
                    if (n7 == n4 + 2) continue;
                    dArray[n7 - 1][n7 - 4] = 0.0;
                }
                for (n9 = n4; n9 <= n5; ++n9) {
                    boolean bl2;
                    boolean bl3 = bl2 = n9 != n5;
                    if (n9 != n4) {
                        d5 = dArray[n9 - 1][n9 - 2];
                        d6 = dArray[n9][n9 - 2];
                        d7 = 0.0;
                        if (bl2) {
                            d7 = dArray[n9 + 1][n9 - 2];
                        }
                        if ((d9 = Math.abs(d5) + Math.abs(d6) + Math.abs(d7)) != 0.0) {
                            d5 /= d9;
                            d6 /= d9;
                            d7 /= d9;
                        }
                    }
                    if (d9 == 0.0) continue;
                    d8 = d5 < 0.0 ? -Math.sqrt(d5 * d5 + d6 * d6 + d7 * d7) : Math.sqrt(d5 * d5 + d6 * d6 + d7 * d7);
                    if (n9 != n4) {
                        dArray[n9 - 1][n9 - 2] = -d8 * d9;
                    } else if (n8 != n4) {
                        dArray[n9 - 1][n9 - 2] = -dArray[n9 - 1][n9 - 2];
                    }
                    d9 = (d5 += d8) / d8;
                    d2 = d6 / d8;
                    d10 = d7 / d8;
                    d6 /= d5;
                    d7 /= d5;
                    if (!bl2) {
                        n6 = n9 - 1;
                        while (n6 < n) {
                            d5 = dArray[n9 - 1][n6] + d6 * dArray[n9][n6];
                            double[] dArray6 = dArray[n9 - 1];
                            int n14 = n6;
                            dArray6[n14] = dArray6[n14] - d5 * d9;
                            double[] dArray7 = dArray[n9];
                            int n15 = n6++;
                            dArray7[n15] = dArray7[n15] - d5 * d2;
                        }
                        n6 = n10 < n9 + 3 ? n10 : n9 + 3;
                        for (n7 = 0; n7 < n6; ++n7) {
                            d5 = d9 * dArray[n7][n9 - 1] + d2 * dArray[n7][n9];
                            double[] dArray8 = dArray[n7];
                            int n16 = n9 - 1;
                            dArray8[n16] = dArray8[n16] - d5;
                            double[] dArray9 = dArray[n7];
                            int n17 = n9;
                            dArray9[n17] = dArray9[n17] - d5 * d6;
                        }
                        for (n7 = n2 - 1; n7 < n3; ++n7) {
                            d5 = d9 * dArray2[n7][n9 - 1] + d2 * dArray2[n7][n9];
                            double[] dArray10 = dArray2[n7];
                            int n18 = n9 - 1;
                            dArray10[n18] = dArray10[n18] - d5;
                            double[] dArray11 = dArray2[n7];
                            int n19 = n9;
                            dArray11[n19] = dArray11[n19] - d5 * d6;
                        }
                        continue;
                    }
                    n6 = n9 - 1;
                    while (n6 < n) {
                        d5 = dArray[n9 - 1][n6] + d6 * dArray[n9][n6] + d7 * dArray[n9 + 1][n6];
                        double[] dArray12 = dArray[n9 - 1];
                        int n20 = n6;
                        dArray12[n20] = dArray12[n20] - d5 * d9;
                        double[] dArray13 = dArray[n9];
                        int n21 = n6;
                        dArray13[n21] = dArray13[n21] - d5 * d2;
                        double[] dArray14 = dArray[n9 + 1];
                        int n22 = n6++;
                        dArray14[n22] = dArray14[n22] - d5 * d10;
                    }
                    n6 = n10 < n9 + 3 ? n10 : n9 + 3;
                    for (n7 = 0; n7 < n6; ++n7) {
                        d5 = d9 * dArray[n7][n9 - 1] + d2 * dArray[n7][n9] + d10 * dArray[n7][n9 + 1];
                        double[] dArray15 = dArray[n7];
                        int n23 = n9 - 1;
                        dArray15[n23] = dArray15[n23] - d5;
                        double[] dArray16 = dArray[n7];
                        int n24 = n9;
                        dArray16[n24] = dArray16[n24] - d5 * d6;
                        double[] dArray17 = dArray[n7];
                        int n25 = n9 + 1;
                        dArray17[n25] = dArray17[n25] - d5 * d7;
                    }
                    for (n7 = n2 - 1; n7 < n3; ++n7) {
                        d5 = d9 * dArray2[n7][n9 - 1] + d2 * dArray2[n7][n9] + d10 * dArray2[n7][n9 + 1];
                        double[] dArray18 = dArray2[n7];
                        int n26 = n9 - 1;
                        dArray18[n26] = dArray18[n26] - d5;
                        double[] dArray19 = dArray2[n7];
                        int n27 = n9;
                        dArray19[n27] = dArray19[n27] - d5 * d6;
                        double[] dArray20 = dArray2[n7];
                        int n28 = n9 + 1;
                        dArray20[n28] = dArray20[n28] - d5 * d7;
                    }
                }
            }
            if (n8 == n10) {
                dArray[n10 - 1][n10 - 1] = d9 + d12;
                dArray3[n10 - 1] = dArray[n10 - 1][n10 - 1];
                dArray4[n10 - 1] = 0.0;
                n10 = n5;
                continue;
            }
            d2 = dArray[n5 - 1][n5 - 1];
            d = dArray[n10 - 1][n5 - 1] * dArray[n5 - 1][n10 - 1];
            d5 = (d2 - d9) / 2.0;
            d6 = d5 * d5 + d;
            d10 = Math.sqrt(Math.abs(d6));
            dArray[n10 - 1][n10 - 1] = d9 + d12;
            d9 = dArray[n10 - 1][n10 - 1];
            dArray[n5 - 1][n5 - 1] = d2 + d12;
            if (d6 >= 0.0) {
                d10 = d5 < 0.0 ? d5 - Math.abs(d10) : d5 + Math.abs(d10);
                dArray3[n5 - 1] = d9 + d10;
                dArray3[n10 - 1] = dArray3[n5 - 1];
                if (d10 != 0.0) {
                    dArray3[n10 - 1] = d9 - d / d10;
                }
                dArray4[n5 - 1] = 0.0;
                dArray4[n10 - 1] = 0.0;
                d9 = dArray[n10 - 1][n5 - 1];
                d8 = Math.abs(d9) + Math.abs(d10);
                d5 = d9 / d8;
                d6 = d10 / d8;
                d7 = Math.sqrt(d5 * d5 + d6 * d6);
                d5 /= d7;
                d6 /= d7;
                for (n6 = n5 - 1; n6 < n; ++n6) {
                    d10 = dArray[n5 - 1][n6];
                    dArray[n5 - 1][n6] = d6 * d10 + d5 * dArray[n10 - 1][n6];
                    dArray[n10 - 1][n6] = d6 * dArray[n10 - 1][n6] - d5 * d10;
                }
                for (n7 = 0; n7 < n10; ++n7) {
                    d10 = dArray[n7][n5 - 1];
                    dArray[n7][n5 - 1] = d6 * d10 + d5 * dArray[n7][n10 - 1];
                    dArray[n7][n10 - 1] = d6 * dArray[n7][n10 - 1] - d5 * d10;
                }
                for (n7 = n2 - 1; n7 < n3; ++n7) {
                    d10 = dArray2[n7][n5 - 1];
                    dArray2[n7][n5 - 1] = d6 * d10 + d5 * dArray2[n7][n10 - 1];
                    dArray2[n7][n10 - 1] = d6 * dArray2[n7][n10 - 1] - d5 * d10;
                }
            } else {
                dArray3[n5 - 1] = d9 + d5;
                dArray3[n10 - 1] = d9 + d5;
                dArray4[n5 - 1] = d10;
                dArray4[n10 - 1] = -d10;
            }
            n10 -= 2;
        }
        if (d11 != 0.0) {
            for (n10 = n; n10 >= 1; --n10) {
                d5 = dArray3[n10 - 1];
                d6 = dArray4[n10 - 1];
                n5 = n10 - 1;
                if (d6 == 0.0) {
                    n4 = n10;
                    dArray[n10 - 1][n10 - 1] = 1.0;
                    if (n5 == 0) continue;
                    for (n7 = n10 - 2; n7 >= 0; --n7) {
                        d = dArray[n7][n7] - d5;
                        d7 = 0.0;
                        for (n6 = n4 - 1; n6 < n10; ++n6) {
                            d7 += dArray[n7][n6] * dArray[n6][n10 - 1];
                        }
                        if (dArray4[n7] < 0.0) {
                            d10 = d;
                            d8 = d7;
                            continue;
                        }
                        n4 = n7 + 1;
                        if (dArray4[n7] == 0.0) {
                            d12 = d;
                            if (d12 == 0.0) {
                                d12 = d3 = d11;
                                while ((d4 = d11 + (d12 = 0.01 * d12)) > d3) {
                                }
                            }
                            dArray[n7][n10 - 1] = -(d7 / d12);
                        } else {
                            d9 = dArray[n7][n7 + 1];
                            d2 = dArray[n7 + 1][n7];
                            d6 = (dArray3[n7] - d5) * (dArray3[n7] - d5) + dArray4[n7] * dArray4[n7];
                            dArray[n7][n10 - 1] = d12 = (d9 * d8 - d10 * d7) / d6;
                            dArray[n7 + 1][n10 - 1] = Math.abs(d9) > Math.abs(d10) ? (-d7 - d * d12) / d9 : (-d8 - d2 * d12) / d10;
                        }
                        d12 = Math.abs(dArray[n7][n10 - 1]);
                        if (d12 == 0.0 || !((d4 = (d3 = d12) + 1.0 / d3) <= d3)) continue;
                        for (n6 = n7; n6 < n10; ++n6) {
                            double[] dArray21 = dArray[n6];
                            int n29 = n10 - 1;
                            dArray21[n29] = dArray21[n29] / d12;
                        }
                    }
                    continue;
                }
                if (!(d6 < 0.0)) continue;
                n4 = n5;
                if (Math.abs(dArray[n10 - 1][n5 - 1]) > Math.abs(dArray[n5 - 1][n10 - 1])) {
                    dArray[n5 - 1][n5 - 1] = d6 / dArray[n10 - 1][n5 - 1];
                    dArray[n5 - 1][n10 - 1] = (d5 - dArray[n10 - 1][n10 - 1]) / dArray[n10 - 1][n5 - 1];
                } else {
                    this.mcdiv(0.0, -dArray[n5 - 1][n10 - 1], dArray[n5 - 1][n5 - 1] - d5, d6);
                    dArray[n5 - 1][n5 - 1] = this.cr;
                    dArray[n5 - 1][n10 - 1] = this.ci;
                }
                dArray[n10 - 1][n5 - 1] = 0.0;
                dArray[n10 - 1][n10 - 1] = 1.0;
                if (n10 == 2) continue;
                for (n7 = n10 - 3; n7 >= 0; --n7) {
                    d = dArray[n7][n7] - d5;
                    double d13 = 0.0;
                    double d14 = 0.0;
                    for (n6 = n4 - 1; n6 < n10; ++n6) {
                        d13 += dArray[n7][n6] * dArray[n6][n5 - 1];
                        d14 += dArray[n7][n6] * dArray[n6][n10 - 1];
                    }
                    if (dArray4[n7] < 0.0) {
                        d10 = d;
                        d7 = d13;
                        d8 = d14;
                        continue;
                    }
                    n4 = n7 + 1;
                    if (dArray4[n7] == 0.0) {
                        this.mcdiv(-d13, -d14, d, d6);
                        dArray[n7][n5 - 1] = this.cr;
                        dArray[n7][n10 - 1] = this.ci;
                    } else {
                        d9 = dArray[n7][n7 + 1];
                        d2 = dArray[n7 + 1][n7];
                        double d15 = (dArray3[n7] - d5) * (dArray3[n7] - d5);
                        d15 = d15 + dArray4[n7] * dArray4[n7] - d6 * d6;
                        double d16 = (dArray3[n7] - d5) * 2.0 * d6;
                        if (d15 == 0.0 && d16 == 0.0) {
                            d15 = d3 = d11 * (Math.abs(d) + Math.abs(d6) + Math.abs(d9) + Math.abs(d2) + Math.abs(d10));
                            while ((d4 = d3 + (d15 = 0.01 * d15)) > d3) {
                            }
                        }
                        this.mcdiv(d9 * d7 - d10 * d13 + d6 * d14, d9 * d8 - d10 * d14 - d6 * d13, d15, d16);
                        dArray[n7][n5 - 1] = this.cr;
                        dArray[n7][n10 - 1] = this.ci;
                        if (Math.abs(d9) > Math.abs(d10) + Math.abs(d6)) {
                            dArray[n7 + 1][n5 - 1] = (d6 * dArray[n7][n10 - 1] - d * dArray[n7][n5 - 1] - d13) / d9;
                            dArray[n7 + 1][n10 - 1] = (-d14 - d * dArray[n7][n10 - 1] - d6 * dArray[n7][n5 - 1]) / d9;
                        } else {
                            this.mcdiv(-d7 - d2 * dArray[n7][n5 - 1], -d8 - d2 * dArray[n7][n10 - 1], d10, d6);
                            dArray[n7 + 1][n5 - 1] = this.cr;
                            dArray[n7 + 1][n10 - 1] = this.ci;
                        }
                    }
                    double d17 = d12 = Math.abs(dArray[n7][n5 - 1]) > Math.abs(dArray[n7][n10 - 1]) ? Math.abs(dArray[n7][n5 - 1]) : Math.abs(dArray[n7][n10 - 1]);
                    if (d12 == 0.0 || !((d4 = (d3 = d12) + 1.0 / d3) <= d3)) continue;
                    for (n6 = n7; n6 < n10; ++n6) {
                        double[] dArray22 = dArray[n6];
                        int n30 = n5 - 1;
                        dArray22[n30] = dArray22[n30] / d12;
                        double[] dArray23 = dArray[n6];
                        int n31 = n10 - 1;
                        dArray23[n31] = dArray23[n31] / d12;
                    }
                }
            }
            for (n7 = 0; n7 < n; ++n7) {
                if (n7 + 1 >= n2 && n7 + 1 <= n3) continue;
                for (n6 = n7; n6 < n; ++n6) {
                    dArray2[n7][n6] = dArray[n7][n6];
                }
            }
            for (n6 = n - 1; n6 >= n2 - 1; --n6) {
                n4 = n6 + 1 < n3 ? n6 + 1 : n3;
                for (n7 = n2 - 1; n7 < n3; ++n7) {
                    d10 = 0.0;
                    for (n9 = n2 - 1; n9 < n4; ++n9) {
                        d10 += dArray2[n7][n9] * dArray[n9][n6];
                    }
                    dArray2[n7][n6] = d10;
                }
            }
        }
    }

    private void eltran(double[][] dArray, double[][] dArray2, int[] nArray, int n) {
        int n2;
        int n3;
        for (n3 = 0; n3 < n; ++n3) {
            for (n2 = n3 + 1; n2 < n; ++n2) {
                dArray2[n3][n2] = 0.0;
                dArray2[n2][n3] = 0.0;
            }
            dArray2[n3][n3] = 1.0;
        }
        if (n <= 2) {
            return;
        }
        for (int i = n - 1; i >= 2; --i) {
            for (n3 = i; n3 < n; ++n3) {
                dArray2[n3][i - 1] = dArray[n3][i - 2];
            }
            n3 = nArray[i - 1];
            if (n3 == i) continue;
            for (n2 = i - 1; n2 < n; ++n2) {
                dArray2[i - 1][n2] = dArray2[n3 - 1][n2];
                dArray2[n3 - 1][n2] = 0.0;
            }
            dArray2[n3 - 1][i - 1] = 1.0;
        }
    }

    private void luinverse(double[][] dArray, double[][] dArray2, int n) throws IllegalArgumentException {
        double d;
        double d2;
        int n2;
        int n3;
        int n4 = 0;
        int[] nArray = new int[n];
        double[][] dArray3 = new double[n][n];
        for (n3 = 0; n3 < n; ++n3) {
            for (n2 = 0; n2 < n; ++n2) {
                dArray3[n3][n2] = dArray[n3][n2];
            }
        }
        double[] dArray4 = new double[n];
        double d3 = 1.0;
        for (n3 = 0; n3 < n; ++n3) {
            d2 = 0.0;
            for (n2 = 0; n2 < n; ++n2) {
                if (!(Math.abs(dArray3[n3][n2]) > d2)) continue;
                d2 = Math.abs(dArray3[n3][n2]);
            }
            if (d2 == 0.0) {
                Log.err.println("Singular matrix encountered");
                throw new IllegalArgumentException("Singular matrix");
            }
            dArray4[n3] = 1.0 / d2;
        }
        for (n2 = 0; n2 < n; ++n2) {
            double d4;
            int n5;
            for (n3 = 0; n3 < n2; ++n3) {
                d = dArray3[n3][n2];
                for (n5 = 0; n5 < n3; ++n5) {
                    d -= dArray3[n3][n5] * dArray3[n5][n2];
                }
                dArray3[n3][n2] = d;
            }
            d2 = 0.0;
            for (n3 = n2; n3 < n; ++n3) {
                d = dArray3[n3][n2];
                for (n5 = 0; n5 < n2; ++n5) {
                    d -= dArray3[n3][n5] * dArray3[n5][n2];
                }
                dArray3[n3][n2] = d;
                d4 = dArray4[n3] * Math.abs(d);
                if (!(d4 >= d2)) continue;
                d2 = d4;
                n4 = n3;
            }
            if (n2 != n4) {
                for (n5 = 0; n5 < n; ++n5) {
                    d4 = dArray3[n4][n5];
                    dArray3[n4][n5] = dArray3[n2][n5];
                    dArray3[n2][n5] = d4;
                }
                d3 = -d3;
                dArray4[n4] = dArray4[n2];
            }
            nArray[n2] = n4;
            if (dArray3[n2][n2] == 0.0) {
                dArray3[n2][n2] = MachineAccuracy.EPSILON;
            }
            if (n2 == n - 1) continue;
            d4 = 1.0 / dArray3[n2][n2];
            for (n3 = n2 + 1; n3 < n; ++n3) {
                double[] dArray5 = dArray3[n3];
                int n6 = n2;
                dArray5[n6] = dArray5[n6] * d4;
            }
        }
        for (int i = 0; i < n; ++i) {
            int n7;
            for (n7 = 0; n7 < n; ++n7) {
                dArray4[n7] = 0.0;
            }
            dArray4[i] = 1.0;
            int n8 = -1;
            for (n3 = 0; n3 < n; ++n3) {
                int n9 = nArray[n3];
                d = dArray4[n9];
                dArray4[n9] = dArray4[n3];
                if (n8 != -1) {
                    for (n2 = n8; n2 < n3; ++n2) {
                        d -= dArray3[n3][n2] * dArray4[n2];
                    }
                } else if (d != 0.0) {
                    n8 = n3;
                }
                dArray4[n3] = d;
            }
            for (n3 = n - 1; n3 >= 0; --n3) {
                d = dArray4[n3];
                for (n2 = n3 + 1; n2 < n; ++n2) {
                    d -= dArray3[n3][n2] * dArray4[n2];
                }
                dArray4[n3] = d / dArray3[n3][n3];
            }
            for (n7 = 0; n7 < n; ++n7) {
                dArray2[n7][i] = dArray4[n7];
            }
        }
        dArray4 = null;
        nArray = null;
        dArray3 = null;
    }
}

