/*
 * Decompiled with CFR 0.152.
 */
package beast.evolution.speciation;

import beast.core.BEASTInterface;
import beast.core.Description;
import beast.core.Input;
import beast.core.parameter.RealParameter;
import beast.core.util.Log;
import beast.evolution.speciation.SpeciesTreeDistribution;
import beast.evolution.tree.Node;
import beast.evolution.tree.TreeInterface;
import beast.evolution.tree.coalescent.TreeIntervals;
import beast.math.distributions.MRCAPrior;
import java.util.List;

@Description(value="Pure birth model (i.e. no deaths)")
public class YuleModel
extends SpeciesTreeDistribution {
    public final Input<RealParameter> birthDiffRateParameterInput = new Input("birthDiffRate", "birth difference rate parameter, lambda - mu in birth/death model", Input.Validate.REQUIRED);
    public final Input<RealParameter> originHeightParameterInput = new Input("originHeight", "the height of the point of origin of the process");
    public final Input<Boolean> conditionalOnRootInput = new Input<Boolean>("conditionalOnRoot", "Whether to condition on the root (default false)", false);
    protected boolean conditionalOnRoot;
    protected boolean conditionalOnOrigin;

    @Override
    public void initAndValidate() {
        super.initAndValidate();
        this.conditionalOnRoot = this.conditionalOnRootInput.get();
        boolean bl = this.conditionalOnOrigin = this.originHeightParameterInput.get() != null;
        if (this.conditionalOnRoot && this.conditionalOnOrigin) {
            throw new RuntimeException("ERROR: Cannot condition on both root and origin.");
        }
        TreeInterface treeInterface = (TreeInterface)this.treeInput.get();
        if (treeInterface == null) {
            treeInterface = ((TreeIntervals)this.treeIntervalsInput.get()).treeInput.get();
        }
        List<Node> list = treeInterface.getExternalNodes();
        double d = list.get(0).getHeight();
        for (Node node : list) {
            if (!(Math.abs(node.getHeight() - d) > 1.0E-8)) continue;
            Log.warning.println("WARNING: Yule Model cannot handle dated tips. Use for example a coalescent prior instead.");
            break;
        }
    }

    @Override
    public double calculateTreeLogLikelihood(TreeInterface treeInterface) {
        return this.calculateTreeLogLikelihood(treeInterface, 1.0, 0.0);
    }

    protected double calculateTreeLogLikelihood(TreeInterface treeInterface, double d, double d2) {
        if (this.conditionalOnOrigin && treeInterface.getRoot().getHeight() > this.originHeightParameterInput.get().getValue()) {
            return Double.NEGATIVE_INFINITY;
        }
        int n = treeInterface.getLeafNodeCount();
        double d3 = this.birthDiffRateParameterInput.get().getValue();
        double d4 = this.logTreeProbability(n, d3, d, d2);
        Node[] nodeArray = treeInterface.getNodesAsArray();
        for (int i = n; i < nodeArray.length; ++i) {
            assert (!nodeArray[i].isLeaf());
            d4 += this.calcLogNodeProbability(nodeArray[i], d3, d, d2, n);
        }
        return d4;
    }

    protected double logTreeProbability(int n, double d, double d2, double d3) {
        double d4 = this.logCoeff(n);
        if (this.conditionalOnOrigin) {
            double d5 = this.originHeightParameterInput.get().getValue();
            d4 += (double)(n - 1) * this.calcLogConditioningTerm(d5, d, d2, d3);
        } else if (!this.conditionalOnRoot) {
            d4 += (double)(n - 1) * Math.log(d * d2) + (double)n * Math.log(1.0 - d3);
        }
        return d4;
    }

    protected double logCoeff(int n) {
        return 0.0;
    }

    protected double calcLogNodeProbability(Node node, double d, double d2, double d3, int n) {
        double d4 = node.getHeight();
        if (this.conditionalOnRoot && node.isRoot()) {
            return (double)(n - 2) * this.calcLogConditioningTerm(d4, d, d2, d3);
        }
        double d5 = -d * d4;
        double d6 = Math.log(d2 + (1.0 - d2 - d3) * Math.exp(d5));
        double d7 = -2.0 * d6 + d5;
        if (!this.conditionalOnOrigin && !this.conditionalOnRoot && node.isRoot()) {
            d7 += d5 - d6;
        }
        return d7;
    }

    double calcLogConditioningTerm(double d, double d2, double d3, double d4) {
        double d5 = 1.0 - d4;
        double d6 = Math.exp(d2 * d);
        if (d6 != 1.0) {
            return Math.log(d2 * d5 * (d3 + d5 / (d6 - 1.0)));
        }
        return Math.log(d5 * (d2 * d3 + d5 / d));
    }

    @Override
    protected boolean requiresRecalculation() {
        return super.requiresRecalculation() || this.birthDiffRateParameterInput.get().somethingIsDirty() || this.conditionalOnOrigin && this.originHeightParameterInput.get().somethingIsDirty();
    }

    @Override
    public boolean canHandleTipDates() {
        return false;
    }

    @Override
    public void validateInputs() {
        if (this.conditionalOnRootInput.get().booleanValue()) {
            TreeInterface treeInterface = (TreeInterface)this.treeInput.get();
            int n = treeInterface.getTaxonset().getTaxonCount();
            boolean bl = false;
            for (BEASTInterface bEASTInterface : ((BEASTInterface)((Object)treeInterface)).getOutputs()) {
                if (!(bEASTInterface instanceof MRCAPrior)) continue;
                MRCAPrior mRCAPrior = (MRCAPrior)bEASTInterface;
                int n2 = mRCAPrior.taxonsetInput.get().taxonsetInput.get().size();
                if (n2 != n) continue;
                bl = true;
            }
            if (!bl) {
                Log.warning("WARNING: There must be an MRCAPrior on the root when conditionalOnRoot=true, but could not find any");
            }
        }
        super.validateInputs();
    }
}

