/*
 * Decompiled with CFR 0.152.
 */
package beast.evolution.operators;

import beast.core.Description;
import beast.core.Distribution;
import beast.core.Input;
import beast.core.Operator;
import beast.core.parameter.RealParameter;
import beast.core.util.Evaluator;
import beast.core.util.Log;
import beast.util.Randomizer;
import java.text.DecimalFormat;

@Description(value="A random walk operator that selects a random dimension of the real parameter and perturbs the value a random amount within +/- windowSize.")
public class SliceOperator
extends Operator {
    public final Input<RealParameter> parameterInput = new Input("parameter", "the parameter to operate a random walk on.", Input.Validate.REQUIRED);
    public final Input<Double> windowSizeInput = new Input("windowSize", "the size of the step for finding the slice boundaries", Input.Validate.REQUIRED);
    public final Input<Distribution> sliceDensityInput = new Input("sliceDensity", "The density to sample from using slice sampling.", Input.Validate.REQUIRED);
    Double totalDelta;
    int totalNumber;
    int n_learning_iterations;
    double W;
    double windowSize = 1.0;
    Distribution sliceDensity;

    @Override
    public void initAndValidate() {
        this.totalDelta = 0.0;
        this.totalNumber = 0;
        this.n_learning_iterations = 100;
        this.W = 0.0;
        this.windowSize = this.windowSizeInput.get();
        this.sliceDensity = this.sliceDensityInput.get();
    }

    boolean in_range(RealParameter realParameter, double d) {
        return (Double)realParameter.getLower() < d && d < (Double)realParameter.getUpper();
    }

    boolean below_lower_bound(RealParameter realParameter, double d) {
        return d < (Double)realParameter.getLower();
    }

    boolean above_upper_bound(RealParameter realParameter, double d) {
        return d > (Double)realParameter.getUpper();
    }

    @Override
    public Distribution getEvaluatorDistribution() {
        return this.sliceDensity;
    }

    Double evaluate(Evaluator evaluator) {
        return evaluator.evaluate();
    }

    Double evaluate(Evaluator evaluator, RealParameter realParameter, double d) {
        realParameter.setValue(0, d);
        return this.evaluate(evaluator);
    }

    Double[] find_slice_boundaries_stepping_out(Evaluator evaluator, RealParameter realParameter, double d, double d2, int n) {
        double d3 = (Double)realParameter.getValue(0);
        assert (this.in_range(realParameter, d3));
        double d4 = Randomizer.nextDouble() * d2;
        Double d5 = d3 - d4;
        Double d6 = d3 + (d2 - d4);
        if (n > 1) {
            int n2;
            int n3 = n - 1 - n2;
            for (n2 = (int)Math.floor(Randomizer.nextDouble() * (double)n); n2 > 0 && !this.below_lower_bound(realParameter, d5) && this.evaluate(evaluator, realParameter, d5) > d; --n2) {
                d5 = d5 - d2;
            }
            while (n3 > 0 && !this.above_upper_bound(realParameter, d6) && this.evaluate(evaluator, realParameter, d6) > d) {
                d6 = d6 + d2;
                --n3;
            }
        } else {
            while (!this.below_lower_bound(realParameter, d5) && this.evaluate(evaluator, realParameter, d5) > d) {
                d5 = d5 - d2;
            }
            while (!this.above_upper_bound(realParameter, d6) && this.evaluate(evaluator, realParameter, d6) > d) {
                d6 = d6 + d2;
            }
        }
        if (this.below_lower_bound(realParameter, d5)) {
            d5 = (Double)realParameter.getLower();
        }
        if (this.above_upper_bound(realParameter, d6)) {
            d6 = (Double)realParameter.getUpper();
        }
        assert (d5 < d6);
        Double[] doubleArray = new Double[]{d5, d6};
        return doubleArray;
    }

    double search_interval(Evaluator evaluator, double d, RealParameter realParameter, Double d2, Double d3, double d4) {
        assert (this.evaluate(evaluator, realParameter, d) >= d4);
        assert (d2 < d3);
        assert (d2 <= d && d <= d3);
        double d5 = d2;
        double d6 = d3;
        double d7 = this.evaluate(evaluator, realParameter, d);
        assert (d4 < d7);
        double d8 = d;
        for (int i = 0; i < 200; ++i) {
            d8 = d2 + Randomizer.nextDouble() * (d3 - d2);
            double d9 = this.evaluate(evaluator, realParameter, d8);
            if (d9 >= d4) {
                return d8;
            }
            if (d8 > d) {
                d3 = d8;
                continue;
            }
            d2 = d8;
        }
        Log.warning.println("Warning!  Is size of the interval really ZERO?");
        Log.warning.println("    L0 = " + d5 + "   x0 = " + d + "   R0 = " + d6 + "   gx0 = " + d7);
        Log.warning.println("    L  = " + d2 + "   x1 = " + d8 + "   R  = " + d6 + "   gx1 = " + this.evaluate(evaluator));
        return d;
    }

    @Override
    public double proposal() {
        return 0.0;
    }

    @Override
    public double proposal(Evaluator evaluator) {
        int n = 100;
        RealParameter realParameter = this.parameterInput.get();
        Double d = this.evaluate(evaluator);
        Double d2 = (Double)realParameter.getValue(0);
        double d3 = d - Randomizer.nextExponential(1.0);
        Double[] doubleArray = this.find_slice_boundaries_stepping_out(evaluator, realParameter, d3, this.windowSize, n);
        Double d4 = doubleArray[0];
        Double d5 = doubleArray[1];
        double d6 = this.search_interval(evaluator, d2, realParameter, d4, d5, d3);
        realParameter.setValue(d6);
        if (this.n_learning_iterations > 0) {
            --this.n_learning_iterations;
            this.totalDelta = this.totalDelta + Math.abs(d6 - d2);
            ++this.totalNumber;
            double d7 = this.totalDelta / (double)this.totalNumber * 4.0;
            if (this.totalNumber > 3) {
                this.windowSize = this.W = 0.95 * this.W + 0.05 * d7;
            }
        }
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public double getCoercableParameterValue() {
        return this.windowSize;
    }

    @Override
    public void setCoercableParameterValue(double d) {
        this.windowSize = d;
    }

    @Override
    public void optimize(double d) {
        double d2 = this.calcDelta(d);
        this.windowSize = Math.exp(d2 += Math.log(this.windowSize));
    }

    @Override
    public final String getPerformanceSuggestion() {
        double d = this.totalDelta / (double)this.totalNumber * 4.0;
        if (d / this.windowSize < 0.8 || d / this.windowSize > 1.2) {
            DecimalFormat decimalFormat = new DecimalFormat("#.###");
            return "Try setting window size to about " + decimalFormat.format(d);
        }
        return "";
    }
}

