/*
 * Decompiled with CFR 0.152.
 */
package beast.evolution.datatype;

import beast.core.Description;
import beast.core.Input;
import beast.evolution.datatype.DataType;
import beast.evolution.datatype.UserDataType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@Description(value="Integer data type to describe discrete morphological characters with polymorphisms")
public class StandardData
extends DataType.Base {
    public final Input<Integer> maxNrOfStatesInput = new Input("nrOfStates", "specifies the maximum number of character states in data matrix or in the filtered alignment");
    public final Input<String> listOfAmbiguitiesInput = new Input("ambiguities", "all possible ambiguities presented as space separated sets of ordered elements. Elements are digits 0..9.");
    public final Input<List<UserDataType>> charStateLabelsInput = new Input("charstatelabels", "list of morphological character descriptions. Position in the list corresponds to the position of thecharacter in the alignment", new ArrayList());
    private String[] ambiguities = new String[0];
    private ArrayList<String> codeMapping;
    private int ambCount;

    @Override
    public void initAndValidate() {
        this.stateCount = this.maxNrOfStatesInput.get() != null && this.maxNrOfStatesInput.get() != 0 ? this.maxNrOfStatesInput.get() : -1;
        this.mapCodeToStateSet = null;
        this.codeLength = -1;
        this.codeMap = null;
        this.createCodeMapping();
    }

    private void createCodeMapping() {
        int n;
        int[] nArray;
        int n2;
        if (this.listOfAmbiguitiesInput.get() != null) {
            this.ambiguities = this.listOfAmbiguitiesInput.get().split(" ");
        }
        this.ambCount = this.ambiguities.length;
        this.codeMapping = new ArrayList();
        for (n2 = 0; n2 < this.stateCount; ++n2) {
            this.codeMapping.add(Integer.toString(n2));
        }
        for (n2 = 0; n2 < this.ambCount; ++n2) {
            this.codeMapping.add(this.ambiguities[n2]);
        }
        this.codeMapping.add(Character.toString('-'));
        this.codeMapping.add(Character.toString('?'));
        this.mapCodeToStateSet = new int[this.codeMapping.size()][];
        for (n2 = 0; n2 < this.codeMapping.size() - 2; ++n2) {
            nArray = new int[this.codeMapping.get(n2).length()];
            for (n = 0; n < nArray.length; ++n) {
                nArray[n] = this.codeMapping.get(n2).charAt(n) - 48;
            }
            this.mapCodeToStateSet[n2] = nArray;
        }
        n2 = this.stateCount >= 0 ? this.stateCount : 10;
        nArray = new int[n2];
        for (n = 0; n < n2; ++n) {
            nArray[n] = n;
        }
        this.mapCodeToStateSet[this.mapCodeToStateSet.length - 2] = nArray;
        this.mapCodeToStateSet[this.mapCodeToStateSet.length - 1] = nArray;
    }

    @Override
    public int[] getStatesForCode(int n) {
        if (n >= 0) {
            return this.mapCodeToStateSet[n];
        }
        return this.mapCodeToStateSet[this.mapCodeToStateSet.length - 1];
    }

    @Override
    public List<Integer> string2state(String string) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        string = string.replaceAll("\\s", "");
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        boolean bl = false;
        for (byte by : string.getBytes()) {
            String string2;
            if (!bl) {
                switch (by) {
                    case 45: 
                    case 63: {
                        string2 = Character.toString('?');
                        arrayList.add(this.codeMapping.indexOf(string2));
                        break;
                    }
                    case 123: {
                        bl = true;
                        arrayList2.clear();
                        break;
                    }
                    default: {
                        arrayList.add(Integer.parseInt((char)by + ""));
                        break;
                    }
                }
                continue;
            }
            if (by != 125) {
                arrayList2.add(Integer.parseInt((char)by + ""));
                continue;
            }
            bl = false;
            Collections.sort(arrayList2);
            string2 = "";
            for (Integer n : arrayList2) {
                string2 = string2 + Integer.toString(n);
            }
            arrayList.add(this.codeMapping.indexOf(string2));
        }
        return arrayList;
    }

    @Override
    public String getTypeDescription() {
        return "standard";
    }

    @Override
    public char getChar(int n) {
        if (n < 0) {
            return '?';
        }
        return (char)(48 + n);
    }

    @Override
    public String getCode(int n) {
        return this.codeMapping.get(n);
    }
}

