/*
 * Decompiled with CFR 0.152.
 */
package beast.evolution.branchratemodel;

import beast.core.Description;
import beast.core.Input;
import beast.core.parameter.BooleanParameter;
import beast.core.parameter.RealParameter;
import beast.core.util.Log;
import beast.evolution.branchratemodel.BranchRateModel;
import beast.evolution.tree.Node;
import beast.evolution.tree.Tree;

@Description(value="Random Local Clock Model, whatever that is....")
public class RandomLocalClockModel
extends BranchRateModel.Base {
    public final Input<BooleanParameter> indicatorParamInput = new Input("indicators", "the indicators associated with nodes in the tree for sampling of individual rate changes among branches.", Input.Validate.REQUIRED);
    public final Input<RealParameter> rateParamInput = new Input("rates", "the rate parameters associated with nodes in the tree for sampling of individual rates among branches.", Input.Validate.REQUIRED);
    public final Input<Tree> treeInput = new Input("tree", "the tree this relaxed clock is associated with.", Input.Validate.REQUIRED);
    public final Input<Boolean> ratesAreMultipliersInput = new Input<Boolean>("ratesAreMultipliers", "true if the rates should be treated as multipliers (default false).", false);
    Tree m_tree;
    RealParameter meanRate;
    private boolean recompute = true;
    double[] unscaledBranchRates;
    double scaleFactor;
    boolean ratesAreMultipliers = false;

    @Override
    public void initAndValidate() {
        this.m_tree = this.treeInput.get();
        BooleanParameter booleanParameter = this.indicatorParamInput.get();
        if (booleanParameter.getDimension() != this.m_tree.getNodeCount() - 1) {
            Log.warning.println("RandomLocalClockModel::Setting dimension of indicators to " + (this.m_tree.getNodeCount() - 1));
            booleanParameter.setDimension(this.m_tree.getNodeCount() - 1);
        }
        this.unscaledBranchRates = new double[this.m_tree.getNodeCount()];
        RealParameter realParameter = this.rateParamInput.get();
        if (realParameter.lowerValueInput.get() == null || realParameter.lowerValueInput.get() < 0.0) {
            realParameter.setLower(0.0);
        }
        if (realParameter.upperValueInput.get() == null || realParameter.upperValueInput.get() < 0.0) {
            realParameter.setUpper(Double.MAX_VALUE);
        }
        if (realParameter.getDimension() != this.m_tree.getNodeCount() - 1) {
            Log.warning.println("RandomLocalClockModel::Setting dimension of rates to " + (this.m_tree.getNodeCount() - 1));
            realParameter.setDimension(this.m_tree.getNodeCount() - 1);
        }
        this.ratesAreMultipliers = this.ratesAreMultipliersInput.get();
        this.meanRate = (RealParameter)this.meanRateInput.get();
        if (this.meanRate == null) {
            this.meanRate = new RealParameter("1.0");
        }
    }

    private void calculateUnscaledBranchRates(Node node, double d, BooleanParameter booleanParameter, RealParameter realParameter) {
        int n = this.getNr(node);
        if (!node.isRoot() && ((Boolean)booleanParameter.getValue(n)).booleanValue()) {
            d = this.ratesAreMultipliers ? (d *= ((Double)realParameter.getValue(n)).doubleValue()) : (Double)realParameter.getValue(n);
        }
        this.unscaledBranchRates[n] = d;
        if (!node.isLeaf()) {
            this.calculateUnscaledBranchRates(node.getLeft(), d, booleanParameter, realParameter);
            this.calculateUnscaledBranchRates(node.getRight(), d, booleanParameter, realParameter);
        }
    }

    private void recalculateScaleFactor() {
        BooleanParameter booleanParameter = this.indicatorParamInput.get();
        RealParameter realParameter = this.rateParamInput.get();
        this.calculateUnscaledBranchRates(this.m_tree.getRoot(), 1.0, booleanParameter, realParameter);
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < this.m_tree.getNodeCount(); ++i) {
            Node node = this.m_tree.getNode(i);
            if (node.isRoot()) continue;
            double d3 = node.getParent().getHeight() - node.getHeight();
            double d4 = d3 * this.unscaledBranchRates[node.getNr()];
            d += d3;
            d2 += d4;
        }
        this.scaleFactor = d / d2;
        this.scaleFactor *= this.meanRate.getValue().doubleValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getRateForBranch(Node node) {
        RandomLocalClockModel randomLocalClockModel = this;
        synchronized (randomLocalClockModel) {
            if (this.recompute) {
                this.recalculateScaleFactor();
                this.recompute = false;
            }
        }
        return this.unscaledBranchRates[this.getNr(node)] * this.scaleFactor;
    }

    private int getNr(Node node) {
        int n = node.getNr();
        if (n > this.m_tree.getRoot().getNr()) {
            --n;
        }
        return n;
    }

    @Override
    protected boolean requiresRecalculation() {
        this.recompute = true;
        return true;
    }

    @Override
    protected void store() {
        this.recompute = true;
        super.store();
    }

    @Override
    protected void restore() {
        this.recompute = true;
        super.restore();
    }
}

