/*
 * Decompiled with CFR 0.152.
 */
package beast.evolution.alignment;

import beast.core.BEASTObject;
import beast.core.Description;
import beast.core.Input;
import beast.evolution.datatype.DataType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

@Description(value="Single sequence in an alignment.")
public class Sequence
extends BEASTObject {
    public final Input<Integer> totalCountInput = new Input("totalcount", "number of states or the number of lineages for this species in SNAPP analysis");
    public final Input<String> taxonInput = new Input("taxon", "name of this species", Input.Validate.REQUIRED);
    public final Input<String> dataInput = new Input("value", "sequence data, either encoded as a string or as comma separated list of integers, or comma separated likelihoods/probabilities for each site if uncertain=true.In either case, whitespace is ignored.", Input.Validate.REQUIRED);
    public final Input<Boolean> uncertainInput = new Input("uncertain", "if true, sequence is provided as comma separated probabilities for each character, with sites separated by a semi-colons. In this formulation, gaps are coded as 1/K,...,1/K, where K is the number of states in the model.");
    protected boolean uncertain = false;
    protected double[][] likelihoods = null;

    public double[][] getLikelihoods() {
        return this.likelihoods;
    }

    public Sequence() {
    }

    public Sequence(String string, String string2) {
        this.taxonInput.setValue(string, this);
        this.dataInput.setValue(string2, this);
        this.initAndValidate();
    }

    @Override
    public void initAndValidate() {
        if (this.uncertainInput.get() != null) {
            this.uncertain = this.uncertainInput.get();
            if (this.uncertain) {
                this.initProbabilities();
            }
        }
    }

    public void initProbabilities() {
        String string = this.dataInput.get();
        string = string.replaceAll("\\s", "");
        String string2 = string.trim();
        String[] stringArray = string2.split(";");
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2 = stringArray[i].split(",");
            for (int j = 0; j < stringArray2.length; ++j) {
                if (this.likelihoods == null) {
                    this.likelihoods = new double[stringArray.length][stringArray2.length];
                }
                this.likelihoods[i][j] = Double.parseDouble(stringArray2[j].trim());
            }
        }
    }

    public List<Integer> getSequence(DataType dataType) {
        ArrayList<Integer> arrayList;
        if (this.uncertain) {
            arrayList = new ArrayList();
            for (int i = 0; i < this.likelihoods.length; ++i) {
                double d = this.likelihoods[i][0];
                int n = 0;
                for (int j = 0; j < this.likelihoods[i].length; ++j) {
                    if (!(this.likelihoods[i][j] > d)) continue;
                    d = this.likelihoods[i][j];
                    n = j;
                }
                arrayList.add(n);
            }
        } else {
            String string = this.dataInput.get();
            string = string.replaceAll("\\s", "");
            arrayList = dataType.string2state(string);
        }
        if (this.totalCountInput.get() == null) {
            this.totalCountInput.setValue(dataType.getStateCount(), this);
        }
        return arrayList;
    }

    public final String getTaxon() {
        return this.taxonInput.get();
    }

    public final String getData() {
        return this.dataInput.get();
    }

    int mapCharToData(String string, char c) {
        int n = string.indexOf(c);
        if (n >= 0) {
            return n;
        }
        return string.length();
    }

    public static Sequence getSequenceByTaxon(String string, Collection<Sequence> collection) {
        for (Sequence sequence : collection) {
            if (!sequence.getTaxon().equals(string)) continue;
            return sequence;
        }
        return null;
    }

    @Override
    public String toString() {
        return this.getTaxon() + ":" + this.getData();
    }
}

