/*
 * Decompiled with CFR 0.152.
 */
package beast.core.util;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Arrays;

public class Log {
    static PrintStream nullStream = new PrintStream(new OutputStream(){

        @Override
        public void write(int n) throws IOException {
        }
    });
    static Level level = Level.info;
    public static PrintStream err = System.err;
    public static PrintStream warning = System.err;
    public static PrintStream info = System.out;
    public static PrintStream debug = System.out;
    public static PrintStream trace = System.out;
    private static PrintStream errIfOpen = System.err;
    private static PrintStream warningIfOpen = System.err;
    private static PrintStream infoIfOpen = System.out;
    private static PrintStream debugIfOpen = System.out;
    private static PrintStream traceIfOpen = System.out;
    public static final int ERROR = 0;
    public static final int WARNING = 1;
    public static final int INFO = 2;
    public static final int DEBUG = 3;
    public static final int TRACE = 4;

    public static String[] values() {
        String[] stringArray = new String[Level.values().length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = Level.values()[i].toString();
        }
        return stringArray;
    }

    public static void err(String string) {
        err.println(string);
    }

    public static void warning(String string) {
        warning.println(string);
    }

    public static void info(String string) {
        info.println(string);
    }

    public static void debug(String string) {
        debug.println(string);
    }

    public static void trace(String string) {
        trace.println(string);
    }

    public static void setLevel(Level level) {
        Log.level = level;
        errIfOpen = err == nullStream ? errIfOpen : err;
        warningIfOpen = warning == nullStream ? warningIfOpen : warning;
        infoIfOpen = info == nullStream ? infoIfOpen : info;
        debugIfOpen = debug == nullStream ? debugIfOpen : debug;
        traceIfOpen = trace == nullStream ? traceIfOpen : trace;
        err = nullStream;
        warning = nullStream;
        info = nullStream;
        debug = nullStream;
        trace = nullStream;
        switch (Log.level) {
            case trace: {
                trace = traceIfOpen;
            }
            case debug: {
                debug = debugIfOpen;
            }
            case info: {
                info = infoIfOpen;
            }
            case warning: {
                warning = warningIfOpen;
            }
            case error: {
                err = errIfOpen;
            }
        }
    }

    static {
        if (System.getProperty("beast.log.level") != null) {
            try {
                level = Level.valueOf(System.getProperty("beast.log.level"));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                System.err.println("beast.log.level is set to " + System.getProperty("beast.log.level") + " " + "but should be one of " + Arrays.toString((Object[])Level.values()));
            }
        }
        Log.setLevel(level);
    }

    public static enum Level {
        error,
        warning,
        info,
        debug,
        trace;

    }
}

