/*
 * Decompiled with CFR 0.152.
 */
package beast.core.parameter;

import beast.core.Description;
import beast.core.Input;
import beast.core.parameter.Parameter;
import beast.core.util.Log;
import java.io.PrintStream;

@Description(value="An integer-valued parameter represents a value (or array of values if the dimension is larger than one) in the state space that can be changed by operators.")
public class IntegerParameter
extends Parameter.Base<Integer> {
    public final Input<Integer> lowerValueInput = new Input("lower", "lower value for this parameter (default -infinity)");
    public final Input<Integer> upperValueInput = new Input("upper", "upper value for this parameter  (default +infinity)");

    public IntegerParameter() {
    }

    public IntegerParameter(Integer[] integerArray) {
        super(integerArray);
    }

    public IntegerParameter(String string) {
        this.init(0, 0, string, 1);
    }

    @Override
    public void initAndValidate() {
        this.m_fLower = this.lowerValueInput.get() != null ? this.lowerValueInput.get() : Integer.valueOf(-2147483647);
        this.m_fUpper = this.upperValueInput.get() != null ? this.upperValueInput.get() : Integer.valueOf(0x7FFFFFFE);
        super.initAndValidate();
    }

    @Override
    Integer getMax() {
        return 0x7FFFFFFE;
    }

    @Override
    Integer getMin() {
        return -2147483647;
    }

    @Override
    public Integer getValue() {
        return ((Integer[])this.values)[0];
    }

    @Override
    public double getArrayValue() {
        return ((Integer[])this.values)[0].intValue();
    }

    public int getNativeValue(int n) {
        return ((Integer[])this.values)[n];
    }

    @Override
    public double getArrayValue(int n) {
        return ((Integer[])this.values)[n].intValue();
    }

    @Override
    public void log(int n, PrintStream printStream) {
        IntegerParameter integerParameter = (IntegerParameter)this.getCurrent();
        int n2 = integerParameter.getDimension();
        for (int i = 0; i < n2; ++i) {
            printStream.print(integerParameter.getValue(i) + "\t");
        }
    }

    @Override
    public int scale(double d) {
        Log.warning.println("Attempt to scale Integer parameter " + this.getID() + "  has no effect");
        return 0;
    }

    @Override
    void fromXML(int n, String string, String string2, String[] stringArray) {
        this.setLower(Integer.parseInt(string));
        this.setUpper(Integer.parseInt(string2));
        this.values = new Integer[n];
        for (int i = 0; i < ((Integer[])this.values).length; ++i) {
            ((Integer[])this.values)[i] = Integer.parseInt(stringArray[i]);
        }
    }
}

