/*
 * Decompiled with CFR 0.152.
 */
package beast.core;

import beast.core.BEASTInterface;
import beast.core.BEASTObject;
import beast.core.Description;
import beast.core.Input;
import beast.core.Loggable;
import beast.core.util.Log;
import beast.evolution.tree.Tree;
import beast.util.XMLProducer;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@Description(value="Logs results of a calculation processes on regular intervals.")
public class Logger
extends BEASTObject {
    public final Input<String> fileNameInput = new Input("fileName", "Name of the file, or stdout if left blank");
    public final Input<Integer> everyInput = new Input<Integer>("logEvery", "Number of the samples logged", 1);
    public final Input<BEASTObject> modelInput = new Input("model", "Model to log at the top of the log. If specified, XML will be produced for the model, commented out by # at the start of a line. Alignments are suppressed. This way, the log file documents itself. ");
    public final Input<LOGMODE> modeInput = new Input<LOGMODE>("mode", "logging mode, one of " + Arrays.toString((Object[])LOGMODE.values()), LOGMODE.autodetect, LOGMODE.values());
    public final Input<SORTMODE> sortModeInput = new Input<SORTMODE>("sort", "sort items to be logged, one of " + Arrays.toString((Object[])SORTMODE.values()), SORTMODE.none, SORTMODE.values());
    public final Input<Boolean> sanitiseHeadersInput = new Input<Boolean>("sanitiseHeaders", "whether to remove any clutter introduced by Beauti", false);
    public final Input<List<BEASTObject>> loggersInput = new Input("log", "Element in a log. This can be any plug in that is Loggable.", new ArrayList(), Input.Validate.REQUIRED, Loggable.class);
    private String fileName;
    List<Loggable> loggerList;
    public static LogFileMode FILE_MODE = LogFileMode.only_new;
    public LOGMODE mode = LOGMODE.compound;
    static int sampleOffset = -1;
    int every = 1;
    PrintStream m_out;
    long startLogTime = -5L;
    int startSample;

    @Override
    public void initAndValidate() {
        this.fileName = this.fileNameInput.get();
        List<BEASTObject> list = this.loggersInput.get();
        int n = list.size();
        if (n == 0) {
            throw new RuntimeException("Logger with nothing to log specified");
        }
        this.loggerList = new ArrayList<Loggable>();
        for (BEASTObject object2 : list) {
            this.loggerList.add((Loggable)((Object)object2));
        }
        Object object = this.modeInput.get();
        if (((Enum)object).equals((Object)LOGMODE.autodetect)) {
            this.mode = LOGMODE.compound;
            if (n == 1 && this.loggerList.get(0) instanceof Tree) {
                this.mode = LOGMODE.tree;
            }
        } else if (((Enum)object).equals((Object)LOGMODE.tree)) {
            this.mode = LOGMODE.tree;
        } else if (((Enum)object).equals((Object)LOGMODE.compound)) {
            this.mode = LOGMODE.compound;
        } else {
            throw new IllegalArgumentException("Mode '" + object + "' is not supported. Choose one of " + Arrays.toString((Object[])LOGMODE.values()));
        }
        if (this.everyInput.get() != null) {
            this.every = this.everyInput.get();
        }
        if (this.mode == LOGMODE.compound) {
            switch (this.sortModeInput.get()) {
                case none: {
                    break;
                }
                case alphabetic: {
                    Collections.sort(this.loggerList, (loggable, loggable2) -> {
                        String string = ((BEASTObject)((Object)loggable)).getID();
                        String string2 = ((BEASTObject)((Object)loggable2)).getID();
                        if (string == null || string2 == null) {
                            return 0;
                        }
                        return string.compareTo(string2);
                    });
                    break;
                }
                case smart: {
                    String string;
                    ArrayList<String> arrayList = new ArrayList<String>();
                    ArrayList<String> arrayList2 = new ArrayList<String>();
                    for (Loggable n2 : this.loggerList) {
                        string = ((BEASTInterface)((Object)n2)).getID();
                        if (string == null) {
                            string = "";
                        }
                        String string2 = string;
                        if (string.indexOf(46) > 0) {
                            string = string.substring(0, string.indexOf(46));
                            string2 = string2.substring(string2.indexOf(46) + 1);
                        } else {
                            string2 = "";
                        }
                        arrayList.add(string);
                        arrayList2.add(string2);
                    }
                    for (int i = 0; i < this.loggerList.size(); ++i) {
                        int n2 = 1;
                        string = (String)arrayList.get(i);
                        for (int j = i + 1; j < this.loggerList.size(); ++j) {
                            int n3;
                            if (!((String)arrayList.get(j)).equals(string)) continue;
                            String string3 = (String)arrayList2.get(j);
                            for (n3 = n2; n3 >= 0 && string.equals(arrayList.get(i + n3 - 1)) && ((String)arrayList2.get(i + n3 - 1)).compareTo(string3) > 0; --n3) {
                            }
                            arrayList.remove(j);
                            arrayList.add(i + n3, string);
                            String string4 = (String)arrayList2.remove(j);
                            arrayList2.add(i + n3, string4);
                            Loggable loggable3 = this.loggerList.remove(j);
                            this.loggerList.add(i + n3, loggable3);
                            ++n2;
                        }
                    }
                    break;
                }
            }
        }
    }

    public boolean isLoggingToStdout() {
        return this.fileName == null || this.fileName.length() == 0;
    }

    public void init() throws IOException {
        boolean bl = this.openLogFile();
        if (bl) {
            Object object;
            if (this.modelInput.get() != null) {
                object = new XMLProducer().modelToXML(this.modelInput.get());
                object = "#" + ((String)object).replaceAll("\\n", "\n#");
                this.m_out.println("#\n#model:\n#");
                this.m_out.println((String)object);
                this.m_out.println("#");
            }
            object = null;
            PrintStream printStream = null;
            if (this.m_out == System.out) {
                printStream = this.m_out;
                object = new ByteArrayOutputStream();
                this.m_out = new PrintStream((OutputStream)object);
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PrintStream printStream2 = new PrintStream(byteArrayOutputStream);
            if (this.mode == LOGMODE.compound) {
                printStream2.print("Sample\t");
            }
            for (Loggable object2 : this.loggerList) {
                object2.init(printStream2);
            }
            String string = byteArrayOutputStream.toString().trim();
            if (this.sanitiseHeadersInput.get().booleanValue()) {
                this.m_out.print(this.sanitiseHeader(string));
            } else {
                this.m_out.print(string);
            }
            if (object != null) {
                assert (printStream == System.out);
                this.m_out = printStream;
                try {
                    String string2 = ((ByteArrayOutputStream)object).toString("ASCII");
                    string2 = this.prettifyLogLine(string2);
                    this.m_out.print(string2);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    unsupportedEncodingException.printStackTrace();
                }
            }
            this.m_out.println();
        }
    }

    public String sanitiseHeader(String string) {
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c != '.') continue;
            if (i < string.length() - 2 && string.charAt(i + 2) == ':') {
                char c2 = string.charAt(++i);
                ++i;
                String string6 = "";
                while (i < string.length() - 1 && c != '\t') {
                    if ((c = string.charAt(++i)) == '\t') continue;
                    string6 = string6 + c;
                }
                switch (c2) {
                    case 'c': {
                        string3 = this.getprefix(string3, string6);
                        break;
                    }
                    case 's': {
                        string4 = this.getprefix(string4, string6);
                        break;
                    }
                    case 't': {
                        string5 = this.getprefix(string5, string6);
                    }
                }
                continue;
            }
            String string7 = "";
            while (i < string.length() - 1 && c != '\t') {
                if ((c = string.charAt(++i)) == '\t') continue;
                string7 = string7 + c;
            }
            string2 = this.getprefix(string2, string7);
            string2 = string2.replaceAll("[\\(\\)]", "");
        }
        string = string.replaceAll("\\." + string2, ".");
        string = string.replaceAll("\\.c:" + string3, ".");
        string = string.replaceAll("\\.t:" + string5, ".");
        string = string.replaceAll("\\.s:" + string4, ".");
        string = string.replaceAll("\\.\\.", ".");
        string = string.replaceAll("\\.\t", "\t");
        string = string.replaceAll("\\.$", "");
        return string;
    }

    private String getprefix(String string, String string2) {
        if (string == null) {
            return string2;
        }
        String string3 = "";
        int n = 0;
        while (n < string.length() && n < string2.length() && string.charAt(n) == string2.charAt(n)) {
            string3 = string3 + string.charAt(n++);
        }
        return string3;
    }

    /*
     * WARNING - void declaration
     */
    boolean openLogFile() throws IOException {
        Object object;
        Object object3;
        if (this.isLoggingToStdout()) {
            this.m_out = System.out;
            return true;
        }
        if (this.fileName.contains("$(tree)")) {
            object3 = "tree";
            for (Loggable object22 : this.loggerList) {
                if (!(object22 instanceof BEASTObject) || ((String)(object = ((BEASTObject)((Object)object22)).getID())).indexOf(".t:") <= 0) continue;
                object3 = ((String)object).substring(((String)object).indexOf(".t:") + 3);
            }
            this.fileName = this.fileName.replace("$(tree)", (CharSequence)object3);
            this.fileNameInput.setValue(this.fileName, this);
        }
        if (System.getProperty("file.name.prefix") != null) {
            this.fileName = System.getProperty("file.name.prefix") + "/" + this.fileName;
        }
        switch (FILE_MODE) {
            case only_new: 
            case only_new_or_exit: {
                Object object4;
                object3 = new File(this.fileName);
                if (((File)object3).exists()) {
                    if (FILE_MODE == LogFileMode.only_new_or_exit) {
                        Log.err.println("Trying to write file " + this.fileName + " but the file already exists. Exiting now.");
                        throw new RuntimeException("Use overwrite or resume option, or remove the file");
                    }
                    Log.info.println("Trying to write file " + this.fileName + " but the file already exists (perhaps use the -overwrite flag?).");
                    if (System.getProperty("beast.useWindow") != null) {
                        throw new IllegalArgumentException();
                    }
                    Log.info.println("Overwrite (Y/N)?:");
                    Log.info.flush();
                    object4 = new BufferedReader(new InputStreamReader(System.in));
                    String string = ((BufferedReader)object4).readLine();
                    if (!string.toLowerCase().equals("y")) {
                        Log.info.println("Exiting now.");
                        System.exit(0);
                    }
                }
                this.m_out = new PrintStream(this.fileName);
                Log.info.println("Writing file " + this.fileName);
                return true;
            }
            case overwrite: {
                object3 = "Writing";
                if (new File(this.fileName).exists()) {
                    object3 = "Warning: Overwriting";
                }
                this.m_out = new PrintStream(this.fileName);
                Log.warning.println((String)object3 + " file " + this.fileName);
                return true;
            }
            case resume: {
                Object object4;
                object3 = new File(this.fileName);
                if (((File)object3).exists()) {
                    if (this.mode == LOGMODE.compound) {
                        void var3_6;
                        object4 = new BufferedReader(new FileReader(this.fileName));
                        Object var3_5 = null;
                        while (((BufferedReader)object4).ready()) {
                            String string = ((BufferedReader)object4).readLine();
                        }
                        ((BufferedReader)object4).close();
                        assert (var3_6 != null);
                        int n = Integer.parseInt(var3_6.split("\\s")[0]);
                        if (sampleOffset > 0 && n != sampleOffset) {
                            throw new RuntimeException("Error 400: Cannot resume: log files do not end in same sample number");
                        }
                        sampleOffset = n;
                        FileOutputStream fileOutputStream = new FileOutputStream(this.fileName, true);
                        this.m_out = new PrintStream(fileOutputStream);
                    } else {
                        String string;
                        object4 = new File(this.fileName);
                        Files.move(((File)object4).toPath(), new File(this.fileName + ".bu").toPath(), StandardCopyOption.ATOMIC_MOVE);
                        BufferedReader bufferedReader = new BufferedReader(new FileReader(this.fileName + ".bu"));
                        object = new FileOutputStream(this.fileName);
                        this.m_out = new PrintStream((OutputStream)object);
                        String string2 = null;
                        boolean bl = false;
                        while (bufferedReader.ready()) {
                            if (bl) {
                                this.m_out.println("End;");
                                bl = false;
                            }
                            if (!(string = bufferedReader.readLine()).equals("End;")) {
                                this.m_out.println(string);
                                string2 = string;
                                continue;
                            }
                            bl = true;
                        }
                        bufferedReader.close();
                        if (string2 == null) {
                            throw new RuntimeException("Error 402: empty tree log file " + this.fileName + "? (check if there is a back up file " + this.fileName + ".bu)");
                        }
                        string = string2.split("\\s+")[1];
                        int n = Integer.parseInt(string.substring(6));
                        if (sampleOffset > 0 && n != sampleOffset) {
                            Files.move(((File)object4).toPath(), new File(this.fileName).toPath(), StandardCopyOption.ATOMIC_MOVE);
                            throw new RuntimeException("Error 401: Cannot resume: log files do not end in same sample number");
                        }
                        sampleOffset = n;
                        new File(this.fileName + ".bu").delete();
                    }
                    Log.info.println("Appending file " + this.fileName);
                    return false;
                }
                this.m_out = new PrintStream(this.fileName);
                Log.warning.println("WARNING: Resuming, but file " + this.fileName + " does not exist yet (perhaps the seed number is not the same as before?).");
                Log.info.println("Writing new file " + this.fileName);
                return true;
            }
        }
        throw new RuntimeException("DEVELOPER ERROR: unknown file mode for logger " + (Object)((Object)FILE_MODE));
    }

    public void log(int n) {
        Object object;
        if (n < 0 || n % this.every > 0) {
            return;
        }
        if (sampleOffset >= 0) {
            if (n == 0) {
                return;
            }
            n += sampleOffset;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(byteArrayOutputStream);
        if (this.mode == LOGMODE.compound) {
            printStream.print(n + "\t");
        }
        for (Loggable loggable : this.loggerList) {
            loggable.log(n, printStream);
        }
        try {
            object = byteArrayOutputStream.toString("ASCII").trim();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("ASCII string encoding not supported: required for logging!");
        }
        if (this.m_out == System.out) {
            object = this.prettifyLogLine((String)object);
            this.m_out.print((String)object);
            if (this.startLogTime < 0L) {
                if (n - sampleOffset > 6000) {
                    ++this.startLogTime;
                    if (this.startLogTime == 0L) {
                        this.startLogTime = System.currentTimeMillis();
                        this.startSample = n;
                    }
                }
                this.m_out.print(" --");
            } else {
                long l = System.currentTimeMillis();
                int n2 = (int)((double)(l - this.startLogTime) * 1000.0 / ((double)(n - this.startSample) + 1.0));
                String string = (n2 >= 3600 ? n2 / 3600 + "h" : "") + (n2 >= 60 ? n2 % 3600 / 60 + "m" : "") + n2 % 60 + "s";
                this.m_out.print(" " + string + "/Msamples");
            }
            this.m_out.println();
        } else {
            this.m_out.println((String)object);
        }
    }

    private String prettifyLogLine(String string) {
        String[] stringArray = string.split("\t");
        string = "";
        for (String string2 : stringArray) {
            string = string + this.prettifyLogEntry(string2);
        }
        return string;
    }

    private String prettifyLogEntry(String string) {
        int n;
        if (string.matches("[\\d-E]+\\.[\\d-E]+")) {
            if (string.contains("E")) {
                if (string.length() > 15) {
                    String[] stringArray = string.split("E");
                    return " " + stringArray[0].substring(0, 15 - stringArray[1].length() - 2) + "E" + stringArray[1];
                }
                return "               ".substring(string.length()) + string;
            }
            String string2 = string.substring(0, string.indexOf("."));
            String string3 = string.substring(string.indexOf(".") + 1);
            while (string3.length() < 4) {
                string3 = string3 + " ";
            }
            string3 = string3.substring(0, 4);
            string = string2 + "." + string3;
            string = "               ".substring(string.length()) + string;
        } else {
            string = string.length() < 15 ? "               ".substring(string.length()) + string : " " + string;
        }
        for (n = string.length() - 15; n > 0 && string.length() > 2 && string.charAt(1) == ' '; --n) {
            string = string.substring(1);
        }
        if (n > 0) {
            string = string.substring(0, 8) + "_" + string.substring(string.length() - 6);
        }
        return string;
    }

    public void close() {
        for (Loggable loggable : this.loggerList) {
            loggable.close(this.m_out);
        }
        if (this.m_out != System.out) {
            this.m_out.close();
        }
    }

    public PrintStream getM_out() {
        return this.m_out;
    }

    public static int getSampleOffset() {
        return sampleOffset < 0 ? 0 : sampleOffset;
    }

    public static enum LogFileMode {
        only_new,
        overwrite,
        resume,
        only_new_or_exit;

    }

    public static enum SORTMODE {
        none,
        alphabetic,
        smart;

    }

    public static enum LOGMODE {
        autodetect,
        compound,
        tree;

    }
}

