/*
 * Decompiled with CFR 0.152.
 */
package beast.core;

import beast.core.CalculationNode;
import beast.core.Description;
import beast.core.Function;
import beast.core.Loggable;
import beast.core.State;
import java.io.PrintStream;
import java.util.List;
import java.util.Random;

@Description(value="Probabilistic representation that can produce a log probability for instance for running an MCMC chain.")
public abstract class Distribution
extends CalculationNode
implements Loggable,
Function {
    protected double logP = Double.NaN;
    protected double storedLogP = Double.NaN;

    public double calculateLogP() {
        this.logP = 0.0;
        return this.logP;
    }

    public abstract List<String> getArguments();

    public abstract List<String> getConditions();

    public abstract void sample(State var1, Random var2);

    public double getCurrentLogP() {
        return this.logP;
    }

    @Override
    public void initAndValidate() {
    }

    @Override
    public void store() {
        this.storedLogP = this.logP;
        super.store();
    }

    @Override
    public void restore() {
        this.logP = this.storedLogP;
        super.restore();
    }

    @Override
    public void init(PrintStream printStream) {
        printStream.print(this.getID() + "\t");
    }

    @Override
    public void log(int n, PrintStream printStream) {
        printStream.print(this.getCurrentLogP() + "\t");
    }

    @Override
    public void close(PrintStream printStream) {
    }

    @Override
    public int getDimension() {
        return 1;
    }

    @Override
    public double getArrayValue() {
        return this.logP;
    }

    @Override
    public double getArrayValue(int n) {
        if (n == 0) {
            return this.getArrayValue();
        }
        return 0.0;
    }

    public boolean isStochastic() {
        return false;
    }

    public double getNonStochasticLogP() {
        if (this.isStochastic()) {
            return 0.0;
        }
        if (this.isDirtyCalculation()) {
            return this.calculateLogP();
        }
        return this.getCurrentLogP();
    }
}

