/*
 * Decompiled with CFR 0.152.
 */
package beast.core;

import beast.core.Citation;
import beast.core.Description;
import beast.core.Input;
import beast.core.InputForAnnotatedConstructor;
import beast.core.Param;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public interface BEASTInterface {
    public void initAndValidate();

    public String getID();

    public void setID(String var1);

    public Set<BEASTInterface> getOutputs();

    public Map<String, Input<?>> getInputs();

    default public void init(Object ... objectArray) {
        List<Input<?>> list = this.listInputs();
        int n = 0;
        for (Object object : objectArray) {
            list.get(n++).setValue(object, this);
        }
        this.initAndValidate();
    }

    default public void initByName(Object ... objectArray) {
        if (objectArray.length % 2 == 1) {
            throw new RuntimeException("Expected even number of arguments, name-value pairs");
        }
        for (int i = 0; i < objectArray.length; i += 2) {
            if (!(objectArray[i] instanceof String)) {
                throw new RuntimeException("Expected a String in " + i + "th argument ");
            }
            String string = (String)objectArray[i];
            this.setInputValue(string, objectArray[i + 1]);
        }
        try {
            this.initAndValidate();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException("initAndValidate() failed! " + exception.getMessage());
        }
    }

    public static Set<BEASTInterface> getOutputs(Object object) {
        try {
            Method method = object.getClass().getMethod("getOutputs", new Class[0]);
            Object object2 = method.invoke(object, new Object[0]);
            if (object2 instanceof Set) {
                return (Set)object2;
            }
            throw new RuntimeException("call to getOutputs() on object did not return a java.util.Set");
        }
        catch (Exception exception) {
            throw new RuntimeException("could not call getOutputs() on object: " + exception.getMessage());
        }
    }

    default public String getDescription() {
        Annotation[] annotationArray;
        for (Annotation annotation : annotationArray = this.getClass().getAnnotations()) {
            if (!(annotation instanceof Description)) continue;
            Description description = (Description)annotation;
            return description.value();
        }
        return "Not documented!!!";
    }

    @Deprecated
    default public Citation getCitation() {
        Annotation[] annotationArray;
        for (Annotation annotation : annotationArray = this.getClass().getAnnotations()) {
            if (annotation instanceof Citation) {
                return (Citation)annotation;
            }
            if (!(annotation instanceof Citation.Citations)) continue;
            return ((Citation.Citations)annotation).value()[0];
        }
        return null;
    }

    default public List<Citation> getCitationList() {
        Annotation[] annotationArray = this.getClass().getAnnotations();
        ArrayList<Citation> arrayList = new ArrayList<Citation>();
        for (Annotation annotation : annotationArray) {
            if (annotation instanceof Citation) {
                arrayList.add((Citation)annotation);
            }
            if (!(annotation instanceof Citation.Citations)) continue;
            for (Citation citation : ((Citation.Citations)annotation).value()) {
                arrayList.add(citation);
            }
        }
        return arrayList;
    }

    default public String getCitations() {
        return this.getCitations(new HashSet<String>(), new HashSet<String>());
    }

    default public String getCitations(HashSet<String> hashSet, HashSet<String> hashSet2) {
        if (this.getID() != null) {
            if (hashSet2.contains(this.getID())) {
                return "";
            }
            hashSet2.add(this.getID());
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (Citation object : this.getCitationList()) {
            if (hashSet.contains(object.value())) continue;
            stringBuilder.append("\n");
            stringBuilder.append(object.value());
            stringBuilder.append("\n");
            hashSet.add(object.value());
        }
        try {
            for (BEASTInterface bEASTInterface : this.listActiveBEASTObjects()) {
                stringBuilder.append(bEASTInterface.getCitations(hashSet, hashSet2));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - void declaration
     */
    default public List<Input<?>> listInputs() {
        ArrayList arrayList = new ArrayList();
        Field[] fieldArray = this.getClass().getFields();
        AccessibleObject[] accessibleObjectArray = fieldArray;
        int n = accessibleObjectArray.length;
        for (int i = 0; i < n; ++i) {
            Field field = accessibleObjectArray[i];
            if (!field.getType().isAssignableFrom(Input.class)) continue;
            try {
                Input illegalAccessException = (Input)field.get(this);
                arrayList.add(illegalAccessException);
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        for (AccessibleObject accessibleObject : accessibleObjectArray = this.getClass().getDeclaredConstructors()) {
            int n2;
            Annotation[][] annotationArray = ((Constructor)accessibleObject).getParameterAnnotations();
            ArrayList<Param> arrayList2 = new ArrayList<Param>();
            Annotation[][] annotationArray2 = annotationArray;
            int n3 = annotationArray2.length;
            for (n2 = 0; n2 < n3; ++n2) {
                Annotation[] annotationArray3;
                for (Annotation annotation : annotationArray3 = annotationArray2[n2]) {
                    if (!(annotation instanceof Param)) continue;
                    arrayList2.add((Param)annotation);
                }
            }
            annotationArray2 = ((Constructor)accessibleObject).getParameterTypes();
            Type[] typeArray = ((Constructor)accessibleObject).getGenericParameterTypes();
            if (annotationArray2.length <= 0 || arrayList2.size() <= 0) continue;
            n2 = 0;
            if (annotationArray2.length == arrayList2.size() + 1) {
                n2 = 1;
            }
            for (int i = 0; i < arrayList2.size(); ++i) {
                void var17_36;
                Param param = (Param)arrayList2.get(i);
                Annotation[] annotationArray4 = annotationArray2[i + n2];
                Class<List> clazz = null;
                try {
                    clazz = Class.forName(annotationArray4.getTypeName());
                }
                catch (ClassNotFoundException classNotFoundException) {
                    classNotFoundException.printStackTrace();
                }
                if (clazz.isAssignableFrom(List.class)) {
                    Type[] typeArray2 = ((ParameterizedType)typeArray[i + n2]).getActualTypeArguments();
                    Class clazz2 = (Class)typeArray2[0];
                    InputForAnnotatedConstructor inputForAnnotatedConstructor = null;
                    try {
                        inputForAnnotatedConstructor = new InputForAnnotatedConstructor(this, clazz2, param);
                    }
                    catch (NoSuchMethodException | SecurityException exception) {
                        exception.printStackTrace();
                    }
                    arrayList.add(inputForAnnotatedConstructor);
                    continue;
                }
                Object var17_34 = null;
                try {
                    InputForAnnotatedConstructor inputForAnnotatedConstructor = new InputForAnnotatedConstructor(this, (Class<?>)annotationArray2[i + n2], param);
                }
                catch (NoSuchMethodException | SecurityException exception) {
                    exception.printStackTrace();
                }
                arrayList.add((Input<?>)var17_36);
            }
        }
        return arrayList;
    }

    default public List<BEASTInterface> listActiveBEASTObjects() {
        ArrayList<BEASTInterface> arrayList = new ArrayList<BEASTInterface>();
        for (Input<?> input : this.getInputs().values()) {
            if (input.get() == null) continue;
            if (input.get() instanceof List) {
                List list = (List)input.get();
                for (Object e : list) {
                    if (!(e instanceof BEASTInterface)) continue;
                    arrayList.add((BEASTInterface)e);
                }
                continue;
            }
            if (input.get() == null || !(input.get() instanceof BEASTInterface)) continue;
            arrayList.add((BEASTInterface)input.get());
        }
        return arrayList;
    }

    @Deprecated
    default public List<BEASTInterface> listActivePlugins() throws IllegalArgumentException, IllegalAccessException {
        return this.listActiveBEASTObjects();
    }

    default public String getTipText(String string) throws IllegalArgumentException, IllegalAccessException {
        try {
            Input<?> input = this.getInput(string);
            if (input != null) {
                return input.getTipText();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    default public boolean isPrimitive(String string) {
        Input<?> input = this.getInput(string);
        Class<?> clazz = input.getType();
        if (clazz == null) {
            input.determineClass(this);
        }
        if (!1.$assertionsDisabled && clazz == null) {
            throw new AssertionError();
        }
        for (Class clazz2 : new Class[]{Integer.class, Long.class, Double.class, Float.class, Boolean.class, String.class}) {
            if (!clazz.isAssignableFrom(clazz2)) continue;
            return true;
        }
        return false;
    }

    default public Object getInputValue(String string) {
        Input<?> input = this.getInput(string);
        return input.get();
    }

    default public void setInputValue(String string, Object object) {
        Input<?> input = this.getInput(string);
        if (!input.canSetValue(object, this)) {
            throw new RuntimeException("Cannot set input value of " + string);
        }
        input.setValue(object, this);
    }

    default public Input<?> getInput(String string) {
        Map<String, Input<?>> map = this.getInputs();
        if (map.containsKey(string)) {
            return map.get(string);
        }
        String string2 = " ";
        for (Input<?> input : this.listInputs()) {
            string2 = string2 + input.getName() + ",";
        }
        throw new IllegalArgumentException("This BEASTInterface (" + (this.getID() == null ? this.getClass().getName() : this.getID()) + ") has no input with name " + string + ". " + "Choose one of these inputs:" + string2.substring(0, string2.length() - 1));
    }

    default public void validateInputs() {
        for (Input<?> input : this.listInputs()) {
            input.validate();
        }
    }

    default public void getPredecessors(List<BEASTInterface> list) {
        list.add(this);
        for (BEASTInterface bEASTInterface : this.listActiveBEASTObjects()) {
            if (list.contains(bEASTInterface)) continue;
            bEASTInterface.getPredecessors(list);
        }
    }

    default public void determindClassOfInputs() {
        for (Input<?> input : this.listInputs()) {
            if (input.getType() != null) continue;
            input.determineClass(this);
        }
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

