/*
 * Decompiled with CFR 0.152.
 */
package beast.app.util;

import beast.app.beauti.BeautiPanelConfig;
import beast.app.util.Utils6;
import beast.core.util.Log;
import beast.evolution.alignment.Alignment;
import beast.evolution.alignment.Sequence;
import beast.evolution.likelihood.BeagleTreeLikelihood;
import beast.evolution.sitemodel.SiteModel;
import beast.evolution.substitutionmodel.JukesCantor;
import beast.util.AddOnManager;
import beast.util.TreeParser;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.filechooser.FileNameExtensionFilter;

public class Utils {
    public static String trimExtensions(String string, String[] stringArray) {
        String string2 = null;
        for (String string3 : stringArray) {
            String string4 = "." + string3;
            if (!string.toUpperCase().endsWith(string4.toUpperCase())) continue;
            string2 = string.substring(0, string.length() - string4.length());
        }
        return string2 != null ? string2 : string;
    }

    public static Image getImage(Object object, String string) {
        URL uRL = object.getClass().getResource(string);
        if (uRL != null) {
            return Toolkit.getDefaultToolkit().createImage(uRL);
        }
        if (object instanceof Component) {
            Component component = (Component)object;
            Image image = component.createImage(100, 20);
            Graphics graphics = component.getGraphics();
            graphics.drawString("Not found!", 1, 15);
            return image;
        }
        return null;
    }

    public static File getCWD() {
        String string = System.getProperty("user.dir");
        return new File(string);
    }

    public static void loadUIManager() {
        Object object;
        if (Utils.isMac()) {
            System.setProperty("apple.awt.graphics.UseQuartz", "true");
            System.setProperty("apple.awt.antialiasing", "true");
            System.setProperty("apple.awt.rendering", "VALUE_RENDER_QUALITY");
            System.setProperty("apple.laf.useScreenMenuBar", "true");
            System.setProperty("apple.awt.draggableWindowBackground", "true");
            System.setProperty("apple.awt.showGrowBox", "true");
            object = UIManager.getLookAndFeel();
            try {
                try {
                    Class<?> clazz = Class.forName("ch.randelshofer.quaqua.QuaquaManager");
                    Method method = clazz.getMethod("setExcludedUIs", Set.class);
                    HashSet<String> hashSet = new HashSet<String>();
                    hashSet.add("Button");
                    hashSet.add("ToolBar");
                    method.invoke(null, hashSet);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                UIManager.setLookAndFeel("ch.randelshofer.quaqua.QuaquaLookAndFeel");
                UIManager.put("SystemFont", new Font("Lucida Grande", 0, 13));
                UIManager.put("SmallSystemFont", new Font("Lucida Grande", 0, 11));
            }
            catch (Exception exception) {
                Log.warning.println(exception.getMessage());
                try {
                    UIManager.setLookAndFeel((LookAndFeel)object);
                }
                catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
                    unsupportedLookAndFeelException.printStackTrace();
                }
            }
        } else {
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException exception) {
                Log.warning.println(exception.getMessage());
            }
        }
        object = Utils.getBeautiProperty("fontsize");
        if (object != null) {
            try {
                Utils.setFontSize(Integer.parseInt((String)object));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public static boolean isMac() {
        return System.getProperty("os.name").toLowerCase().startsWith("mac");
    }

    public static boolean isWindows() {
        return System.getProperty("os.name").toLowerCase().startsWith("windows");
    }

    public static boolean isLinux() {
        return System.getProperty("os.name").toLowerCase().startsWith("linux");
    }

    public static File getLoadFile(String string) {
        return Utils.getLoadFile(string, null, null, null);
    }

    public static File getSaveFile(String string) {
        return Utils.getSaveFile(string, null, null, null);
    }

    public static File getLoadFile(String string, File file, String string2, String ... stringArray) {
        File[] fileArray = Utils.getFile(string, true, file, false, string2, stringArray);
        if (fileArray == null) {
            return null;
        }
        return fileArray[0];
    }

    public static File getSaveFile(String string, File file, String string2, String ... stringArray) {
        File[] fileArray = Utils.getFile(string, false, file, false, string2, stringArray);
        if (fileArray == null) {
            return null;
        }
        return fileArray[0];
    }

    public static File[] getLoadFiles(String string, File file, String string2, String ... stringArray) {
        return Utils.getFile(string, true, file, true, string2, stringArray);
    }

    public static File[] getSaveFiles(String string, File file, String string2, String ... stringArray) {
        return Utils.getFile(string, false, file, true, string2, stringArray);
    }

    public static File[] getFile(String string, boolean bl, File file, boolean bl2, String string2, final String ... stringArray) {
        if (Utils.isMac()) {
            Object object;
            Frame frame = new Frame();
            FileDialog fileDialog = new FileDialog(frame, string, bl ? 0 : 1);
            if (file != null) {
                if (file.isDirectory()) {
                    fileDialog.setDirectory(file.getAbsolutePath());
                } else {
                    fileDialog.setDirectory(file.getParentFile().getAbsolutePath());
                    fileDialog.setFile(file.getName());
                }
            }
            if (string2 != null) {
                object = new FilenameFilter(){

                    @Override
                    public boolean accept(File file, String string) {
                        for (int i = 0; i < stringArray.length; ++i) {
                            if (!string.toLowerCase().endsWith(stringArray[i].toLowerCase())) continue;
                            return true;
                        }
                        return false;
                    }
                };
                fileDialog.setFilenameFilter((FilenameFilter)object);
            }
            fileDialog.setMultipleMode(bl2);
            fileDialog.setVisible(true);
            if (fileDialog.getFile() == null) {
                return null;
            }
            if (bl2) {
                return fileDialog.getFiles();
            }
            object = new File(fileDialog.getDirectory(), fileDialog.getFile());
            fileDialog.dispose();
            frame.dispose();
            return new File[]{object};
        }
        Frame frame = new Frame();
        frame.setTitle(string);
        JFileChooser jFileChooser = new JFileChooser(file);
        jFileChooser.setMultiSelectionEnabled(bl2);
        if (string2 != null && stringArray.length > 1 && stringArray[0].length() > 0) {
            FileNameExtensionFilter fileNameExtensionFilter = new FileNameExtensionFilter(string2, stringArray);
            jFileChooser.setFileFilter(fileNameExtensionFilter);
        }
        if (bl) {
            if (jFileChooser.showOpenDialog(frame) == 0) {
                frame.dispose();
                if (bl2) {
                    return jFileChooser.getSelectedFiles();
                }
                if (jFileChooser.getSelectedFile() == null) {
                    return null;
                }
                return new File[]{jFileChooser.getSelectedFile()};
            }
        } else if (jFileChooser.showSaveDialog(frame) == 0) {
            frame.dispose();
            if (bl2) {
                return jFileChooser.getSelectedFiles();
            }
            if (jFileChooser.getSelectedFile() == null) {
                return null;
            }
            return new File[]{jFileChooser.getSelectedFile()};
        }
        return null;
    }

    public static String toString(InputStream inputStream) throws IOException {
        String string;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        StringBuilder stringBuilder = new StringBuilder();
        while ((string = bufferedReader.readLine()) != null) {
            stringBuilder.append(string);
        }
        bufferedReader.close();
        return stringBuilder.toString();
    }

    public static ImageIcon getIcon(int n, BeautiPanelConfig beautiPanelConfig) {
        String string = "beast/app/beauti/" + n + ".png";
        if (beautiPanelConfig != null) {
            string = "beast/app/beauti/" + beautiPanelConfig.getIcon();
        }
        return Utils.getIcon(string);
    }

    public static ImageIcon getIcon(String string) {
        try {
            URL uRL = ClassLoader.getSystemResource(string);
            if (uRL == null) {
                return null;
            }
            ImageIcon imageIcon = new ImageIcon(uRL);
            return imageIcon;
        }
        catch (Exception exception) {
            Log.warning.println("Cannot load icon " + string + " " + exception.getMessage());
            return null;
        }
    }

    public static void main(String[] stringArray) {
        try {
            Sequence sequence = new Sequence("A", "A");
            Sequence sequence2 = new Sequence("B", "A");
            Sequence sequence3 = new Sequence("C", "A");
            Sequence sequence4 = new Sequence("D", "A");
            Alignment alignment = new Alignment();
            alignment.initByName("sequence", sequence, "sequence", sequence2, "sequence", sequence3, "sequence", sequence4, "dataType", "nucleotide");
            TreeParser treeParser = new TreeParser();
            treeParser.initByName("taxa", alignment, "newick", "(((A:1,B:1):1,C:2):1,D:3)", "IsLabelledNewick", true);
            JukesCantor jukesCantor = new JukesCantor();
            jukesCantor.initAndValidate();
            SiteModel siteModel = new SiteModel();
            siteModel.initByName("mutationRate", "1.0", "gammaCategoryCount", 1, "substModel", jukesCantor);
            BeagleTreeLikelihood beagleTreeLikelihood = new BeagleTreeLikelihood();
            beagleTreeLikelihood.initByName("data", alignment, "tree", treeParser, "siteModel", siteModel);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        System.out.println("Success");
        System.exit(0);
    }

    public static void setFontSize(int n) {
        for (String string : new String[]{"Button.font", "ToggleButton.font", "RadioButton.font", "ColorChooser.font", "List.font", "MenuBar.font", "MenuItem.font", "RadioButtonMenuItem.font", "CheckBoxMenuItem.font", "Menu.font", "PopupMenu.font", "OptionPane.font", "Panel.font", "ProgressBar.font", "ScrollPane.font", "Viewport.font", "TabbedPane.font", "TableHeader.font", "PasswordField.font", "EditorPane.font", "TitledBorder.font", "ToolBar.font", "ToolTip.font", "Tree.font", "ComboBox.font", "CheckBox.font", "Label.font", "Table.font", "TextField.font", "TextArea.font", "TextPane.font"}) {
            Font font = UIManager.getFont(string);
            UIManager.put(string, new Font(font.getName(), font.getStyle(), n));
        }
        Log.debug.println("Font is now at size " + n);
    }

    public static String getBeautiProperty(String string) {
        File file = new File(AddOnManager.getPackageUserDir() + "/beauti.properties");
        if (file.exists()) {
            Properties properties = new Properties();
            try {
                properties.load(new FileInputStream(file));
                return properties.getProperty(string);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return null;
    }

    public static void saveBeautiProperty(String string, String string2) {
        File file = new File(AddOnManager.getPackageUserDir() + "/beauti.properties");
        Properties properties = new Properties();
        if (file.exists()) {
            try {
                properties.load(new FileInputStream(file));
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        } else {
            try {
                file.createNewFile();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        if (string2 != null) {
            properties.setProperty(string, string2);
        } else {
            properties.remove(string);
        }
        try {
            properties.store(new FileOutputStream(file), "Automatically-generated by BEAUti.\n");
        }
        catch (IOException iOException) {
            Log.err(iOException.getMessage());
        }
    }

    public static void logToSplashScreen(String string) {
        if (Utils6.splashScreen != null) {
            try {
                Image image = Utils.getIcon("beast/app/draw/icons/beauti.png").getImage();
                Graphics graphics = Utils6.can.getBufferedGraphics();
                graphics.drawImage(image, Utils6.can.getWidth() / 4, 0, Utils6.can);
                graphics.drawString(string, 1, Utils6.can.getHeight() - 3);
                Utils6.can.repaint();
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }
}

