/*
 * Decompiled with CFR 0.152.
 */
package beast.app.treeannotator;

import beast.app.treeannotator.TreeAnnotator;
import beast.core.util.Log;
import beast.evolution.tree.Node;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class TreeSetParser {
    static final float DEFAULT_LENGTH = 0.001f;
    int m_nOffset = 0;
    List<String> m_sLabels;
    List<Float> m_fLongitude;
    List<Float> m_fLatitude;
    float m_fMaxLong;
    float m_fMaxLat;
    float m_fMinLong;
    float m_fMinLat;
    int m_nNrOfLabels;
    int m_nBurnInPercentage = 0;
    boolean m_bSurpressMetadata = true;
    boolean m_bIsLabelledNewick = false;
    boolean m_bAllowSingleChild = false;
    long fileStep;
    long fileRead = 0L;
    long fileMarked = 0L;
    int k = 0;
    char[] m_chars;
    int m_iTokenStart;
    int m_iTokenEnd;
    static final int COMMA = 1;
    static final int BRACE_OPEN = 3;
    static final int BRACE_CLOSE = 4;
    static final int COLON = 5;
    static final int SEMI_COLON = 8;
    static final int META_DATA = 6;
    static final int TEXT = 7;
    static final int UNKNOWN = 0;

    public TreeSetParser(int n, boolean bl) {
        this.m_sLabels = new ArrayList<String>();
        this.m_fLongitude = new ArrayList<Float>();
        this.m_fLatitude = new ArrayList<Float>();
        this.m_nBurnInPercentage = Math.max(n, 0);
        this.m_fMinLat = 90.0f;
        this.m_fMinLong = 180.0f;
        this.m_fMaxLat = -90.0f;
        this.m_fMaxLong = -180.0f;
        this.m_bAllowSingleChild = bl;
    }

    public TreeSetParser(List<String> list, List<Float> list2, List<Float> list3, int n) {
        this.m_sLabels = list;
        if (this.m_sLabels != null) {
            this.m_bIsLabelledNewick = true;
            this.m_nNrOfLabels = this.m_sLabels.size();
        }
        this.m_fLongitude = list2;
        this.m_fLatitude = list3;
        this.m_nBurnInPercentage = Math.max(n, 0);
        this.m_fMinLat = 90.0f;
        this.m_fMinLong = 180.0f;
        this.m_fMaxLat = -90.0f;
        this.m_fMaxLong = -180.0f;
    }

    public Node[] parseFile(String string) throws IOException {
        int n;
        boolean bl;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        this.m_nOffset = 0;
        File file = new File(string);
        this.fileStep = Math.max(file.length() / 61L, 1L);
        this.fileRead = 0L;
        this.fileMarked = 0L;
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
        int n2 = 0;
        while (bufferedReader.ready()) {
            if (!bufferedReader.readLine().toLowerCase().startsWith("tree ")) continue;
            ++n2;
        }
        bufferedReader.close();
        bufferedReader = new BufferedReader(new FileReader(string));
        String string2 = this.readLine(bufferedReader);
        while (bufferedReader.ready() && string2.toLowerCase().indexOf("translate") < 0) {
            string2 = this.readLine(bufferedReader);
        }
        this.m_bIsLabelledNewick = false;
        this.m_nNrOfLabels = this.m_sLabels.size();
        boolean bl2 = bl = this.m_nNrOfLabels == 0;
        if (string2.toLowerCase().indexOf("translate") < 0) {
            Object object;
            this.m_bIsLabelledNewick = true;
            bufferedReader.close();
            this.fileRead = 0L;
            this.fileMarked = 0L;
            bufferedReader = new BufferedReader(new FileReader(string));
            while (bufferedReader.ready() && this.m_nNrOfLabels == 0) {
                int n3;
                string2 = this.readLine(bufferedReader);
                this.fileRead += (long)string2.length();
                if (string2.length() <= 2 || string2.indexOf("(") < 0) continue;
                object = string2;
                object = ((String)object).substring(((String)object).indexOf("("));
                while (((String)object).indexOf(91) >= 0) {
                    int n4 = ((String)object).indexOf(91);
                    n3 = ((String)object).indexOf(93);
                    object = ((String)object).substring(0, n4) + ((String)object).substring(n3 + 1);
                }
                object = ((String)object).replaceAll("[;\\(\\),]", " ");
                object = ((String)object).replaceAll(":[0-9\\.Ee-]+", " ");
                String[] stringArray = ((String)object).split("\\s+");
                if (bl) {
                    this.m_nNrOfLabels = 0;
                    for (n3 = 0; n3 < stringArray.length; ++n3) {
                        if (stringArray[n3].length() <= 0) continue;
                        this.m_sLabels.add(stringArray[n3]);
                        ++this.m_nNrOfLabels;
                    }
                }
                Node node = this.parseNewick(string2);
                node.sort();
                node.labelInternalNodes(this.m_nNrOfLabels);
                arrayList.add(node);
            }
            while (bufferedReader.ready()) {
                string2 = this.readLine(bufferedReader);
                if (string2.length() <= 2 || string2.indexOf("(") < 0) continue;
                object = this.parseNewick(string2);
                ((Node)object).sort();
                ((Node)object).labelInternalNodes(this.m_nNrOfLabels);
                arrayList.add(object);
                if (arrayList.size() % 100 != 0 || this.m_nNrOfLabels < 100 && arrayList.size() % 1000 != 0) continue;
                Log.warning.print(arrayList.size() + " ");
            }
        } else {
            string2 = this.readLine(bufferedReader);
            boolean bl3 = false;
            while (bufferedReader.ready() && !bl3) {
                if (string2.indexOf(";") >= 0) {
                    string2 = string2.replace(';', ' ');
                    if ((string2 = string2.trim()).isEmpty()) break;
                    bl3 = true;
                }
                string2 = string2.replaceAll(",", "");
                string2 = string2.replaceAll("^\\s+", "");
                String[] stringArray = string2.split("\\s+");
                int n5 = new Integer(stringArray[0]);
                String string3 = stringArray[1];
                if (this.m_sLabels.size() < n5) {
                    this.m_nOffset = 1;
                }
                if (string3.contains("(")) {
                    int n6;
                    int n7 = string3.indexOf(40);
                    int n8 = string3.indexOf(120, n7);
                    if (n8 >= 0 && (n6 = string3.indexOf(41, n8)) >= 0) {
                        float f = Float.parseFloat(string3.substring(n7 + 1, n8));
                        float f2 = Float.parseFloat(string3.substring(n8 + 1, n6));
                        if (f != 0.0f || f2 != 0.0f) {
                            this.m_fMinLat = Math.min(this.m_fMinLat, f);
                            this.m_fMaxLat = Math.max(this.m_fMaxLat, f);
                            this.m_fMinLong = Math.min(this.m_fMinLong, f2);
                            this.m_fMaxLong = Math.max(this.m_fMaxLong, f2);
                        }
                        while (this.m_fLatitude.size() < this.m_sLabels.size()) {
                            this.m_fLatitude.add(Float.valueOf(0.0f));
                            this.m_fLongitude.add(Float.valueOf(0.0f));
                        }
                        this.m_fLatitude.add(Float.valueOf(f));
                        this.m_fLongitude.add(Float.valueOf(f2));
                    }
                    string3 = string3.substring(0, string3.indexOf("("));
                }
                if (bl) {
                    this.m_sLabels.add(string3);
                    ++this.m_nNrOfLabels;
                }
                if (bl3) continue;
                string2 = this.readLine(bufferedReader);
            }
            int n9 = this.m_nBurnInPercentage * n2 / 100;
            while (bufferedReader.ready()) {
                String string4;
                string2 = this.readLine(bufferedReader);
                if ((string2 = string2.trim()).length() <= 5 || !(string4 = string2.substring(0, 5)).toLowerCase().startsWith("tree ")) continue;
                if (n9 <= 0) {
                    int n10 = string2.indexOf(40);
                    if (n10 > 0) {
                        string2 = string2.substring(n10);
                    }
                    Node node = this.parseNewick(string2);
                    node.sort();
                    node.labelInternalNodes(this.m_nNrOfLabels);
                    arrayList.add(node);
                    continue;
                }
                --n9;
            }
            bufferedReader.close();
        }
        double d = 0.0;
        double[] dArray = new double[arrayList.size()];
        for (n = 0; n < arrayList.size(); ++n) {
            dArray[n] = this.lengthToHeight((Node)arrayList.get(n), 0.0);
            d = Math.max(d, dArray[n]);
        }
        for (n = 0; n < arrayList.size(); ++n) {
            this.offsetHeight((Node)arrayList.get(n), dArray[n]);
        }
        Log.warning.println();
        return arrayList.toArray(new Node[1]);
    }

    private String readLine(BufferedReader bufferedReader) throws IOException {
        String string = bufferedReader.readLine();
        this.fileRead += (long)string.length();
        if (this.fileRead > this.fileMarked - 10L) {
            TreeAnnotator.progressStream.print("*");
            this.fileMarked += this.fileStep;
            ++this.k;
        }
        return string;
    }

    public void offsetHeight(Node node, double d) {
        if (!node.isLeaf()) {
            this.offsetHeight(node.getLeft(), d);
            if (node.getRight() != null) {
                this.offsetHeight(node.getRight(), d);
            }
        }
        node.setHeight(node.getHeight() + d);
    }

    private double lengthToHeight(Node node, double d) {
        if (node.isLeaf()) {
            node.setHeight(-d - node.getHeight());
            node.setID(this.m_sLabels.get(node.getNr()));
            return -node.getHeight();
        }
        double d2 = d + node.getHeight();
        double d3 = 0.0;
        d3 = Math.max(d3, this.lengthToHeight(node.getLeft(), d2));
        if (node.getRight() != null) {
            d3 = Math.max(d3, this.lengthToHeight(node.getRight(), d2));
        }
        node.setHeight(-d2);
        return d3;
    }

    private int getLabelIndex(String string) {
        int n;
        if (!this.m_bIsLabelledNewick) {
            try {
                return Integer.parseInt(string) - this.m_nOffset;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        for (n = 0; n < this.m_nNrOfLabels; ++n) {
            if (!string.equals(this.m_sLabels.get(n))) continue;
            return n;
        }
        for (n = 0; n < this.m_nNrOfLabels; ++n) {
            String string2 = this.m_sLabels.get(n);
            if ((!string2.startsWith("'") || !string2.endsWith("'")) && (!string2.startsWith("\"") || !string2.endsWith("\"")) || !string.equals(string2 = string2.substring(1, string2.length() - 1))) continue;
            return n;
        }
        if (string.startsWith("'") && string.endsWith("'") || string.startsWith("\"") && string.endsWith("\"")) {
            string = string.substring(1, string.length() - 1);
            return this.getLabelIndex(string);
        }
        throw new IllegalArgumentException("Label '" + string + "' in Newick tree could not be identified");
    }

    double height(Node node) {
        if (node.isLeaf()) {
            return node.getLength();
        }
        return node.getLength() + Math.max(this.height(node.getLeft()), this.height(node.getRight()));
    }

    int nextToken() {
        this.m_iTokenStart = this.m_iTokenEnd;
        if (this.m_iTokenEnd < this.m_chars.length) {
            while (this.m_iTokenEnd < this.m_chars.length && (this.m_chars[this.m_iTokenEnd] == ' ' || this.m_chars[this.m_iTokenEnd] == '\t')) {
                ++this.m_iTokenStart;
                ++this.m_iTokenEnd;
            }
            if (this.m_chars[this.m_iTokenEnd] == '(') {
                ++this.m_iTokenEnd;
                return 3;
            }
            if (this.m_chars[this.m_iTokenEnd] == ':') {
                ++this.m_iTokenEnd;
                return 5;
            }
            if (this.m_chars[this.m_iTokenEnd] == ';') {
                ++this.m_iTokenEnd;
                return 8;
            }
            if (this.m_chars[this.m_iTokenEnd] == ')') {
                ++this.m_iTokenEnd;
                return 4;
            }
            if (this.m_chars[this.m_iTokenEnd] == ',') {
                ++this.m_iTokenEnd;
                return 1;
            }
            if (this.m_chars[this.m_iTokenEnd] == '[') {
                ++this.m_iTokenEnd;
                while (this.m_iTokenEnd < this.m_chars.length && this.m_chars[this.m_iTokenEnd - 1] != ']') {
                    ++this.m_iTokenEnd;
                }
                return 6;
            }
            while (this.m_iTokenEnd < this.m_chars.length && this.m_chars[this.m_iTokenEnd] != ' ' && this.m_chars[this.m_iTokenEnd] != '\t' && this.m_chars[this.m_iTokenEnd] != '(' && this.m_chars[this.m_iTokenEnd] != ')' && this.m_chars[this.m_iTokenEnd] != '[' && this.m_chars[this.m_iTokenEnd] != ':' && this.m_chars[this.m_iTokenEnd] != ',' && this.m_chars[this.m_iTokenEnd] != ';') {
                ++this.m_iTokenEnd;
            }
            return 7;
        }
        return 0;
    }

    public Node parseNewick(String string) {
        try {
            if (string == null || string.length() == 0) {
                return null;
            }
            this.m_chars = string.toCharArray();
            this.m_iTokenStart = string.indexOf(40);
            if (this.m_iTokenStart < 0) {
                return null;
            }
            this.m_iTokenEnd = this.m_iTokenStart;
            Vector<Node> vector = new Vector<Node>();
            Vector<Boolean> vector2 = new Vector<Boolean>();
            Vector<String> vector3 = new Vector<String>();
            vector.add(new Node());
            vector2.add(true);
            ((Node)vector.lastElement()).setHeight(0.001f);
            vector3.add(null);
            boolean bl = true;
            block11: while (this.m_iTokenEnd < this.m_chars.length) {
                switch (this.nextToken()) {
                    case 3: {
                        Object object3 = new Node();
                        ((Node)object3).setHeight(0.001f);
                        vector.add((Node)object3);
                        vector2.add(true);
                        vector3.add(null);
                        bl = true;
                        continue block11;
                    }
                    case 4: {
                        Object object;
                        Node node;
                        Object object2;
                        Object object3;
                        if (((Boolean)vector2.lastElement()).booleanValue()) {
                            if (this.m_bAllowSingleChild) {
                                object3 = (Node)vector.lastElement();
                                vector.remove(vector.size() - 1);
                                vector2.remove(vector2.size() - 1);
                                object2 = new Node();
                                ((Node)object2).setHeight(0.001f);
                                ((Node)object2).setLeft((Node)object3);
                                ((Node)object3).setParent((Node)object2);
                                ((Node)object2).setRight(null);
                                node = (Node)vector.lastElement();
                                node.setLeft((Node)object3);
                                ((Node)object3).setParent(node);
                                object = (String)vector3.remove(vector3.size() - 1);
                                ((Node)object3).metaDataString = object;
                                this.parseMetaData((Node)object3, (String)object);
                                continue block11;
                            }
                            throw new IllegalArgumentException("Node with single child found.");
                        }
                        while (!((Boolean)vector2.elementAt(vector2.size() - 2)).booleanValue()) {
                            object3 = (Node)vector.lastElement();
                            vector.remove(vector.size() - 1);
                            vector2.remove(vector2.size() - 1);
                            object2 = (Node)vector.lastElement();
                            vector.remove(vector.size() - 1);
                            vector2.remove(vector2.size() - 1);
                            node = new Node();
                            node.setHeight(0.001f);
                            node.setLeft((Node)object2);
                            ((Node)object2).setParent(node);
                            node.setRight((Node)object3);
                            ((Node)object3).setParent(node);
                            vector.add(node);
                            vector2.add(false);
                            object = (String)vector3.remove(vector3.size() - 1);
                            this.parseMetaData((Node)object2, (String)object);
                        }
                        object3 = (Node)vector.lastElement();
                        vector.remove(vector.size() - 1);
                        vector2.remove(vector2.size() - 1);
                        object2 = (String)vector3.remove(vector3.size() - 1);
                        this.parseMetaData((Node)object3, (String)object2);
                        node = (Node)vector.lastElement();
                        vector.remove(vector.size() - 1);
                        vector2.remove(vector2.size() - 1);
                        object2 = (String)vector3.remove(vector3.size() - 1);
                        this.parseMetaData(node, (String)object2);
                        object = (Node)vector.lastElement();
                        ((Node)object).setLeft(node);
                        node.setParent((Node)object);
                        ((Node)object).setRight((Node)object3);
                        ((Node)object3).setParent((Node)object);
                        object2 = (String)vector3.lastElement();
                        this.parseMetaData((Node)object, (String)object2);
                        continue block11;
                    }
                    case 1: {
                        Object object3 = new Node();
                        ((Node)object3).setHeight(0.001f);
                        vector.add((Node)object3);
                        vector2.add(false);
                        vector3.add(null);
                        bl = true;
                        continue block11;
                    }
                    case 5: {
                        bl = false;
                        continue block11;
                    }
                    case 7: {
                        Object object3;
                        if (bl) {
                            object3 = string.substring(this.m_iTokenStart, this.m_iTokenEnd);
                            ((Node)vector.lastElement()).setNr(this.getLabelIndex((String)object3));
                            continue block11;
                        }
                        object3 = string.substring(this.m_iTokenStart, this.m_iTokenEnd);
                        ((Node)vector.lastElement()).setHeight(Float.parseFloat((String)object3));
                        continue block11;
                    }
                    case 6: {
                        if (vector3.lastElement() == null) {
                            vector3.set(vector3.size() - 1, string.substring(this.m_iTokenStart + 1, this.m_iTokenEnd - 1));
                            continue block11;
                        }
                        vector3.set(vector3.size() - 1, (String)vector3.lastElement() + "," + string.substring(this.m_iTokenStart + 1, this.m_iTokenEnd - 1));
                        continue block11;
                    }
                    case 8: {
                        this.parseMetaData((Node)vector.lastElement(), (String)vector3.lastElement());
                        return (Node)vector.lastElement();
                    }
                }
                throw new IllegalArgumentException("parseNewick: unknown token");
            }
            return (Node)vector.lastElement();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new IllegalArgumentException(exception.getMessage() + ": " + string.substring(Math.max(0, this.m_iTokenStart - 100), this.m_iTokenStart) + " >>>" + string.substring(this.m_iTokenStart, this.m_iTokenEnd) + " <<< ...");
        }
    }

    public void parseMetaData(Node node, String string) {
        node.metaDataString = string;
        if (string == null) {
            return;
        }
        int n = 0;
        int n2 = 1;
        try {
            while ((n = string.indexOf(61, n)) >= 0) {
                String string2 = string.substring(n2, n).trim();
                String string3 = null;
                int n3 = 0;
                n3 = string.indexOf(61, n + 1);
                if (n3 >= 0) {
                    int n4 = string.lastIndexOf(44, n3);
                    string3 = string.substring(n + 1, n4);
                    n2 = n4 + 1;
                } else {
                    string3 = string.substring(n + 1);
                }
                if (string3.length() > 0 && string3.charAt(0) != '{') {
                    try {
                        Double d = Double.parseDouble(string3);
                        node.setMetaData(string2, d);
                    }
                    catch (Exception exception) {
                        node.setMetaData(string2, string3);
                    }
                } else if (string3.length() > 0 && string3.charAt(0) == '{' && string3.charAt(string3.length() - 1) == '}') {
                    try {
                        String string4 = string3.substring(1, string3.length() - 1);
                        String[] stringArray = string4.split(",");
                        Double[] doubleArray = new Double[stringArray.length];
                        for (int i = 0; i < stringArray.length; ++i) {
                            doubleArray[i] = Double.parseDouble(stringArray[i]);
                        }
                        node.setMetaData(string2, doubleArray);
                    }
                    catch (Exception exception) {
                        node.setMetaData(string2, string3);
                    }
                } else {
                    node.setMetaData(string2, string3);
                }
                ++n;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

