/*
 * Decompiled with CFR 0.152.
 */
package beast.app.tools;

import beast.app.BEASTVersion2;
import beast.app.util.Utils;
import beast.app.util.WholeNumberField;
import beast.core.util.Log;
import beast.evolution.tree.coalescent.CompoundPopulationFunction;
import beast.math.statistic.DiscreteStatistics;
import beast.util.HeapSort;
import jam.console.ConsoleApplication;
import jam.panels.OptionsPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;

public class EBSPAnalyser {
    String m_sFileOut;
    PrintStream m_out = System.out;
    CompoundPopulationFunction.Type m_type = CompoundPopulationFunction.Type.LINEAR;
    String m_sInputFile;
    int m_nBurninPercentage = 10;

    private void run() throws IOException {
        this.parse(this.m_sInputFile, this.m_nBurninPercentage, this.m_type, this.m_out);
    }

    void parse(String string, int n, CompoundPopulationFunction.Type type2, PrintStream printStream) throws IOException {
        Object object;
        int n2;
        String string2;
        this.logln("Processing " + string);
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
        int n3 = 0;
        while (bufferedReader.ready()) {
            string2 = bufferedReader.readLine();
            if (string2.charAt(0) == '#' && (n2 = string2.indexOf("spec=")) > 0) {
                if (string2.indexOf("type=\"stepwise\"") > 0) {
                    this.m_type = CompoundPopulationFunction.Type.STEPWISE;
                } else if (string2.indexOf("type=\"linear\"") > 0) {
                    this.m_type = CompoundPopulationFunction.Type.LINEAR;
                }
            }
            if (string2.indexOf(35) >= 0 || !string2.matches(".*[0-9a-zA-Z].*")) continue;
            ++n3;
        }
        n2 = n3 * n / 100;
        this.logln(" skipping " + n2 + " line\n\n");
        n3 = -n2 - 1;
        bufferedReader.close();
        bufferedReader = new BufferedReader(new FileReader(string));
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList arrayList2 = new ArrayList();
        Object object2 = null;
        while (bufferedReader.ready()) {
            string2 = bufferedReader.readLine();
            if (string2.indexOf(35) >= 0 || !string2.matches(".*[0-9a-zA-Z].*") || ++n3 <= 0) continue;
            String[] stringArray = string2.split("\t");
            object = new ArrayList();
            ArrayList<Double> arrayList3 = new ArrayList<Double>();
            if (object2 == null) {
                object2 = new double[stringArray.length - 1];
            }
            for (int i = 1; i < stringArray.length; ++i) {
                String[] stringArray2 = stringArray[i].split(":");
                Double d = Double.parseDouble(stringArray2[0]);
                Object object3 = object2;
                int n4 = i - 1;
                object3[n4] = object3[n4] + d;
                if (stringArray2.length <= 1) continue;
                object.add(d);
                arrayList3.add(Double.parseDouble(stringArray2[1]));
            }
            arrayList.add(object);
            arrayList2.add(arrayList3);
        }
        if (object2 == null) {
            return;
        }
        int n5 = 0;
        while (n5 < (object2).length) {
            ArrayList<Double> arrayList4 = object2;
            int n6 = n5++;
            arrayList4[n6] = arrayList4[n6] / (double)arrayList.size();
        }
        printStream.println("time\tmean\tmedian\t95HPD lower\t95HPD upper");
        double[] dArray = new double[arrayList.size()];
        object = new int[arrayList.size()];
        for (ArrayList arrayList5 : object2) {
            for (int i = 0; i < dArray.length; ++i) {
                dArray[i] = this.calcPopSize(type2, (List)arrayList.get(i), (List)arrayList2.get(i), (double)arrayList5);
            }
            HeapSort.sort(dArray, (int[])object);
            printStream.print((double)arrayList5 + "\t");
            printStream.print(DiscreteStatistics.mean(dArray) + "\t");
            printStream.print(DiscreteStatistics.median(dArray) + "\t");
            double[] dArray2 = DiscreteStatistics.HPDInterval(0.95, dArray, (int[])object);
            printStream.println(dArray2[0] + "\t" + dArray2[1]);
        }
    }

    private double calcPopSize(CompoundPopulationFunction.Type type2, List<Double> list, List<Double> list2, double d) {
        int n = list.size();
        double d2 = list.get(n - 1);
        if (d >= d2) {
            return list2.get(n - 1);
        }
        assert (d >= list.get(0));
        int n2 = 1;
        while (d >= list.get(n2)) {
            ++n2;
        }
        double d3 = list.get(n2 - 1);
        double d4 = list.get(n2);
        double d5 = list2.get(n2 - 1);
        double d6 = list2.get(n2);
        assert (d3 <= d && d <= d4) : "" + d3 + "," + d4 + "," + d;
        switch (type2) {
            case LINEAR: {
                double d7 = (d * (d6 - d5) + (d5 * d4 - d6 * d3)) / (d4 - d3);
                assert (d7 > 0.0);
                return d7;
            }
            case STEPWISE: {
                assert (d6 > 0.0);
                return d6;
            }
        }
        return 0.0;
    }

    private void parseArgs(String[] stringArray) {
        int n = 0;
        try {
            while (n < stringArray.length) {
                int n2 = n;
                if (n >= stringArray.length) continue;
                if (stringArray[n].equals("")) {
                    ++n;
                } else if (stringArray[n].equals("-help") || stringArray[n].equals("-h") || stringArray[n].equals("--help")) {
                    System.out.println(EBSPAnalyser.getUsage());
                    System.exit(0);
                } else if (stringArray[n].equals("-i")) {
                    this.m_sInputFile = stringArray[n + 1];
                    n += 2;
                } else if (stringArray[n].equals("-o")) {
                    this.m_sFileOut = stringArray[n + 1];
                    this.m_out = new PrintStream(this.m_sFileOut);
                    n += 2;
                } else if (stringArray[n].equals("-type")) {
                    if (stringArray[n + 1].equals("linear")) {
                        this.m_type = CompoundPopulationFunction.Type.LINEAR;
                    } else if (stringArray[n + 1].equals("stepwise")) {
                        this.m_type = CompoundPopulationFunction.Type.STEPWISE;
                    } else {
                        throw new IllegalArgumentException("Expected linear or stepwise, not " + stringArray[n + 1]);
                    }
                    n += 2;
                } else if (stringArray[n].equals("-burnin")) {
                    this.m_nBurninPercentage = Integer.parseInt(stringArray[n + 1]);
                    n += 2;
                }
                if (n != n2) continue;
                throw new IllegalArgumentException("Unrecognised argument (argument " + n + ": " + stringArray[n] + ")");
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw illegalArgumentException;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new IllegalArgumentException("Error parsing command line arguments: " + Arrays.toString(stringArray) + "\nArguments ignored\n\n" + EBSPAnalyser.getUsage());
        }
        if (this.m_sFileOut == null) {
            Log.warning.println("No output file specified");
        }
    }

    static String getUsage() {
        return "EBSPAnalyse -i <inputfile> [options]\nanalyses trace file generated by EBSP analysis\nOptions are:\n-i <inputfile> name of input file (required)\n-burnin <percentage> percent of log to consider burn in, default 10\n-type [linear|step] type of population function\n-o <outputfile> name of output file, default to output on stdout\n";
    }

    protected void log(String string) {
        Log.warning.print(string);
    }

    protected void logln(String string) {
        Log.warning.println(string);
    }

    private void printTitle(String string) {
        String[] stringArray;
        string = "LogCombiner" + string.replaceAll("</p>", "\n\n");
        string = string.replaceAll("<br>", "\n");
        string = string.replaceAll("<[^>]*>", " ");
        for (String string2 : stringArray = string.split("\n")) {
            int n = 80 - string2.length();
            int n2 = n / 2;
            for (int i = 0; i < n2; ++i) {
                this.log(" ");
            }
            this.logln(string2);
        }
    }

    public static void main(String[] stringArray) {
        BEASTVersion2 bEASTVersion2 = new BEASTVersion2();
        String string = bEASTVersion2.getVersionString();
        String string2 = "EBSP Analyser " + string;
        String string3 = "<html><center><p>" + string + ", " + bEASTVersion2.getDateString() + "</p>" + "<p>by<br>" + "<p>Joseph Heled and Remco Bouckaert</p>" + "<p>Department of Computer Science, University of Auckland<br>" + "<a href=\"mailto:jheled@gmail.com\">jheled@gmail.com</a></p>" + "<a href=\"mailto:remco@cs.auckland.ac.nz\">remco@cs.auckland.ac.nz</a></p>" + "<p>Part of the BEAST 2 package:<br>" + "<a href=\"http://beast2.cs.auckland.ac.nz/\">http://beast2.cs.auckland.ac.nz/</a></p>" + "</center></html>";
        try {
            EBSPAnalyser eBSPAnalyser = new EBSPAnalyser();
            if (stringArray.length == 0) {
                Utils.loadUIManager();
                System.setProperty("com.apple.macos.useScreenMenuBar", "true");
                System.setProperty("apple.laf.useScreenMenuBar", "true");
                System.setProperty("apple.awt.showGrowBox", "true");
                URL uRL = EBSPAnalyser.class.getResource("images/EBSPAnalyser.png");
                ImageIcon imageIcon = null;
                if (uRL != null) {
                    imageIcon = new ImageIcon(uRL);
                }
                new ConsoleApplication(string2, string3, imageIcon, true);
                eBSPAnalyser.printTitle(string3);
                String string4 = "<html><center><p>EBSPAnalyser<br>Version " + bEASTVersion2.getVersionString() + ", " + bEASTVersion2.getDateString() + "</p></center></html>";
                EBSPAnalyser eBSPAnalyser2 = eBSPAnalyser;
                eBSPAnalyser2.getClass();
                EBSPAnalyserDialog eBSPAnalyserDialog = eBSPAnalyser2.new EBSPAnalyserDialog(new JFrame(), string4, imageIcon);
                if (!eBSPAnalyserDialog.showDialog(string2)) {
                    return;
                }
                String[] stringArray2 = eBSPAnalyserDialog.getArgs();
                try {
                    eBSPAnalyser.parseArgs(stringArray2);
                    eBSPAnalyser.run();
                }
                catch (Exception exception) {
                    Log.err.println("Exception: " + exception.getMessage());
                    exception.printStackTrace();
                }
                System.out.println("Finished - Quit program to exit.");
                while (true) {
                    try {
                        while (true) {
                            Thread.sleep(1000L);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                        continue;
                    }
                    break;
                }
            }
            eBSPAnalyser.printTitle(string3);
            eBSPAnalyser.parseArgs(stringArray);
            eBSPAnalyser.run();
        }
        catch (Exception exception) {
            System.out.println(EBSPAnalyser.getUsage());
            exception.printStackTrace();
        }
    }

    public class EBSPAnalyserDialog {
        private final JFrame frame;
        private final OptionsPanel optionPanel;
        private final JTextField inputFileNameText = new JTextField("not selected", 16);
        private final JComboBox<String> typeCombo = new JComboBox<String>(new String[]{"linear", "stepwise"});
        final WholeNumberField burninText = new WholeNumberField(0L, Long.MAX_VALUE);
        private final JTextField outputFileNameText = new JTextField("not selected", 16);
        private File outputFile = null;
        private File inputFile = null;

        public EBSPAnalyserDialog(JFrame jFrame, String string, Icon icon) {
            this.frame = jFrame;
            this.optionPanel = new OptionsPanel(12, 12);
            JLabel jLabel = new JLabel(string);
            jLabel.setIcon(icon);
            this.optionPanel.addSpanningComponent(jLabel);
            Font font = UIManager.getFont("Label.font");
            jLabel.setFont(new Font("sans-serif", font.getStyle(), font.getSize()));
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.setOpaque(false);
            JButton jButton = new JButton("Choose Input File...");
            jButton.addActionListener(actionEvent -> {
                File file = Utils.getLoadFile("Select input file...");
                if (file == null) {
                    return;
                }
                this.inputFile = file;
                this.inputFileNameText.setText(this.inputFile.getName());
            });
            this.inputFileNameText.setEditable(false);
            JButton jButton2 = new JButton("Choose Output File...");
            jButton2.addActionListener(actionEvent -> {
                File file = Utils.getSaveFile("Select output file...");
                if (file == null) {
                    return;
                }
                this.outputFile = file;
                this.outputFileNameText.setText(this.outputFile.getName());
            });
            this.outputFileNameText.setEditable(false);
            JPanel jPanel2 = new JPanel(new BorderLayout(0, 0));
            jPanel2.add((Component)this.inputFileNameText, "Center");
            jPanel2.add((Component)jButton, "East");
            this.optionPanel.addComponentWithLabel("Input File: ", jPanel2);
            this.optionPanel.addComponentWithLabel("File type: ", this.typeCombo);
            this.burninText.setColumns(12);
            this.burninText.setValue(10);
            this.optionPanel.addComponentWithLabel("Burn in percentage: ", this.burninText);
            this.optionPanel.addSpanningComponent(jPanel);
            JPanel jPanel3 = new JPanel(new BorderLayout(0, 0));
            jPanel3.add((Component)this.outputFileNameText, "Center");
            jPanel3.add((Component)jButton2, "East");
            this.optionPanel.addComponentWithLabel("Output File: ", jPanel3);
        }

        public boolean showDialog(String string) {
            JOptionPane jOptionPane = new JOptionPane(this.optionPanel, -1, 2, null, new String[]{"Run", "Quit"}, null);
            jOptionPane.setBorder(new EmptyBorder(12, 12, 12, 12));
            JDialog jDialog = jOptionPane.createDialog(this.frame, string);
            jDialog.pack();
            jDialog.setVisible(true);
            return jOptionPane.getValue().equals("Run");
        }

        public String getOutputFileName() {
            if (this.outputFile == null) {
                return null;
            }
            return this.outputFile.getPath();
        }

        public String[] getArgs() {
            ArrayList<String> arrayList = new ArrayList<String>();
            if (this.inputFile != null) {
                arrayList.add("-i");
                arrayList.add(this.inputFile.getPath());
            }
            arrayList.add("-burnin");
            arrayList.add(this.burninText.getText());
            arrayList.add("-type");
            arrayList.add(this.typeCombo.getSelectedItem().toString());
            if (this.outputFile != null) {
                arrayList.add("-o");
                arrayList.add(this.outputFile.getPath());
            }
            return arrayList.toArray(new String[0]);
        }
    }
}

