/*
 * Decompiled with CFR 0.152.
 */
package beast.app.draw;

import beast.app.beauti.BeautiDoc;
import beast.app.draw.BEASTObjectDialog;
import beast.app.draw.BEASTObjectPanel;
import beast.app.draw.InputEditor;
import beast.app.draw.SmallButton;
import beast.app.draw.SmallLabel;
import beast.core.BEASTInterface;
import beast.core.Input;
import beast.core.util.Log;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class ListInputEditor
extends InputEditor.Base {
    private static final long serialVersionUID = 1L;
    static Image DOWN_ICON;
    static Image RIGHT_ICON;
    protected InputEditor.ButtonStatus m_buttonStatus;
    protected SmallButton addButton;
    protected List<JTextField> m_entries;
    protected List<SmallButton> delButtonList;
    protected List<SmallButton> m_editButton;
    protected List<SmallLabel> m_validateLabels;
    protected Box m_listBox;
    protected InputEditor.ExpandOption m_bExpandOption;
    protected Box buttonBox;
    protected static Set<String> g_collapsedIDs;
    static Set<String> g_initiallyCollapsedIDs;

    public ListInputEditor(BeautiDoc beautiDoc) {
        super(beautiDoc);
        try {
            URL uRL = ClassLoader.getSystemResource("beast/app/draw/icons/down.png");
            DOWN_ICON = ImageIO.read(uRL);
            URL uRL2 = ClassLoader.getSystemResource("beast/app/draw/icons/right.png");
            RIGHT_ICON = ImageIO.read(uRL2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.m_buttonStatus = InputEditor.ButtonStatus.ALL;
        this.m_entries = new ArrayList<JTextField>();
        this.delButtonList = new ArrayList<SmallButton>();
        this.m_editButton = new ArrayList<SmallButton>();
        this.m_validateLabels = new ArrayList<SmallLabel>();
        this.m_bExpandOption = InputEditor.ExpandOption.FALSE;
        this.setLayout(new BoxLayout(this, 1));
    }

    @Override
    public Class<?> type() {
        return ArrayList.class;
    }

    public Class<?> baseType() {
        return BEASTInterface.class;
    }

    @Override
    public void init(Input<?> input, BEASTInterface bEASTInterface, int n, InputEditor.ExpandOption expandOption, boolean bl) {
        this.m_bAddButtons = bl;
        this.m_bExpandOption = expandOption;
        this.m_input = input;
        this.m_beastObject = bEASTInterface;
        this.itemNr = -1;
        this.addInputLabel();
        if (this.m_inputLabel != null) {
            this.m_inputLabel.setMaximumSize(new Dimension(this.m_inputLabel.getSize().width, 1000));
            this.m_inputLabel.setAlignmentY(1.0f);
            this.m_inputLabel.setVerticalAlignment(1);
            this.m_inputLabel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        }
        this.m_listBox = Box.createVerticalBox();
        for (Object e : (List)input.get()) {
            if (!(e instanceof BEASTInterface)) continue;
            BEASTInterface bEASTInterface2 = (BEASTInterface)e;
            this.addSingleItem(bEASTInterface2);
        }
        this.setLayout(new BorderLayout());
        this.add((Component)this.m_listBox, "North");
        this.buttonBox = Box.createHorizontalBox();
        if (this.m_buttonStatus == InputEditor.ButtonStatus.ALL || this.m_buttonStatus == InputEditor.ButtonStatus.ADD_ONLY) {
            this.addButton = new SmallButton("+", true);
            this.addButton.setName("+");
            this.addButton.setToolTipText("Add item to the list");
            this.addButton.addActionListener(actionEvent -> this.addItem());
            this.buttonBox.add(this.addButton);
            if (!this.doc.isExpertMode()) {
                ArrayList arrayList = new ArrayList();
                for (int i = 0; i < this.m_entries.size(); ++i) {
                    arrayList.add(this.m_entries.get(i).getText());
                }
                List<String> list = this.doc.getInputEditorFactory().getAvailablePlugins(this.m_input, this.m_beastObject, arrayList, this.doc);
                if (list.size() == 0) {
                    this.addButton.setVisible(false);
                }
            }
        }
        this.m_validateLabel = new SmallLabel("x", new Color(200, 0, 0));
        if (this.m_bAddButtons) {
            this.buttonBox.add(this.m_validateLabel);
            this.m_validateLabel.setVisible(true);
            this.validateInput();
        }
        this.buttonBox.add(Box.createHorizontalGlue());
        this.m_listBox.add(this.buttonBox);
        this.updateState();
    }

    protected void addSingleItem(BEASTInterface bEASTInterface) {
        Component component;
        Object object;
        block12: {
            object = Box.createHorizontalBox();
            InputEditor inputEditor = this.addPluginItem((Box)object, bEASTInterface);
            SmallButton smallButton = new SmallButton("e", true, SmallButton.ButtonType.square);
            smallButton.setName(bEASTInterface.getID() + ".editButton");
            if (this.m_bExpandOption == InputEditor.ExpandOption.FALSE || this.m_bExpandOption == InputEditor.ExpandOption.IF_ONE_ITEM && ((List)this.m_input.get()).size() > 1) {
                smallButton.setToolTipText("Edit item in the list");
                smallButton.addActionListener(new ActionListenerObject(bEASTInterface){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        this.m_o = ListInputEditor.this.editItem(this.m_o);
                    }
                });
            } else {
                smallButton.setText("");
                smallButton.setToolTipText("Expand/collapse item in the list");
                smallButton.setButtonType(SmallButton.ButtonType.toolbar);
            }
            this.m_editButton.add(smallButton);
            ((Container)object).add(smallButton);
            SmallLabel smallLabel = new SmallLabel("x", new Color(200, 0, 0));
            ((Container)object).add(smallLabel);
            smallLabel.setVisible(true);
            this.m_validateLabels.add(smallLabel);
            if (this.m_bExpandOption == InputEditor.ExpandOption.TRUE || this.m_bExpandOption == InputEditor.ExpandOption.TRUE_START_COLLAPSED || this.m_bExpandOption == InputEditor.ExpandOption.IF_ONE_ITEM && ((List)this.m_input.get()).size() == 1) {
                Object object2;
                component = Box.createVerticalBox();
                this.doc.getInputEditorFactory().addInputs((Box)component, bEASTInterface, inputEditor, null, this.doc);
                if (((Container)component).getComponentCount() > 1) {
                    object2 = Box.createVerticalBox();
                    ((Container)object2).add((Component)object);
                    ((Container)object).add((Component)smallButton, 0);
                    ((Container)object2).add(component);
                    object = object2;
                } else {
                    smallButton.setVisible(false);
                }
                smallButton.addActionListener(new ExpandActionListener((Box)component, bEASTInterface){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        SmallButton smallButton = (SmallButton)actionEvent.getSource();
                        this.m_box.setVisible(!this.m_box.isVisible());
                        if (this.m_box.isVisible()) {
                            try {
                                smallButton.setImg(DOWN_ICON);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            g_collapsedIDs.remove(this.m_beastObject.getID());
                        } else {
                            try {
                                smallButton.setImg(RIGHT_ICON);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            g_collapsedIDs.add(this.m_beastObject.getID());
                        }
                    }
                });
                object2 = bEASTInterface.getID();
                ((JComponent)component).setVisible(!g_collapsedIDs.contains(object2));
                try {
                    if (component.isVisible()) {
                        smallButton.setImg(DOWN_ICON);
                        break block12;
                    }
                    smallButton.setImg(RIGHT_ICON);
                }
                catch (Exception exception) {}
            } else if (BEASTObjectPanel.countInputs(bEASTInterface, this.doc) == 0) {
                smallButton.setVisible(false);
            }
        }
        if (this.m_validateLabel == null) {
            this.m_listBox.add((Component)object);
        } else {
            component = this.m_listBox.getComponent(this.m_listBox.getComponentCount() - 1);
            this.m_listBox.remove(component);
            this.m_listBox.add((Component)object);
            this.m_listBox.add(component);
        }
    }

    protected InputEditor addPluginItem(Box box, BEASTInterface bEASTInterface) {
        String string = bEASTInterface.getID();
        if (string == null || string.length() == 0) {
            string = bEASTInterface.getClass().getName();
            string = string.substring(string.lastIndexOf(46) + 1);
        }
        JLabel jLabel = new JLabel(string);
        box.add(Box.createRigidArea(new Dimension(5, 1)));
        box.add(jLabel);
        box.add(Box.createHorizontalGlue());
        return this;
    }

    protected void addItem() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.m_entries.size(); ++i) {
            arrayList.add(this.m_entries.get(i).getText());
        }
        List<BEASTInterface> list = this.pluginSelector(this.m_input, this.m_beastObject, arrayList);
        if (list != null) {
            for (BEASTInterface bEASTInterface : list) {
                try {
                    this.setValue(bEASTInterface);
                }
                catch (Exception exception) {
                    Log.err.println(exception.getClass().getName() + " " + exception.getMessage());
                }
                this.addSingleItem(bEASTInterface);
                this.getDoc().addPlugin(bEASTInterface);
            }
            this.validateInput();
            this.updateState();
            this.repaint();
        }
    }

    protected Object editItem(Object object) {
        int n = ((List)this.m_input.get()).indexOf(object);
        BEASTInterface bEASTInterface = (BEASTInterface)((List)this.m_input.get()).get(n);
        BEASTObjectDialog bEASTObjectDialog = new BEASTObjectDialog(bEASTInterface, this.m_input.getType(), this.doc);
        if (bEASTObjectDialog.showDialog()) {
            if (this.m_entries.size() > n) {
                this.m_entries.get(n).setText(bEASTObjectDialog.m_panel.m_beastObject.getID());
            }
            bEASTObjectDialog.accept((BEASTInterface)object, this.doc);
            this.refreshPanel();
        }
        BEASTObjectPanel.m_position.x -= 20;
        BEASTObjectPanel.m_position.y -= 20;
        this.validateAllEditors();
        this.updateState();
        this.doLayout();
        return object;
    }

    protected void deleteItem(Object object) {
        int n = ((List)this.m_input.get()).indexOf(object);
        this.m_listBox.remove(n);
        ((List)this.m_input.get()).remove(n);
        this.safeRemove(this.m_entries, n);
        this.safeRemove(this.delButtonList, n);
        this.safeRemove(this.m_editButton, n);
        this.safeRemove(this.m_validateLabels, n);
        this.validateInput();
        this.updateState();
        this.doLayout();
        this.repaint();
    }

    private void safeRemove(List<?> list, int n) {
        if (list.size() > n) {
            list.remove(n);
        }
    }

    protected List<BEASTInterface> pluginSelector(Input<?> input, BEASTInterface bEASTInterface, List<String> list) {
        ArrayList<BEASTInterface> arrayList = new ArrayList<BEASTInterface>();
        List<String> list2 = this.doc.getInputEditorFactory().getAvailablePlugins(input, bEASTInterface, list, this.doc);
        String string = null;
        if (list2.size() == 1) {
            string = list2.get(0);
        } else if (list2.size() == 0) {
            this.doc.setExpertMode(true);
            list2 = this.doc.getInputEditorFactory().getAvailablePlugins(input, bEASTInterface, list, this.doc);
            this.doc.setExpertMode(false);
            string = list2.get(0);
        } else {
            string = (String)JOptionPane.showInputDialog(null, "Select a constant", "select", -1, null, list2.toArray(new String[0]), null);
            if (string == null) {
                return null;
            }
        }
        if (!string.startsWith("new ")) {
            arrayList.add(this.doc.pluginmap.get(string));
            return arrayList;
        }
        try {
            BEASTInterface bEASTInterface2 = (BEASTInterface)Class.forName(string.substring(4)).newInstance();
            BEASTObjectPanel.addPluginToMap(bEASTInterface2, this.doc);
            arrayList.add(bEASTInterface2);
            return arrayList;
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(null, "Could not select beastObject: " + exception.getClass().getName() + " " + exception.getMessage());
            return null;
        }
    }

    protected void updateState() {
        for (int i = 0; i < ((List)this.m_input.get()).size(); ++i) {
            try {
                BEASTInterface bEASTInterface = (BEASTInterface)((List)this.m_input.get()).get(i);
                bEASTInterface.validateInputs();
                this.m_validateLabels.get(i).setVisible(false);
                continue;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                continue;
            }
            catch (Exception exception) {
                if (this.m_validateLabels.size() <= i) continue;
                this.m_validateLabels.get(i).setToolTipText(exception.getMessage());
                this.m_validateLabels.get(i).setVisible(true);
            }
        }
        this.validateInput();
        this.setVisible(false);
        this.setVisible(true);
    }

    @Override
    public void startValidating(InputEditor.ValidationStatus validationStatus) {
        this.updateState();
    }

    public void setButtonStatus(InputEditor.ButtonStatus buttonStatus) {
        this.m_buttonStatus = buttonStatus;
    }

    static {
        g_collapsedIDs = new HashSet<String>();
        g_initiallyCollapsedIDs = new HashSet<String>();
    }

    class IDDocumentListener
    implements DocumentListener {
        BEASTInterface m_beastObject;
        JTextField m_entry;

        IDDocumentListener(BEASTInterface bEASTInterface, JTextField jTextField) {
            this.m_beastObject = bEASTInterface;
            this.m_entry = jTextField;
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.processEntry();
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.processEntry();
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            this.processEntry();
        }

        void processEntry() {
            String string = this.m_beastObject.getID();
            this.m_beastObject.setID(this.m_entry.getText());
            BEASTObjectPanel.renamePluginID(this.m_beastObject, string, this.m_beastObject.getID(), ListInputEditor.this.doc);
            ListInputEditor.this.validateAllEditors();
            this.m_entry.requestFocusInWindow();
        }
    }

    public abstract class ExpandActionListener
    implements ActionListener {
        Box m_box;
        BEASTInterface m_beastObject;

        public ExpandActionListener(Box box, BEASTInterface bEASTInterface) {
            this.m_box = box;
            this.m_beastObject = bEASTInterface;
        }
    }

    public abstract class ActionListenerObject
    implements ActionListener {
        public Object m_o;

        public ActionListenerObject(Object object) {
            this.m_o = object;
        }
    }
}

