/*
 * Decompiled with CFR 0.152.
 */
package beast.app.draw;

import beast.app.beauti.BeautiDoc;
import beast.core.BEASTInterface;
import beast.core.Input;
import beast.core.MCMC;
import beast.core.util.Log;
import beast.util.XMLParser;
import beast.util.XMLProducer;
import java.awt.Dimension;
import java.awt.Point;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Scanner;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class BEASTObjectPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    public BEASTInterface m_beastObject;
    Class<?> m_beastObjectClass;
    JLabel m_beastObjectButton;
    JTextField m_identry;
    private boolean m_bOK = false;
    public static HashMap<String, BEASTInterface> g_plugins = null;
    public static Point m_position;

    public static void init() {
        m_position = new Point(0, 0);
        g_plugins = new HashMap();
    }

    public BEASTObjectPanel(BEASTInterface bEASTInterface, Class<?> clazz, List<BEASTInterface> list, BeautiDoc beautiDoc) {
        for (BEASTInterface bEASTInterface2 : list) {
            String string = BEASTObjectPanel.getID(bEASTInterface2);
            if (g_plugins.containsKey(string)) {
                bEASTInterface2.setID(null);
                string = BEASTObjectPanel.getID(bEASTInterface2);
            }
            BEASTObjectPanel.registerPlugin(BEASTObjectPanel.getID(bEASTInterface2), bEASTInterface2, beautiDoc);
        }
        this.init(bEASTInterface, clazz, true, beautiDoc);
    }

    public static boolean registerPlugin(String string, BEASTInterface bEASTInterface, BeautiDoc beautiDoc) {
        if (beautiDoc != null) {
            beautiDoc.registerPlugin(bEASTInterface);
        }
        if (g_plugins.containsKey(string) && g_plugins.get(string) == bEASTInterface) {
            return true;
        }
        g_plugins.put(string, bEASTInterface);
        return false;
    }

    public static void renamePluginID(BEASTInterface bEASTInterface, String string, String string2, BeautiDoc beautiDoc) {
        if (beautiDoc != null) {
            beautiDoc.unregisterPlugin(bEASTInterface);
        }
        g_plugins.remove(string);
        BEASTObjectPanel.registerPlugin(string2, bEASTInterface, beautiDoc);
    }

    public BEASTObjectPanel(BEASTInterface bEASTInterface, Class<?> clazz, BeautiDoc beautiDoc) {
        this(bEASTInterface, clazz, true, beautiDoc);
    }

    public BEASTObjectPanel(BEASTInterface bEASTInterface, Class<?> clazz, boolean bl, BeautiDoc beautiDoc) {
        this.initPlugins(bEASTInterface, beautiDoc);
        this.init(bEASTInterface, clazz, bl, beautiDoc);
    }

    void init(BEASTInterface bEASTInterface, Class<?> clazz, boolean bl, BeautiDoc beautiDoc) {
        try {
            this.m_beastObject = (BEASTInterface)bEASTInterface.getClass().newInstance();
            for (Input object2 : bEASTInterface.listInputs()) {
                this.m_beastObject.setInputValue(object2.getName(), object2.get());
            }
            this.m_beastObject.setID(bEASTInterface.getID());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.m_beastObjectClass = clazz;
        Box box = Box.createVerticalBox();
        box.add(Box.createVerticalStrut(5));
        if (bl) {
            Box box2 = this.createPluginBox();
            box.add(box2);
            box.add(Box.createVerticalStrut(5));
            if (beautiDoc != null && this.m_identry != null) {
                this.m_identry.setEnabled(false);
            }
        }
        beautiDoc.getInputEditorFactory().addInputs(box, this.m_beastObject, null, null, beautiDoc);
        box.add(Box.createVerticalStrut(5));
        this.add(box);
        Dimension dimension = box.getPreferredSize();
        this.setSize(dimension.width + 10, dimension.height + 30);
        BEASTObjectPanel.m_position.x += 30;
        BEASTObjectPanel.m_position.y += 30;
        this.setLocation(m_position);
    }

    public boolean getOK() {
        BEASTObjectPanel.m_position.x -= 30;
        BEASTObjectPanel.m_position.y -= 30;
        return this.m_bOK;
    }

    public static int countInputs(BEASTInterface bEASTInterface, BeautiDoc beautiDoc) {
        int n = 0;
        try {
            if (bEASTInterface == null) {
                return 0;
            }
            List<Input<?>> list = bEASTInterface.listInputs();
            for (Input<?> input : list) {
                String string = bEASTInterface.getClass().getName() + "." + input.getName();
                if (beautiDoc.beautiConfig.suppressBEASTObjects.contains(string)) continue;
                ++n;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n;
    }

    Box createPluginBox() {
        Box box = Box.createHorizontalBox();
        box.add(Box.createHorizontalGlue());
        JLabel jLabel = new JLabel(this.m_beastObjectClass.getName().replaceAll(".*\\.", "") + ":");
        box.add(jLabel);
        jLabel.setToolTipText(this.m_beastObject.getID() + " is of type " + this.m_beastObject.getClass().getName() + " Click to change.");
        box.add(new JLabel(" " + this.m_beastObject.getID()));
        Box box2 = Box.createVerticalBox();
        box2.setBorder(BorderFactory.createEmptyBorder());
        box2.add(Box.createVerticalStrut(10));
        box2.add(box);
        box2.add(Box.createVerticalStrut(10));
        return box2;
    }

    void processID() {
    }

    static List<BEASTInterface> listAscendants(BEASTInterface bEASTInterface, Collection<BEASTInterface> collection) {
        HashMap<BEASTInterface, List<BEASTInterface>> hashMap = BEASTObjectPanel.getOutputs(collection);
        ArrayList<BEASTInterface> arrayList = new ArrayList<BEASTInterface>();
        arrayList.add(bEASTInterface);
        boolean bl = true;
        while (bl) {
            bl = false;
            for (int i = 0; i < arrayList.size(); ++i) {
                BEASTInterface bEASTInterface2 = (BEASTInterface)arrayList.get(i);
                if (!hashMap.containsKey(bEASTInterface2)) continue;
                for (BEASTInterface bEASTInterface3 : hashMap.get(bEASTInterface2)) {
                    if (arrayList.contains(bEASTInterface3)) continue;
                    arrayList.add(bEASTInterface3);
                    bl = true;
                }
            }
        }
        return arrayList;
    }

    static HashMap<BEASTInterface, List<BEASTInterface>> getOutputs(Collection<BEASTInterface> collection) {
        HashMap<BEASTInterface, List<BEASTInterface>> hashMap = new HashMap<BEASTInterface, List<BEASTInterface>>();
        for (BEASTInterface bEASTInterface : collection) {
            hashMap.put(bEASTInterface, new ArrayList());
        }
        for (BEASTInterface bEASTInterface : collection) {
            try {
                for (Input<?> input : bEASTInterface.listInputs()) {
                    Object obj = input.get();
                    if (obj != null && obj instanceof BEASTInterface) {
                        List<BEASTInterface> list = hashMap.get(obj);
                        list.add(bEASTInterface);
                    }
                    if (obj == null || !(obj instanceof List)) continue;
                    for (Object e : (List)obj) {
                        List<BEASTInterface> list;
                        if (e == null || !(e instanceof BEASTInterface) || (list = hashMap.get(e)) == null) continue;
                        list.add(bEASTInterface);
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return hashMap;
    }

    public void initPlugins(BEASTInterface bEASTInterface, BeautiDoc beautiDoc) {
        BEASTObjectPanel.addPluginToMap(bEASTInterface, beautiDoc);
    }

    public static void addPluginToMap(BEASTInterface bEASTInterface, BeautiDoc beautiDoc) {
        if (BEASTObjectPanel.registerPlugin(BEASTObjectPanel.getID(bEASTInterface), bEASTInterface, beautiDoc)) {
            return;
        }
        try {
            for (Input<?> input : bEASTInterface.listInputs()) {
                if (input.get() == null) continue;
                if (input.get() instanceof BEASTInterface) {
                    BEASTObjectPanel.addPluginToMap((BEASTInterface)input.get(), beautiDoc);
                }
                if (!(input.get() instanceof List)) continue;
                for (Object e : (List)input.get()) {
                    if (!(e instanceof BEASTInterface)) continue;
                    BEASTObjectPanel.addPluginToMap((BEASTInterface)e, beautiDoc);
                }
            }
        }
        catch (Exception exception) {
            Log.warning.println(exception.getClass().getName() + " " + exception.getMessage());
        }
    }

    public static String getID(BEASTInterface bEASTInterface) {
        if (bEASTInterface.getID() == null || bEASTInterface.getID().length() == 0) {
            String string = bEASTInterface.getClass().getName().replaceAll(".*\\.", "");
            int n = 0;
            while (g_plugins.containsKey(string + "." + n)) {
                ++n;
            }
            bEASTInterface.setID(string + "." + n);
        }
        return bEASTInterface.getID();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        String string;
        Object object;
        BEASTObjectPanel bEASTObjectPanel;
        block11: {
            BEASTObjectPanel.init();
            bEASTObjectPanel = null;
            try {
                if (stringArray.length == 0) {
                    bEASTObjectPanel = new BEASTObjectPanel(new MCMC(), Runnable.class, null);
                    break block11;
                }
                if (stringArray[0].equals("-x")) {
                    object = new StringBuilder();
                    string = System.getProperty("line.separator");
                    try (Scanner scanner = new Scanner(new File(stringArray[1]));){
                        while (scanner.hasNextLine()) {
                            ((StringBuilder)object).append(scanner.nextLine() + string);
                        }
                    }
                    BEASTInterface bEASTInterface = new XMLParser().parseBareFragment(((StringBuilder)object).toString(), false);
                    bEASTObjectPanel = new BEASTObjectPanel(bEASTInterface, bEASTInterface.getClass(), null);
                    break block11;
                }
                if (stringArray.length == 1) {
                    bEASTObjectPanel = new BEASTObjectPanel((BEASTInterface)Class.forName(stringArray[0]).newInstance(), Class.forName(stringArray[0]), null);
                    break block11;
                }
                if (stringArray.length == 2) {
                    bEASTObjectPanel = new BEASTObjectPanel((BEASTInterface)Class.forName(stringArray[0]).newInstance(), Class.forName(stringArray[1]), null);
                    break block11;
                }
                throw new IllegalArgumentException("Incorrect number of arguments");
            }
            catch (Exception exception) {
                exception.printStackTrace();
                System.err.println("Usage: " + BEASTObjectPanel.class.getName() + " [-x file ] [class [type]]\n" + "where [class] (optional, default MCMC) is a BEASTObject to edit\n" + "and [type] (optional only if class is specified, default Runnable) the type of the BEASTObject.\n" + "for example\n" + "");
                System.exit(1);
            }
        }
        bEASTObjectPanel.setVisible(true);
        if (bEASTObjectPanel.m_bOK) {
            object = bEASTObjectPanel.m_beastObject;
            string = new XMLProducer().modelToXML((BEASTInterface)object);
            System.out.println(string);
        }
    }

    static {
        BEASTObjectPanel.init();
    }
}

