/*
 * Decompiled with CFR 0.152.
 */
package beast.app.draw;

import beast.app.beauti.BeautiDoc;
import beast.app.beauti.BeautiSubTemplate;
import beast.app.draw.BEASTObjectDialog;
import beast.app.draw.BEASTObjectPanel;
import beast.app.draw.InputEditor;
import beast.app.draw.SmallButton;
import beast.core.BEASTInterface;
import beast.core.Input;
import beast.util.AddOnManager;
import java.awt.Dimension;
import java.util.List;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.border.EtchedBorder;

public class BEASTObjectInputEditor
extends InputEditor.Base {
    private static final long serialVersionUID = 1L;
    JComboBox<Object> m_selectBEASTObjectBox;
    SmallButton m_editBEASTObjectButton;
    BEASTObjectInputEditor _this = this;
    Box m_expansionBox = null;

    public BEASTObjectInputEditor(BeautiDoc beautiDoc) {
        super(beautiDoc);
    }

    @Override
    public Class<?> type() {
        return BEASTInterface.class;
    }

    @Override
    public void init(Input<?> input, BEASTInterface bEASTInterface, int n, InputEditor.ExpandOption expandOption, boolean bl) {
        this.m_bAddButtons = bl;
        this.m_input = input;
        this.m_beastObject = bEASTInterface;
        this.itemNr = n;
        if (expandOption == InputEditor.ExpandOption.FALSE) {
            this.simpleInit(input, bEASTInterface);
        } else {
            this.expandedInit(input, bEASTInterface);
        }
    }

    void simpleInit(Input<?> input, BEASTInterface bEASTInterface) {
        this.addInputLabel();
        this.addComboBox(this, input, bEASTInterface);
        if (this.m_bAddButtons && BEASTObjectPanel.countInputs((BEASTInterface)this.m_input.get(), this.doc) > 0) {
            this.m_editBEASTObjectButton = new SmallButton("e", true);
            if (input.get() == null) {
                this.m_editBEASTObjectButton.setEnabled(false);
            }
            this.m_editBEASTObjectButton.setToolTipText("Edit " + this.m_inputLabel.getText());
            this.m_editBEASTObjectButton.addActionListener(actionEvent -> {
                BEASTObjectDialog bEASTObjectDialog = new BEASTObjectDialog((BEASTInterface)this.m_input.get(), this.m_input.getType(), this.doc);
                if (bEASTObjectDialog.showDialog()) {
                    try {
                        bEASTObjectDialog.accept((BEASTInterface)this.m_input.get(), this.doc);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                this.refresh();
                this.validateInput();
                this.refreshPanel();
            });
            this.add(this.m_editBEASTObjectButton);
        }
        this.addValidationLabel();
    }

    void refresh() {
        if (this.m_selectBEASTObjectBox != null) {
            String string = (String)this.m_selectBEASTObjectBox.getSelectedItem();
            String string2 = ((BEASTInterface)this.m_input.get()).getID();
            if (!string2.equals(string)) {
                this.m_selectBEASTObjectBox.addItem(string2);
                this.m_selectBEASTObjectBox.setSelectedItem(string2);
                this.m_selectBEASTObjectBox.removeItem(string);
            }
        }
        super.refreshPanel();
    }

    void initSelectPluginBox() {
        List<String> list = this.doc.getInputEditorFactory().getAvailablePlugins(this.m_input, this.m_beastObject, null, this.doc);
        if (list.size() > 0) {
            list.add("<none>");
            for (int i = 0; i < list.size(); ++i) {
                String string = list.get(i);
                if (!string.startsWith("new ")) continue;
                string = string.substring(string.lastIndexOf(46));
                list.set(i, string);
            }
            this.m_selectBEASTObjectBox.removeAllItems();
            for (String string : list.toArray(new String[0])) {
                this.m_selectBEASTObjectBox.addItem(string);
            }
            this.m_selectBEASTObjectBox.setSelectedItem(this.m_beastObject.getID());
        }
    }

    void expandedInit(Input<?> input, BEASTInterface bEASTInterface) {
        this.addInputLabel();
        Box box = Box.createVerticalBox();
        Box box2 = Box.createHorizontalBox();
        this.addComboBox(box2, input, bEASTInterface);
        box.add(box2);
        this.doc.getInputEditorFactory().addInputs(box, (BEASTInterface)input.get(), this, this, this.doc);
        box.setBorder(new EtchedBorder());
        this.add(box);
        this.m_expansionBox = box;
    }

    protected void addComboBox(JComponent jComponent, Input<?> input, BEASTInterface bEASTInterface) {
        if (this.itemNr >= 0) {
            jComponent.add(new JLabel(bEASTInterface.getID()));
            jComponent.add(Box.createGlue());
            return;
        }
        List<BeautiSubTemplate> list = this.doc.getInputEditorFactory().getAvailableTemplates(this.m_input, this.m_beastObject, null, this.doc);
        if (list.size() > 0) {
            String string;
            this.m_selectBEASTObjectBox = new JComboBox<Object>(list.toArray());
            this.m_selectBEASTObjectBox.setName(input.getName());
            Object object = input.get();
            if (this.itemNr >= 0) {
                object = ((List)object).get(this.itemNr);
            }
            if ((string = object == null ? bEASTInterface.getID() : ((BEASTInterface)object).getID()).indexOf(46) >= 0) {
                string = string.substring(0, string.indexOf(46));
            }
            for (BeautiSubTemplate beautiSubTemplate : list) {
                if (!beautiSubTemplate.matchesName(string)) continue;
                this.m_selectBEASTObjectBox.setSelectedItem(beautiSubTemplate);
            }
            this.m_selectBEASTObjectBox.addActionListener(actionEvent -> {
                BeautiSubTemplate beautiSubTemplate = (BeautiSubTemplate)this.m_selectBEASTObjectBox.getSelectedItem();
                BEASTInterface bEASTInterface = (BEASTInterface)this.m_input.get();
                String string = bEASTInterface.getID();
                String string2 = string.substring(string.indexOf(46) + 1);
                if (string2.indexOf(58) >= 0) {
                    string2 = string.substring(string.indexOf(58) + 1);
                }
                if (beautiSubTemplate.equals("<none>")) {
                    bEASTInterface = null;
                } else {
                    try {
                        bEASTInterface = beautiSubTemplate.createSubNet(this.doc.getContextFor(bEASTInterface), this.m_beastObject, this.m_input, true);
                    }
                    catch (Exception exception) {
                        JOptionPane.showMessageDialog(null, "Could not select beastObject: " + exception.getClass().getName() + " " + exception.getMessage());
                    }
                }
                try {
                    if (bEASTInterface == null) {
                        this.m_selectBEASTObjectBox.setSelectedItem("<none>");
                        if (this.m_expansionBox != null) {
                            for (int i = 1; i < this.m_expansionBox.getComponentCount(); ++i) {
                                this.m_expansionBox.remove(i);
                            }
                        } else if (this.m_bAddButtons && this.m_editBEASTObjectButton != null) {
                            this.m_editBEASTObjectButton.setEnabled(false);
                        }
                    } else {
                        if (!this.m_input.canSetValue(bEASTInterface, this.m_beastObject)) {
                            throw new IllegalArgumentException("Cannot set input to this value");
                        }
                        string = bEASTInterface.getID();
                        string = string.substring(0, string.indexOf(46));
                        for (int i = 0; i < this.m_selectBEASTObjectBox.getItemCount(); ++i) {
                            BeautiSubTemplate beautiSubTemplate2 = (BeautiSubTemplate)this.m_selectBEASTObjectBox.getItemAt(i);
                            if (!beautiSubTemplate2.getMainID().replaceAll(".\\$\\(n\\)", "").equals(string) && !beautiSubTemplate2.getMainID().replaceAll(".s:\\$\\(n\\)", "").equals(string) && !beautiSubTemplate2.getMainID().replaceAll(".c:\\$\\(n\\)", "").equals(string) && !beautiSubTemplate2.getMainID().replaceAll(".t:\\$\\(n\\)", "").equals(string)) continue;
                            this.m_selectBEASTObjectBox.setSelectedItem(beautiSubTemplate2);
                        }
                    }
                    this.setValue(bEASTInterface);
                    if (this.m_expansionBox != null) {
                        int n = 1;
                        while (n < this.m_expansionBox.getComponentCount()) {
                            this.m_expansionBox.remove(n);
                        }
                        if (bEASTInterface != null) {
                            this.doc.getInputEditorFactory().addInputs(this.m_expansionBox, bEASTInterface, this._this, this._this, this.doc);
                        }
                    } else {
                        if (this.m_bAddButtons && this.m_editBEASTObjectButton != null) {
                            this.m_editBEASTObjectButton.setEnabled(true);
                        }
                        this.validateInput();
                    }
                    this.sync();
                    this.refreshPanel();
                }
                catch (Exception exception) {
                    string = ((BEASTInterface)this.m_input.get()).getID();
                    this.m_selectBEASTObjectBox.setSelectedItem(string);
                    exception.printStackTrace();
                    JOptionPane.showMessageDialog(null, "Could not change beastObject: " + exception.getClass().getName() + " " + exception.getMessage());
                }
            });
            this.m_selectBEASTObjectBox.setToolTipText(input.getHTMLTipText());
            int n = this.m_selectBEASTObjectBox.getFont().getSize();
            this.m_selectBEASTObjectBox.setMaximumSize(new Dimension(1024, 200 * n / 13));
            jComponent.add(this.m_selectBEASTObjectBox);
        }
    }

    String[] getAvailablePlugins() {
        List<String> list = AddOnManager.find(this.m_input.getType(), "beast");
        return list.toArray(new String[0]);
    }
}

