/*
 * Decompiled with CFR 0.152.
 */
package beast.app.beauti;

import beast.app.beauti.BeautiConnector;
import beast.app.beauti.BeautiDoc;
import beast.app.beauti.PartitionContext;
import beast.core.BEASTInterface;
import beast.core.BEASTObject;
import beast.core.Description;
import beast.core.Input;
import beast.core.Logger;
import beast.core.util.Log;
import beast.evolution.alignment.Alignment;
import beast.evolution.alignment.FilteredAlignment;
import beast.evolution.likelihood.GenericTreeLikelihood;
import beast.evolution.sitemodel.SiteModelInterface;
import beast.evolution.substitutionmodel.SubstitutionModel;
import beast.util.XMLParser;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

@Description(value="Template that specifies which sub-net needs to be created when a beastObject of a paricular class is created.")
public class BeautiSubTemplate
extends BEASTObject {
    public final Input<String> classInput = new Input("class", "name of the class (with full class path) to be created", Input.Validate.REQUIRED);
    public final Input<String> mainInput = new Input("mainid", "specifies id of the main beastObject to be created by the template", Input.Validate.REQUIRED);
    public final Input<String> xMLInput = new Input("value", "collection of objects to be created in Beast2 xml format", Input.Validate.REQUIRED);
    public final Input<List<BeautiConnector>> connectorsInput = new Input("connect", "Specifies which part of the template get connected to the main network", new ArrayList());
    public final Input<String> suppressedInputs = new Input("suppressInputs", "comma separated list of inputs that should not be shown");
    public final Input<String> inlineInput = new Input("inlineInputs", "comma separated list of inputs that should go inline, e.g. beast.evolution.sitemodel.SiteModel.substModel");
    public final Input<String> collapsedInput = new Input("collapsedInputs", "comma separated list of inputs that should go inline, but are initially collapsed, e.g. beast.core.MCMC.logger");
    Class<?> _class = null;
    Object instance;
    String xml = null;
    List<BeautiConnector> connectors;
    BeautiDoc doc;
    String mainID = "";
    String shortClassName;
    int subNetDepth = 0;

    @Override
    public void initAndValidate() {
        try {
            this._class = Class.forName(this.classInput.get());
            this.shortClassName = this.classInput.get().substring(this.classInput.get().lastIndexOf(46) + 1);
            this.instance = this._class.newInstance();
            this.xml = this.xMLInput.get();
            this.mainID = this.mainInput.get();
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            try {
                Document document = documentBuilderFactory.newDocumentBuilder().parse(new InputSource(new StringReader("<beast xmlns:beauti='http://beast2.org'>" + this.xml + "</beast>")));
                this.xml = this.processDoc(document);
            }
            catch (IOException | ParserConfigurationException | TransformerException | SAXException exception) {
                throw new IllegalArgumentException(exception.getMessage());
            }
            if (this.xml.contains("<!--")) {
                while (this.xml.contains("<!--")) {
                    int n = this.xml.indexOf("<!--");
                    int n2 = this.xml.indexOf("-->", n);
                    this.xml = this.xml.substring(0, n) + this.xml.substring(n2 + 3);
                }
            }
            this.xMLInput.setValue("<![CDATA[" + this.xml + "]]>", this);
            this.connectors = this.connectorsInput.get();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException reflectiveOperationException) {
            throw new IllegalArgumentException(reflectiveOperationException.getMessage());
        }
    }

    private String processDoc(Document document) throws TransformerException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        NodeList nodeList = document.getElementsByTagName("*");
        if (nodeList == null || nodeList.getLength() == 0) {
            throw new IllegalArgumentException("Expected top level beast element in XML");
        }
        Node node = nodeList.item(0);
        NodeList nodeList2 = node.getChildNodes();
        for (int i = 0; i < nodeList2.getLength(); ++i) {
            object4 = nodeList2.item(i);
            if (object4.getNodeType() != 1 || object4.getAttributes().getNamedItem("idref") == null) continue;
            object3 = XMLParser.getAttribute((Node)object4, "idref");
            node.removeChild((Node)object4);
            --i;
            object2 = object4.getChildNodes();
            for (int j = 0; j < object2.getLength(); ++j) {
                object = object2.item(j);
                if (object.getNodeType() == 1) {
                    Object object5;
                    Object object6;
                    String string = object.getNodeName();
                    String string2 = XMLParser.getAttribute((Node)object, "name");
                    if (string2 != null) {
                        string = string2;
                    }
                    if (string.equals("if")) {
                        String string3 = XMLParser.getAttribute((Node)object, "cond");
                        object6 = object.getChildNodes();
                        for (int k = 0; k < object6.getLength(); ++k) {
                            object5 = object6.item(k);
                            if (object5.getNodeType() == 1) {
                                boolean bl = true;
                                String string4 = XMLParser.getAttribute((Node)object5, "idref");
                                if (string4 == null) {
                                    string4 = XMLParser.getAttribute((Node)object5, "id");
                                    bl = false;
                                }
                                if (string4 == null) {
                                    throw new RuntimeException("idref and id not specified on element with name '" + string2 + "'");
                                }
                                string = object5.getNodeName();
                                String string5 = XMLParser.getAttribute((Node)object5, "name");
                                if (string5 != null) {
                                    string = string5;
                                }
                                BeautiConnector beautiConnector = new BeautiConnector(string4, (String)object3, string, string3);
                                this.connectorsInput.get().add(beautiConnector);
                                if (bl) continue;
                                node.appendChild((Node)object5);
                                --k;
                                continue;
                            }
                            node.appendChild((Node)object5);
                            --k;
                        }
                        continue;
                    }
                    boolean bl = true;
                    object6 = XMLParser.getAttribute((Node)object, "idref");
                    if (object6 == null) {
                        object6 = XMLParser.getAttribute((Node)object, "id");
                        bl = false;
                    }
                    if (object6 == null) {
                        throw new RuntimeException("idref and id not specified on element with name '" + string2 + "'");
                    }
                    String string6 = XMLParser.getAttribute((Node)object, "beauti:if");
                    if (string6 != null) {
                        object.getAttributes().removeNamedItem("beauti:if");
                    }
                    object5 = new BeautiConnector((String)object6, (String)object3, string, string6);
                    this.connectorsInput.get().add((BeautiConnector)object5);
                    if (bl) continue;
                    node.appendChild((Node)object);
                    --j;
                    continue;
                }
                node.appendChild(object2.item(j));
                --j;
            }
        }
        DOMSource dOMSource = new DOMSource(document);
        object4 = new StringWriter();
        object3 = new StreamResult((Writer)object4);
        object2 = TransformerFactory.newInstance();
        Transformer transformer = ((TransformerFactory)object2).newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.transform(dOMSource, (Result)object3);
        object = ((StringWriter)object4).toString();
        object = ((String)object).substring(((String)object).indexOf("<beast xmlns:beauti=\"http://beast2.org\">") + 40, ((String)object).lastIndexOf("</beast>"));
        return object;
    }

    public void setDoc(BeautiDoc beautiDoc) {
        this.doc = beautiDoc;
    }

    public void removeSubNet(BeautiSubTemplate beautiSubTemplate, PartitionContext partitionContext) {
        for (BeautiConnector beautiConnector : beautiSubTemplate.connectors) {
            this.doc.disconnect(beautiConnector, partitionContext);
        }
    }

    void removeSubNet(Object object) {
        if (object == null) {
            return;
        }
        BEASTInterface bEASTInterface = null;
        if (object instanceof BEASTInterface) {
            bEASTInterface = (BEASTInterface)object;
        }
        String string = bEASTInterface.getID();
        string = string.substring(0, string.indexOf("."));
        BeautiSubTemplate beautiSubTemplate = null;
        for (BeautiSubTemplate beautiSubTemplate2 : this.doc.beautiConfig.subTemplatesInput.get()) {
            if (!beautiSubTemplate2.matchesName(string)) continue;
            beautiSubTemplate = beautiSubTemplate2;
            break;
        }
        if (beautiSubTemplate == null) {
            throw new RuntimeException("Cannot find template for removing " + bEASTInterface.getID());
        }
        PartitionContext partitionContext = this.doc.getContextFor(bEASTInterface);
        this.removeSubNet(beautiSubTemplate, partitionContext);
    }

    public BEASTInterface createSubNet(PartitionContext partitionContext, BEASTInterface bEASTInterface, Input<?> input, boolean bl) {
        this.removeSubNet(input.get());
        if (this.xml == null) {
            input.setValue(null, bEASTInterface);
            return null;
        }
        BEASTInterface bEASTInterface2 = this.createSubNet(partitionContext, this.doc.pluginmap, bl);
        input.setValue(bEASTInterface2, bEASTInterface);
        return bEASTInterface2;
    }

    public BEASTInterface createSubNet(PartitionContext partitionContext, List<BEASTInterface> list, int n, boolean bl) {
        this.removeSubNet(list.get(n));
        if (this.xml == null) {
            list.set(n, null);
            return null;
        }
        BEASTInterface bEASTInterface = this.createSubNet(partitionContext, this.doc.pluginmap, bl);
        list.set(n, bEASTInterface);
        return bEASTInterface;
    }

    public BEASTInterface createSubNet(PartitionContext partitionContext, boolean bl) {
        if (this.xml == null) {
            return null;
        }
        BEASTInterface bEASTInterface = this.createSubNet(partitionContext, this.doc.pluginmap, bl);
        return bEASTInterface;
    }

    BEASTInterface createSubNet(Alignment alignment, BeautiDoc beautiDoc, boolean bl) {
        String string = alignment.getID();
        HashMap<String, BEASTInterface> hashMap = beautiDoc.pluginmap;
        hashMap.put(string, alignment);
        return this.createSubNet(new PartitionContext(string), hashMap, bl);
    }

    private BEASTInterface createSubNet(PartitionContext partitionContext, HashMap<String, BEASTInterface> hashMap, boolean bl) {
        String[] stringArray;
        ++this.subNetDepth;
        if (this.subNetDepth > 10) {
            throw new IllegalArgumentException("Potential programmer error: It looks like there is a required input that was not specified in the tenmplate");
        }
        String string = "<beast version='2.0' \nnamespace='beast.app.beauti:beast.core:beast.evolution.branchratemodel:beast.evolution.speciation:beast.evolution.tree.coalescent:beast.core.util:beast.evolution.nuc:beast.evolution.operators:beast.evolution.sitemodel:beast.evolution.substitutionmodel:beast.evolution.likelihood:beast.evolution:beast.math.distributions'>\n" + this.xml + "</beast>\n";
        string = string.replaceAll("idref=[\"']data['\"]", "idref='" + partitionContext.partition + "'");
        string = string.replaceAll("[\"']@data['\"]", "'@" + partitionContext.partition + "'");
        string = BeautiDoc.translatePartitionNames(string, partitionContext);
        XMLParser xMLParser = new XMLParser();
        xMLParser.setRequiredInputProvider(this.doc, partitionContext);
        List<BEASTInterface> list = null;
        try {
            list = xMLParser.parseTemplate(string, hashMap, true);
            for (BEASTInterface stringArray22 : list) {
                this.doc.addPlugin(stringArray22);
                try {
                    Log.warning.println("Adding " + stringArray22.getClass().getName() + " " + stringArray22);
                }
                catch (Exception exception) {
                    Log.err.println("Adding " + stringArray22.getClass().getName());
                }
            }
            stringArray = this.connectors.iterator();
            while (stringArray.hasNext()) {
                BeautiConnector beautiConnector = (BeautiConnector)stringArray.next();
                if (bl && beautiConnector.atInitialisationOnly()) {
                    this.doc.connect(beautiConnector, partitionContext);
                }
                if (beautiConnector.targetID != null && beautiConnector.targetID.equals("prior")) {
                    Log.warning.println(">>> No description for connector " + beautiConnector.sourceID + " == " + beautiConnector.targetID);
                }
                if (beautiConnector.getTipText() == null) continue;
                String string2 = BeautiDoc.translatePartitionNames(beautiConnector.sourceID, partitionContext);
                String string3 = BeautiDoc.translatePartitionNames(beautiConnector.getTipText(), partitionContext).trim().replaceAll("\\s+", " ");
                this.doc.tipTextMap.put(string2, string3);
            }
            if (this.suppressedInputs.get() != null) {
                for (String string4 : stringArray = this.suppressedInputs.get().split(",")) {
                    String string5 = string4.trim();
                    this.doc.beautiConfig.suppressBEASTObjects.add(string5);
                }
            }
            if (this.inlineInput.get() != null) {
                for (String string6 : stringArray = this.inlineInput.get().split(",")) {
                    String string7 = string6.trim();
                    this.doc.beautiConfig.inlineBEASTObject.add(string7);
                }
            }
            if (this.collapsedInput.get() != null) {
                for (String string8 : stringArray = this.collapsedInput.get().split(",")) {
                    String string9 = string8.trim();
                    this.doc.beautiConfig.collapsedBEASTObjects.add(string9);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (this.mainID.equals("[top]")) {
            return list.get(0);
        }
        stringArray = this.mainID;
        stringArray = BeautiDoc.translatePartitionNames((String)stringArray, partitionContext);
        BEASTInterface bEASTInterface = this.doc.pluginmap.get(stringArray);
        if (this == this.doc.beautiConfig.partitionTemplate.get()) {
            String string10;
            Logger logger;
            BEASTInterface bEASTInterface2 = this.doc.pluginmap.get("treeLikelihood." + partitionContext.partition);
            if (bEASTInterface2 != null && ((GenericTreeLikelihood)bEASTInterface2).siteModelInput.get() instanceof SiteModelInterface.Base) {
                SiteModelInterface.Base base = (SiteModelInterface.Base)((GenericTreeLikelihood)bEASTInterface2).siteModelInput.get();
                SubstitutionModel substitutionModel = base.substModelInput.get();
                try {
                    base.canSetSubstModel(substitutionModel);
                }
                catch (Exception exception) {
                    Object object = this.doc.createInput(base, base.substModelInput, partitionContext);
                    try {
                        base.substModelInput.setValue(object, base);
                    }
                    catch (Exception exception2) {
                        exception2.printStackTrace();
                    }
                }
            }
            if ((logger = (Logger)this.doc.pluginmap.get("tracelog")) != null && (string10 = logger.fileNameInput.get()).startsWith("beast.") && bEASTInterface2 != null) {
                Alignment alignment = ((GenericTreeLikelihood)bEASTInterface2).dataInput.get();
                while (alignment instanceof FilteredAlignment) {
                    alignment = ((FilteredAlignment)alignment).alignmentInput.get();
                }
                String string11 = alignment.getID() + string10.substring(5);
                try {
                    logger.fileNameInput.setValue(string11, logger);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        --this.subNetDepth;
        return bEASTInterface;
    }

    public String getMainID() {
        return this.mainID;
    }

    @Override
    public String toString() {
        String string = this.getID();
        string = string.replaceAll("([a-z])([A-Z])", "$1 $2");
        return string;
    }

    public boolean matchesName(String string) {
        if (this.getMainID().replaceAll(".\\$\\(n\\)", "").equals(string)) {
            return true;
        }
        if (this.getMainID().replaceAll("..:\\$\\(n\\)", "").equals(string)) {
            return true;
        }
        return this.shortClassName != null && this.shortClassName.equals(string);
    }
}

