/*
 * Decompiled with CFR 0.152.
 */
package beagle;

public enum BeagleFlag {
    PRECISION_SINGLE(1L, "double precision computation"),
    PRECISION_DOUBLE(2L, "single precision computation"),
    COMPUTATION_SYNCH(4L, "synchronous computation (blocking"),
    COMPUTATION_ASYNCH(8L, "asynchronous computation (non-blocking)"),
    EIGEN_REAL(16L, "real eigenvalue computation"),
    EIGEN_COMPLEX(32L, "complex eigenvalue computation"),
    SCALING_MANUAL(64L, "manual scaling"),
    SCALING_AUTO(128L, "auto-scaling on"),
    SCALING_ALWAYS(256L, "scale at every update"),
    SCALING_DYNAMIC(524288L, "manual scaling with dynamic checking"),
    SCALERS_RAW(512L, "save raw scalers"),
    SCALERS_LOG(1024L, "save log scalers"),
    VECTOR_SSE(2048L, "SSE vector computation"),
    VECTOR_NONE(4096L, "no vector computation"),
    THREADING_OPENMP(8192L, "OpenMP threading"),
    THREADING_NONE(16384L, "no threading"),
    PROCESSOR_CPU(32768L, "use CPU as main processor"),
    PROCESSOR_GPU(65536L, "use GPU as main processor"),
    PROCESSOR_FPGA(131072L, "use FPGA as main processor"),
    PROCESSOR_CELL(262144L, "use CELL as main processor"),
    FRAMEWORK_CUDA(0x400000L, "use CUDA implementation with GPU resources"),
    FRAMEWORK_OPENCL(0x800000L, "use OpenCL implementation with CPU or GPU resources"),
    FRAMEWORK_CPU(0x8000000L, "use CPU implementation");

    private final long mask;
    private final String meaning;

    private BeagleFlag(long l, String string2) {
        this.mask = l;
        this.meaning = string2;
    }

    public long getMask() {
        return this.mask;
    }

    public String getMeaning() {
        return this.meaning;
    }

    public boolean isSet(long l) {
        return (l & this.mask) != 0L;
    }

    public static String toString(long l) {
        StringBuilder stringBuilder = new StringBuilder();
        for (BeagleFlag beagleFlag : BeagleFlag.values()) {
            if (!beagleFlag.isSet(l)) continue;
            stringBuilder.append(" ").append(beagleFlag.name());
        }
        return stringBuilder.toString();
    }
}

