/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.servlet;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.invoke.MethodHandles;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import net.jcip.annotations.ThreadSafe;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.common.cloud.ClusterPropertiesListener;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.core.RateLimiterConfig;
import org.apache.solr.servlet.QueryRateLimiter;
import org.apache.solr.servlet.RequestRateLimiter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class RateLimitManager
implements ClusterPropertiesListener {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String ERROR_MESSAGE = "Too many requests for this request type. Please try after some time or increase the quota for this request type";
    public static final int DEFAULT_CONCURRENT_REQUESTS = Runtime.getRuntime().availableProcessors() * 3;
    public static final long DEFAULT_SLOT_ACQUISITION_TIMEOUT_MS = -1L;
    private final ConcurrentHashMap<String, RequestRateLimiter> requestRateLimiterMap = new ConcurrentHashMap();

    public boolean onChange(Map<String, Object> properties) {
        this.requestRateLimiterMap.compute(SolrRequest.SolrRequestType.QUERY.toString(), (k, v) -> {
            try {
                RateLimiterConfig newConfig = QueryRateLimiter.processConfigChange(SolrRequest.SolrRequestType.QUERY, v == null ? null : v.getRateLimiterConfig(), properties);
                if (newConfig == null) {
                    return v;
                }
                return new QueryRateLimiter(newConfig);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
        return false;
    }

    public RequestRateLimiter.SlotReservation handleRequest(HttpServletRequest request) throws InterruptedException {
        String requestContext = request.getHeader("Solr-Request-Context");
        String typeOfRequest = request.getHeader("Solr-Request-Type");
        if (typeOfRequest == null) {
            return RequestRateLimiter.UNLIMITED;
        }
        if (requestContext != null && requestContext.equals(SolrRequest.SolrClientContext.SERVER.toString())) {
            return RequestRateLimiter.UNLIMITED;
        }
        RequestRateLimiter requestRateLimiter = this.requestRateLimiterMap.get(typeOfRequest);
        if (requestRateLimiter == null) {
            return RequestRateLimiter.UNLIMITED;
        }
        RequestRateLimiter.SlotReservation result = requestRateLimiter.handleRequest();
        if (result != null) {
            return result;
        }
        return this.trySlotBorrowing(typeOfRequest);
    }

    private RequestRateLimiter.SlotReservation trySlotBorrowing(String requestType) {
        for (Map.Entry<String, RequestRateLimiter> currentEntry : this.requestRateLimiterMap.entrySet()) {
            RequestRateLimiter.SlotReservation result = null;
            RequestRateLimiter requestRateLimiter = currentEntry.getValue();
            if (requestRateLimiter.getRateLimiterConfig().requestType.toString().equals(requestType) || !requestRateLimiter.getRateLimiterConfig().isSlotBorrowingEnabled) continue;
            if (log.isWarnEnabled()) {
                String msg = "WARN: Experimental feature slots borrowing is enabled for request rate limiter type " + requestRateLimiter.getRateLimiterConfig().requestType.toString();
                log.warn(msg);
            }
            try {
                result = requestRateLimiter.allowSlotBorrowing();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public void registerRequestRateLimiter(RequestRateLimiter requestRateLimiter, SolrRequest.SolrRequestType requestType) {
        this.requestRateLimiterMap.put(requestType.toString(), requestRateLimiter);
    }

    public RequestRateLimiter getRequestRateLimiter(SolrRequest.SolrRequestType requestType) {
        return this.requestRateLimiterMap.get(requestType.toString());
    }

    public static class Builder {
        protected SolrZkClient solrZkClient;

        public Builder(SolrZkClient solrZkClient) {
            this.solrZkClient = solrZkClient;
        }

        public RateLimitManager build() {
            RateLimitManager rateLimitManager = new RateLimitManager();
            rateLimitManager.registerRequestRateLimiter(new QueryRateLimiter(this.solrZkClient), SolrRequest.SolrRequestType.QUERY);
            return rateLimitManager;
        }
    }
}

