/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge.svg12;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.batik.bridge.svg12.AbstractContentSelector;
import org.apache.batik.bridge.svg12.ContentManager;
import org.apache.batik.dom.svg12.XBLOMContentElement;
import org.apache.batik.parser.AbstractScanner;
import org.apache.batik.parser.ParseException;
import org.apache.batik.xml.XMLUtilities;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XPathSubsetContentSelector
extends AbstractContentSelector {
    protected static final int SELECTOR_INVALID = -1;
    protected static final int SELECTOR_ANY = 0;
    protected static final int SELECTOR_QNAME = 1;
    protected static final int SELECTOR_ID = 2;
    protected int selectorType;
    protected String prefix;
    protected String localName;
    protected int index;
    protected SelectedNodes selectedContent;

    public XPathSubsetContentSelector(ContentManager contentManager, XBLOMContentElement xBLOMContentElement, Element element, String string) {
        super(contentManager, xBLOMContentElement, element);
        this.parseSelector(string);
    }

    protected void parseSelector(String string) {
        this.selectorType = -1;
        Scanner scanner = new Scanner(string);
        int n = scanner.next();
        if (n == 1) {
            String string2 = scanner.getStringValue();
            n = scanner.next();
            if (n == 0) {
                this.selectorType = 1;
                this.prefix = null;
                this.localName = string2;
                this.index = 0;
                return;
            }
            if (n == 2) {
                n = scanner.next();
                if (n == 1) {
                    String string3 = scanner.getStringValue();
                    n = scanner.next();
                    if (n == 0) {
                        this.selectorType = 1;
                        this.prefix = string2;
                        this.localName = string3;
                        this.index = 0;
                        return;
                    }
                    if (n == 3 && (n = scanner.next()) == 8) {
                        int n2 = Integer.parseInt(scanner.getStringValue());
                        n = scanner.next();
                        if (n == 4 && (n = scanner.next()) == 0) {
                            this.selectorType = 1;
                            this.prefix = string2;
                            this.localName = string3;
                            this.index = n2;
                            return;
                        }
                    }
                } else if (n == 3) {
                    n = scanner.next();
                    if (n == 8) {
                        int n3 = Integer.parseInt(scanner.getStringValue());
                        n = scanner.next();
                        if (n == 4 && (n = scanner.next()) == 0) {
                            this.selectorType = 1;
                            this.prefix = null;
                            this.localName = string2;
                            this.index = n3;
                            return;
                        }
                    }
                } else if (n == 5 && string2.equals("id") && (n = scanner.next()) == 7) {
                    String string4 = scanner.getStringValue();
                    n = scanner.next();
                    if (n == 6 && (n = scanner.next()) == 0) {
                        this.selectorType = 2;
                        this.localName = string4;
                        return;
                    }
                }
            }
        } else if (n == 9) {
            n = scanner.next();
            if (n == 0) {
                this.selectorType = 0;
                return;
            }
            if (n == 3 && (n = scanner.next()) == 8) {
                int n4 = Integer.parseInt(scanner.getStringValue());
                n = scanner.next();
                if (n == 4 && (n = scanner.next()) == 0) {
                    this.selectorType = 0;
                    this.index = n4;
                    return;
                }
            }
        }
    }

    public NodeList getSelectedContent() {
        if (this.selectedContent == null) {
            this.selectedContent = new SelectedNodes();
        }
        return this.selectedContent;
    }

    boolean update() {
        if (this.selectedContent == null) {
            this.selectedContent = new SelectedNodes();
            return true;
        }
        return this.selectedContent.update();
    }

    protected static class Scanner
    extends AbstractScanner {
        public static final int EOF = 0;
        public static final int NAME = 1;
        public static final int COLON = 2;
        public static final int LEFT_SQUARE_BRACKET = 3;
        public static final int RIGHT_SQUARE_BRACKET = 4;
        public static final int LEFT_PARENTHESIS = 5;
        public static final int RIGHT_PARENTHESIS = 6;
        public static final int STRING = 7;
        public static final int NUMBER = 8;
        public static final int ASTERISK = 9;

        public Scanner(String string) {
            super(string);
        }

        protected int endGap() {
            return this.current == -1 ? 0 : 1;
        }

        protected void nextToken() throws ParseException {
            try {
                switch (this.current) {
                    case -1: {
                        this.type = 0;
                        return;
                    }
                    case 58: {
                        this.nextChar();
                        this.type = 2;
                        return;
                    }
                    case 91: {
                        this.nextChar();
                        this.type = 3;
                        return;
                    }
                    case 93: {
                        this.nextChar();
                        this.type = 4;
                        return;
                    }
                    case 40: {
                        this.nextChar();
                        this.type = 5;
                        return;
                    }
                    case 41: {
                        this.nextChar();
                        this.type = 6;
                        return;
                    }
                    case 42: {
                        this.nextChar();
                        this.type = 9;
                        return;
                    }
                    case 9: 
                    case 10: 
                    case 12: 
                    case 13: 
                    case 32: {
                        do {
                            this.nextChar();
                        } while (XMLUtilities.isXMLSpace((char)this.current));
                        this.nextToken();
                        return;
                    }
                    case 39: {
                        this.type = this.string1();
                        return;
                    }
                    case 34: {
                        this.type = this.string2();
                        return;
                    }
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: 
                    case 56: 
                    case 57: {
                        this.type = this.number();
                        return;
                    }
                }
                if (XMLUtilities.isXMLNameFirstCharacter((char)this.current)) {
                    do {
                        this.nextChar();
                    } while (this.current != -1 && this.current != 58 && XMLUtilities.isXMLNameCharacter((char)this.current));
                    this.type = 1;
                    return;
                }
                this.nextChar();
                throw new ParseException("identifier.character", this.reader.getLine(), this.reader.getColumn());
            }
            catch (IOException iOException) {
                throw new ParseException(iOException);
            }
        }

        protected int string1() throws IOException {
            this.start = this.position;
            block4: while (true) {
                switch (this.nextChar()) {
                    case -1: {
                        throw new ParseException("eof", this.reader.getLine(), this.reader.getColumn());
                    }
                    case 39: {
                        break block4;
                    }
                    default: {
                        continue block4;
                    }
                }
                break;
            }
            this.nextChar();
            return 7;
        }

        protected int string2() throws IOException {
            this.start = this.position;
            block4: while (true) {
                switch (this.nextChar()) {
                    case -1: {
                        throw new ParseException("eof", this.reader.getLine(), this.reader.getColumn());
                    }
                    case 34: {
                        break block4;
                    }
                    default: {
                        continue block4;
                    }
                }
                break;
            }
            this.nextChar();
            return 7;
        }

        protected int number() throws IOException {
            block7: while (true) {
                switch (this.nextChar()) {
                    case 46: {
                        switch (this.nextChar()) {
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: {
                                return this.dotNumber();
                            }
                        }
                        throw new ParseException("character", this.reader.getLine(), this.reader.getColumn());
                    }
                    default: {
                        break block7;
                    }
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: 
                    case 56: 
                    case 57: {
                        continue block7;
                    }
                }
                break;
            }
            return 8;
        }

        protected int dotNumber() throws IOException {
            block3: while (true) {
                switch (this.nextChar()) {
                    default: {
                        break block3;
                    }
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: 
                    case 56: 
                    case 57: {
                        continue block3;
                    }
                }
                break;
            }
            return 8;
        }
    }

    protected class SelectedNodes
    implements NodeList {
        protected ArrayList nodes = new ArrayList(10);

        public SelectedNodes() {
            this.update();
        }

        protected boolean update() {
            ArrayList arrayList = (ArrayList)this.nodes.clone();
            this.nodes.clear();
            int n = 0;
            for (Node node = XPathSubsetContentSelector.this.boundElement.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (node.getNodeType() != 1) continue;
                Element element = (Element)node;
                boolean bl = XPathSubsetContentSelector.this.selectorType == 0;
                switch (XPathSubsetContentSelector.this.selectorType) {
                    case 2: {
                        bl = element.getAttributeNS(null, "id").equals(XPathSubsetContentSelector.this.localName);
                        break;
                    }
                    case 1: {
                        if (XPathSubsetContentSelector.this.prefix == null) {
                            bl = element.getNamespaceURI() == null;
                        } else {
                            String string = XPathSubsetContentSelector.this.contentElement.lookupNamespaceURI(XPathSubsetContentSelector.this.prefix);
                            if (string != null) {
                                bl = element.getNamespaceURI().equals(string);
                            }
                        }
                        boolean bl2 = bl = bl && XPathSubsetContentSelector.this.localName.equals(element.getLocalName());
                    }
                }
                if (XPathSubsetContentSelector.this.selectorType == 0 || XPathSubsetContentSelector.this.selectorType == 1) {
                    boolean bl3 = bl = bl && (XPathSubsetContentSelector.this.index == 0 || ++n == XPathSubsetContentSelector.this.index);
                }
                if (!bl || XPathSubsetContentSelector.this.isSelected(node)) continue;
                this.nodes.add(element);
            }
            int n2 = this.nodes.size();
            if (arrayList.size() != n2) {
                return true;
            }
            for (int i = 0; i < n2; ++i) {
                if (arrayList.get(i) == this.nodes.get(i)) continue;
                return true;
            }
            return false;
        }

        public Node item(int n) {
            if (n < 0 || n >= this.nodes.size()) {
                return null;
            }
            return (Node)this.nodes.get(n);
        }

        public int getLength() {
            return this.nodes.size();
        }
    }
}

