// This file is part of libigl, a simple c++ geometry processing library.
// 
// Copyright (C) 2018 Alec Jacobson <alecjacobson@gmail.com>
// 
// This Source Code Form is subject to the terms of the Mozilla Public License 
// v. 2.0. If a copy of the MPL was not distributed with this file, You can 
// obtain one at http://mozilla.org/MPL/2.0/.

#include "tan_half_angle.h"
#include <cmath>
template < typename Scalar>
IGL_INLINE Scalar igl::tan_half_angle(
  const Scalar & a,
  const Scalar & b,
  const Scalar & c)
{
  //      .
  //     /|
  //   c/ |
  //   /  |
  //  /   |
  // .α   | a
  //  \   |
  //   \  |
  //   b\ |  
  //     \| 
  //
  // tan(α/2)
  // Fisher 2007
  return sqrt(((a-b+c)*(a+b-c))/((a+b+c)*(-a+b+c)));
}

#ifdef IGL_STATIC_LIBRARY
// Explicit template instantiation
// generated by autoexplicit.sh
template double igl::tan_half_angle<double>(double const&, double const&, double const&);
#endif
