/*
 * Decompiled with CFR 0.152.
 */
package mediathek.x11;

import java.awt.Toolkit;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import mediathek.config.MVConfig;
import mediathek.mainwindow.MediathekGui;
import org.apache.commons.lang3.SystemUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MediathekGuiX11
extends MediathekGui {
    private static final Logger logger = LogManager.getLogger(MediathekGuiX11.class);

    public MediathekGuiX11() {
        this.setupX11WindowManagerClassName();
    }

    private void disableAccessWarnings() {
        try {
            Class<?> unsafeClass = Class.forName("sun.misc.Unsafe");
            Field field = unsafeClass.getDeclaredField("theUnsafe");
            field.setAccessible(true);
            Object unsafe = field.get(null);
            Method putObjectVolatile = unsafeClass.getDeclaredMethod("putObjectVolatile", Object.class, Long.TYPE, Object.class);
            Method staticFieldOffset = unsafeClass.getDeclaredMethod("staticFieldOffset", Field.class);
            Class<?> loggerClass = Class.forName("jdk.internal.module.IllegalAccessLogger");
            Field loggerField = loggerClass.getDeclaredField("logger");
            Long offset = (Long)staticFieldOffset.invoke(unsafe, loggerField);
            putObjectVolatile.invoke(unsafe, loggerClass, offset, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void setupX11WindowManagerClassName() {
        this.disableAccessWarnings();
        try {
            Toolkit xToolkit = Toolkit.getDefaultToolkit();
            Field awtAppClassNameField = xToolkit.getClass().getDeclaredField("awtAppClassName");
            awtAppClassNameField.setAccessible(true);
            awtAppClassNameField.set(xToolkit, "MediathekView");
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            logger.warn("Could not set awtAppClassName");
        }
    }

    @Override
    protected void shutdownComputer() {
        String strShutdownCommand;
        if (SystemUtils.IS_OS_LINUX || SystemUtils.IS_OS_FREE_BSD) {
            strShutdownCommand = MVConfig.get(MVConfig.Configs.SYSTEM_LINUX_SHUTDOWN);
            if (strShutdownCommand.isEmpty()) {
                strShutdownCommand = "shutdown -h now";
                MVConfig.add(MVConfig.Configs.SYSTEM_LINUX_SHUTDOWN, "shutdown -h now");
            }
        } else {
            logger.error("shutdown command is unknown for this operating system");
            return;
        }
        try {
            logger.info("Shutdown: {}", (Object)strShutdownCommand);
            Runtime.getRuntime().exec(strShutdownCommand);
        }
        catch (IOException ex) {
            logger.error(ex);
        }
    }
}

