/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.tab_film;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import jiconfont.icons.FontAwesome;
import jiconfont.swing.IconFontSwing;
import mediathek.config.Daten;
import mediathek.config.MVConfig;
import mediathek.daten.DatenPset;
import mediathek.daten.ListePset;
import mediathek.gui.GuiFilme;
import mediathek.gui.messages.PsetNumberOfButtonsChangedEvent;
import mediathek.gui.tab_film.BeobOpenPlayer;
import mediathek.gui.tab_film.IButtonPanelController;
import mediathek.tool.Listener;
import net.miginfocom.layout.AC;
import net.miginfocom.layout.CC;
import net.miginfocom.layout.LC;
import net.miginfocom.swing.MigLayout;
import org.jetbrains.annotations.NotNull;

public final class SwingButtonPanelController
implements IButtonPanelController {
    private final GuiFilme guiFilme;
    private final JPanel contentPanel = new JPanel();
    private final JPanel buttonsPanel = new JPanel();
    private final GridBagLayout gridbag = new GridBagLayout();
    private final Insets DEFAULT_INSETS = new Insets(4, 10, 4, 10);
    private final GridBagConstraints c = new GridBagConstraints();
    private ListePset listeButton;

    public SwingButtonPanelController(@NotNull GuiFilme guiFilme, @NotNull JPanel jPanel2) {
        this.guiFilme = guiFilme;
        this.createContentPanel(jPanel2);
        this.createCloseButton();
        this.createButtonsPanel();
        this.buttonsPanel.addMouseListener(new BeobMausButton());
    }

    private void createContentPanel(JPanel jPanel2) {
        this.contentPanel.setBorder(new LineBorder(new Color(153, 153, 153)));
        this.contentPanel.setLayout(new MigLayout(new LC().insets("0").hideMode(3).gridGap("5", "5"), new AC().fill().gap().grow().fill(), new AC().grow().fill()));
        jPanel2.add((Component)this.contentPanel, new CC().cell(0, 1));
    }

    private void createButtonsPanel() {
        this.buttonsPanel.setLayout(this.gridbag);
        this.contentPanel.add((Component)this.buttonsPanel, new CC().cell(1, 0));
    }

    private void createCloseButton() {
        JButton btnClose = new JButton();
        btnClose.setToolTipText("Buttons ausblenden");
        btnClose.setFocusable(false);
        btnClose.setFocusPainted(false);
        btnClose.setRequestFocusEnabled(false);
        btnClose.setBorderPainted(false);
        btnClose.setIcon(IconFontSwing.buildIcon(FontAwesome.TIMES_CIRCLE_O, 16.0f));
        btnClose.addActionListener(e -> {
            MVConfig.add(MVConfig.Configs.SYSTEM_PANEL_VIDEOPLAYER_ANZEIGEN, Boolean.FALSE.toString());
            Listener.notify(2, GuiFilme.class.getSimpleName());
            this.guiFilme.getButtonPanelController().setVisible(false);
        });
        this.contentPanel.add((Component)btnClose, new CC().pad("5 5 3 3").cell(0, 0).alignX("left").alignY("top").grow(0.0f, 0.0f).width("20:20:20").height("20:20:20"));
    }

    private void initConstraints() {
        this.c.weightx = 0.0;
        this.c.fill = 2;
        this.c.insets = this.DEFAULT_INSETS;
    }

    private void addExtraFeld(int i, int spalte, int zeile) {
        this.c.gridx = spalte;
        this.c.gridy = zeile;
        DatenPset pset = (DatenPset)this.listeButton.get(i);
        String psetName = pset.arr[0];
        Color psetColor = pset.getFarbe();
        if (pset.isLable()) {
            JLabel label = new JLabel(psetName);
            if (psetColor != null) {
                label.setForeground(psetColor);
            }
            this.gridbag.setConstraints(label, this.c);
            this.buttonsPanel.add(label);
        } else {
            JButton button = new JButton(psetName);
            button.addActionListener(new BeobOpenPlayer(this.guiFilme, pset));
            if (psetColor != null) {
                button.setBackground(psetColor);
            }
            this.gridbag.setConstraints(button, this.c);
            this.buttonsPanel.add(button);
        }
    }

    @Override
    public void setupButtons() {
        this.buttonsPanel.removeAll();
        int maxSpalten = MVConfig.getInt(MVConfig.Configs.SYSTEM_TAB_FILME_ANZAHL_BUTTON);
        this.initConstraints();
        int spalte = 0;
        int zeile = 0;
        this.listeButton = Daten.listePset.getListeButton();
        for (int i = 0; i < this.listeButton.size(); ++i) {
            if (!((DatenPset)this.listeButton.get(i)).isFreeLine()) {
                this.addExtraFeld(i, spalte, zeile);
            }
            if (++spalte <= maxSpalten - 1) continue;
            spalte = 0;
            ++zeile;
        }
        this.c.weightx = 10.0;
        this.c.gridx = maxSpalten + 1;
        this.c.gridy = 0;
        JLabel label = new JLabel();
        this.gridbag.setConstraints(label, this.c);
        this.buttonsPanel.add(label);
        this.buttonsPanel.updateUI();
    }

    @Override
    public void setVisible(boolean visible) {
        this.contentPanel.setVisible(visible);
    }

    private static class BeobMausButton
    extends MouseAdapter {
        private final JSpinner jSpinner = new JSpinner(new SpinnerNumberModel(4, 2, 10, 1));
        private final EmptyBorder emptyBorder = new EmptyBorder(3, 5, 3, 5);

        public BeobMausButton() {
            int start = MVConfig.getInt(MVConfig.Configs.SYSTEM_TAB_FILME_ANZAHL_BUTTON);
            this.jSpinner.setValue(start);
            this.jSpinner.setToolTipText("Damit kann die Anzahl der Button ver\u00e4ndert werden");
        }

        @Override
        public void mousePressed(MouseEvent arg0) {
            if (arg0.isPopupTrigger()) {
                this.showMenu(arg0);
            }
        }

        @Override
        public void mouseReleased(MouseEvent arg0) {
            if (arg0.isPopupTrigger()) {
                this.showMenu(arg0);
            }
        }

        private void showMenu(MouseEvent evt) {
            JPopupMenu jPopupMenu = new JPopupMenu();
            this.jSpinner.addChangeListener(e -> {
                MVConfig.add(MVConfig.Configs.SYSTEM_TAB_FILME_ANZAHL_BUTTON, String.valueOf(((Number)this.jSpinner.getModel().getValue()).intValue()));
                Daten.getInstance().getMessageBus().publishAsync(new PsetNumberOfButtonsChangedEvent());
            });
            JPanel jPanelAnzahl = new JPanel();
            jPanelAnzahl.setLayout(new BorderLayout());
            jPanelAnzahl.setBorder(this.emptyBorder);
            jPanelAnzahl.add((Component)new JLabel("Anzahl Button je Zeile: "), "West");
            jPanelAnzahl.add((Component)this.jSpinner, "East");
            jPopupMenu.add(jPanelAnzahl);
            jPopupMenu.show(evt.getComponent(), evt.getX(), evt.getY());
        }
    }
}

