/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.dialogEinstellungen;

import java.awt.Toolkit;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import mediathek.config.Daten;
import mediathek.config.Icons;
import mediathek.config.MVConfig;
import mediathek.gui.PanelVorlage;
import mediathek.gui.dialog.DialogHilfe;
import mediathek.gui.messages.ParallelDownloadNumberChangedEvent;
import mediathek.tool.ApplicationConfiguration;
import net.engio.mbassy.listener.Handler;

public class PanelDownload
extends PanelVorlage {
    private JCheckBox cbkDownloadError;
    private JButton jButtonBeep;
    private JButton jButtonHilfeAnzahl;
    private JCheckBox jCheckBoxBeep;
    private JCheckBox jCheckBoxServer;
    private JSpinner jSpinnerAnzahlDownload;

    @Handler
    private void handleParallelDownloadNumberChange(ParallelDownloadNumberChangedEvent e) {
        SwingUtilities.invokeLater(() -> this.jSpinnerAnzahlDownload.setValue(Integer.parseInt(MVConfig.get(MVConfig.Configs.SYSTEM_MAX_DOWNLOAD))));
    }

    public PanelDownload(Daten d, JFrame parent) {
        super(d, parent);
        this.initComponents();
        this.daten = d;
        this.daten.getMessageBus().subscribe(this);
        this.jSpinnerAnzahlDownload.setModel(new SpinnerNumberModel(1, 1, 9, 1));
        this.jSpinnerAnzahlDownload.setValue(Integer.parseInt(MVConfig.get(MVConfig.Configs.SYSTEM_MAX_DOWNLOAD)));
        this.jSpinnerAnzahlDownload.addChangeListener(new BeobSpinnerDownload());
        this.jButtonHilfeAnzahl.setIcon(Icons.ICON_BUTTON_HELP);
        this.jButtonHilfeAnzahl.addActionListener(e -> new DialogHilfe(this.parentComponent, true, "\nHier kann angegeben werden, wie viele\nDownloads gleichzeitig gestartet werden k\u00f6nnen.\n\nEs gibt jedoch noch eine Begrenzung\ndie trotzdem nicht \u00fcberschritten wird:\n\n2 Downloads pro Server, das kann auch noch\nauf 1 Download pro Server\n(z.B. nur ein Download von \"www.zdf.de\")\nweiter begrenzt werden.").setVisible(true));
        this.cbkDownloadError.setSelected(Boolean.parseBoolean(MVConfig.get(MVConfig.Configs.SYSTEM_DOWNLOAD_ERRORMSG)));
        this.cbkDownloadError.addActionListener(e -> MVConfig.add(MVConfig.Configs.SYSTEM_DOWNLOAD_ERRORMSG, Boolean.toString(this.cbkDownloadError.isSelected())));
        this.jCheckBoxBeep.setSelected(ApplicationConfiguration.getConfiguration().getBoolean("download.sound.beep", false));
        this.jCheckBoxBeep.addActionListener(l -> ApplicationConfiguration.getConfiguration().setProperty("download.sound.beep", this.jCheckBoxBeep.isSelected()));
        this.jButtonBeep.addActionListener(ae -> Toolkit.getDefaultToolkit().beep());
        this.jCheckBoxServer.setSelected(Boolean.parseBoolean(MVConfig.get(MVConfig.Configs.SYSTEM_MAX_1_DOWNLOAD_PRO_SERVER)));
        this.jCheckBoxServer.addActionListener(ae -> MVConfig.add(MVConfig.Configs.SYSTEM_MAX_1_DOWNLOAD_PRO_SERVER, String.valueOf(this.jCheckBoxServer.isSelected())));
    }

    private void initComponents() {
        JPanel jPanel2 = new JPanel();
        JLabel jLabel3 = new JLabel();
        this.jSpinnerAnzahlDownload = new JSpinner();
        this.jButtonHilfeAnzahl = new JButton();
        this.jCheckBoxBeep = new JCheckBox();
        this.jButtonBeep = new JButton();
        this.jCheckBoxServer = new JCheckBox();
        this.cbkDownloadError = new JCheckBox();
        this.setMinimumSize(this.getPreferredSize());
        jPanel2.setBorder(BorderFactory.createTitledBorder(""));
        jLabel3.setText("gleichzeitige Downloads laden:");
        this.jSpinnerAnzahlDownload.setModel(new SpinnerNumberModel(1, 1, 9, 1));
        this.jButtonHilfeAnzahl.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/muster/button-help.png")));
        this.jButtonHilfeAnzahl.setToolTipText("Hilfe anzeigen");
        this.jCheckBoxBeep.setText("nach jedem Download einen \"Beep\" ausgeben");
        this.jButtonBeep.setText("Testen");
        this.jCheckBoxServer.setText("nur ein Download pro Downloadserver");
        this.cbkDownloadError.setText("Bei Downloadfehler, Fehlermeldung anzeigen");
        GroupLayout jPanel2Layout = new GroupLayout(jPanel2);
        jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGap(6, 6, 6).addComponent(this.jCheckBoxServer)).addComponent(this.cbkDownloadError).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jCheckBoxBeep).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButtonBeep)).addGroup(jPanel2Layout.createSequentialGroup().addComponent(jLabel3).addGap(51, 51, 51).addComponent(this.jSpinnerAnzahlDownload, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonHilfeAnzahl))).addGap(0, 131, Short.MAX_VALUE)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.cbkDownloadError).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jCheckBoxBeep).addComponent(this.jButtonBeep)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(jLabel3).addComponent(this.jSpinnerAnzahlDownload, -2, -1, -2).addComponent(this.jButtonHilfeAnzahl)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxServer).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(jPanel2, -1, -1, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(jPanel2, -2, -1, -2).addContainerGap(456, Short.MAX_VALUE)));
    }

    private class BeobSpinnerDownload
    implements ChangeListener {
        private BeobSpinnerDownload() {
        }

        @Override
        public void stateChanged(ChangeEvent arg0) {
            MVConfig.add(MVConfig.Configs.SYSTEM_MAX_DOWNLOAD, String.valueOf(((Number)PanelDownload.this.jSpinnerAnzahlDownload.getModel().getValue()).intValue()));
            PanelDownload.this.daten.getMessageBus().publishAsync(new ParallelDownloadNumberChangedEvent());
        }
    }
}

