/*
 * Decompiled with CFR 0.152.
 */
package jdk.jfr.consumer;

import java.io.IOException;
import java.util.List;
import jdk.jfr.EventType;
import jdk.jfr.ValueDescriptor;
import jdk.jfr.consumer.Parser;
import jdk.jfr.consumer.RecordedEvent;
import jdk.jfr.consumer.TimeConverter;
import jdk.jfr.internal.consumer.RecordingInput;

final class EventParser
extends Parser {
    private final Parser[] parsers;
    private final EventType eventType;
    private final TimeConverter timeConverter;
    private final boolean hasDuration;
    private final List<ValueDescriptor> valueDescriptors;

    EventParser(TimeConverter timeConverter, EventType eventType, Parser[] parserArray) {
        this.timeConverter = timeConverter;
        this.parsers = parserArray;
        this.eventType = eventType;
        this.hasDuration = eventType.getField("duration") != null;
        this.valueDescriptors = eventType.getFields();
    }

    @Override
    public Object parse(RecordingInput recordingInput) throws IOException {
        Object[] objectArray = new Object[this.parsers.length];
        for (int i = 0; i < this.parsers.length; ++i) {
            objectArray[i] = this.parsers[i].parse(recordingInput);
        }
        Long l = (Long)objectArray[0];
        long l2 = this.timeConverter.convertTimestamp(l);
        if (this.hasDuration) {
            long l3 = (Long)objectArray[1];
            long l4 = this.timeConverter.convertTimestamp(l + l3);
            return new RecordedEvent(this.eventType, this.valueDescriptors, objectArray, l2, l4, this.timeConverter);
        }
        return new RecordedEvent(this.eventType, this.valueDescriptors, objectArray, l2, l2, this.timeConverter);
    }
}

