/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.svggen.font.table;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.apache.batik.svggen.font.table.DirectoryEntry;
import org.apache.batik.svggen.font.table.Table;

public class HmtxTable
implements Table {
    private byte[] buf = null;
    private int[] hMetrics = null;
    private short[] leftSideBearing = null;

    protected HmtxTable(DirectoryEntry directoryEntry, RandomAccessFile randomAccessFile) throws IOException {
        randomAccessFile.seek(directoryEntry.getOffset());
        this.buf = new byte[directoryEntry.getLength()];
        randomAccessFile.read(this.buf);
    }

    public void init(int n, int n2) {
        int n3;
        if (this.buf == null) {
            return;
        }
        this.hMetrics = new int[n];
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.buf);
        for (n3 = 0; n3 < n; ++n3) {
            this.hMetrics[n3] = byteArrayInputStream.read() << 24 | byteArrayInputStream.read() << 16 | byteArrayInputStream.read() << 8 | byteArrayInputStream.read();
        }
        if (n2 > 0) {
            this.leftSideBearing = new short[n2];
            for (n3 = 0; n3 < n2; ++n3) {
                this.leftSideBearing[n3] = (short)(byteArrayInputStream.read() << 8 | byteArrayInputStream.read());
            }
        }
        this.buf = null;
    }

    public int getAdvanceWidth(int n) {
        if (this.hMetrics == null) {
            return 0;
        }
        if (n < this.hMetrics.length) {
            return this.hMetrics[n] >> 16;
        }
        return this.hMetrics[this.hMetrics.length - 1] >> 16;
    }

    public short getLeftSideBearing(int n) {
        if (this.hMetrics == null) {
            return 0;
        }
        if (n < this.hMetrics.length) {
            return (short)(this.hMetrics[n] & 0xFFFF);
        }
        return this.leftSideBearing[n - this.hMetrics.length];
    }

    public int getType() {
        return 1752003704;
    }
}

