/*
 * Decompiled with CFR 0.152.
 */
package mediathek.daten;

import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class FilmListMetaData {
    private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("dd.MM.yyyy, HH:mm");
    private static final Logger logger = LogManager.getLogger();
    private String id = "";
    private ZonedDateTime creationDateTime;

    public String getDatum() {
        return FORMATTER.format(this.creationDateTime);
    }

    public void setDatum(String datum) {
        this.creationDateTime = LocalDateTime.parse(datum, FORMATTER).atZone(ZoneOffset.UTC);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getVersion() {
        return "3";
    }

    public String getGenerationDateTimeAsString() {
        String res;
        try {
            res = FORMATTER.format(this.creationDateTime.withZoneSameInstant(ZoneId.systemDefault()));
        }
        catch (Exception ex) {
            res = "0";
        }
        return res;
    }

    @Nullable
    private Duration getAge() {
        return Duration.between(this.creationDateTime, Instant.now().atZone(ZoneId.systemDefault()));
    }

    public long getAgeInSeconds() {
        long newAge;
        try {
            newAge = Objects.requireNonNull(this.getAge()).toSeconds();
        }
        catch (Exception ex) {
            newAge = 0L;
        }
        return newAge;
    }

    public boolean isOlderThan(long sekunden) {
        long ret = this.getAgeInSeconds();
        if (ret != 0L) {
            logger.info("Die Filmliste ist {} Minuten alt", (Object)(ret / 60L));
        }
        return ret > sekunden;
    }

    public boolean canUseDiffList() {
        if (this.creationDateTime == null) {
            return false;
        }
        ZonedDateTime firstPossibleDiffTime = ZonedDateTime.of(LocalDate.now(), LocalTime.of(7, 0), ZoneOffset.UTC);
        return this.creationDateTime.isAfter(firstPossibleDiffTime);
    }
}

