/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update;

import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.http.HttpResponse;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.BinaryResponseParser;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.client.solrj.request.AbstractUpdateRequest;
import org.apache.solr.client.solrj.request.UpdateRequest;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ZkCoreNodeProps;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.Diagnostics;
import org.apache.solr.update.AddUpdateCommand;
import org.apache.solr.update.CommitUpdateCommand;
import org.apache.solr.update.DeleteUpdateCommand;
import org.apache.solr.update.StreamingSolrClients;
import org.apache.solr.update.UpdateCommand;
import org.apache.solr.update.UpdateShardHandler;
import org.apache.solr.update.processor.DistributedUpdateProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrCmdDistributor {
    private static final int MAX_RETRIES_ON_FORWARD = 25;
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private StreamingSolrClients clients;
    private boolean finished = false;
    private int retryPause = 500;
    private int maxRetriesOnForward = 25;
    private final List<Error> allErrors = new ArrayList<Error>();
    private final List<Error> errors = Collections.synchronizedList(new ArrayList());
    private final ExecutorService updateExecutor;
    private final CompletionService<Object> completionService;
    private final Set<Future<Object>> pending = new HashSet<Future<Object>>();
    public static Diagnostics.Callable testing_errorHook;

    public SolrCmdDistributor(UpdateShardHandler updateShardHandler) {
        this.clients = new StreamingSolrClients(updateShardHandler);
        this.updateExecutor = updateShardHandler.getUpdateExecutor();
        this.completionService = new ExecutorCompletionService<Object>(this.updateExecutor);
    }

    public SolrCmdDistributor(StreamingSolrClients clients, int maxRetriesOnForward, int retryPause) {
        this.clients = clients;
        this.maxRetriesOnForward = maxRetriesOnForward;
        this.retryPause = retryPause;
        this.updateExecutor = clients.getUpdateExecutor();
        this.completionService = new ExecutorCompletionService<Object>(this.updateExecutor);
    }

    public void finish() {
        try {
            assert (!this.finished) : "lifecycle sanity check";
            this.finished = true;
            this.blockAndDoRetries();
        }
        finally {
            this.clients.shutdown();
        }
    }

    private void doRetriesIfNeeded() {
        ArrayList<Error> errors = new ArrayList<Error>(this.errors);
        errors.addAll(this.clients.getErrors());
        ArrayList<Error> resubmitList = new ArrayList<Error>();
        for (Error err : errors) {
            try {
                String oldNodeUrl = err.req.node.getUrl();
                boolean isRetry = err.req.node.checkRetry();
                boolean doRetry = false;
                int rspCode = err.statusCode;
                if (testing_errorHook != null) {
                    Diagnostics.call(testing_errorHook, err.e);
                }
                if (isRetry) {
                    if (rspCode == 404 || rspCode == 403 || rspCode == 503) {
                        doRetry = true;
                    }
                    if (err.e instanceof SolrServerException && ((SolrServerException)((Object)err.e)).getRootCause() instanceof ConnectException) {
                        doRetry = true;
                    }
                    if (err.e instanceof ConnectException) {
                        doRetry = true;
                    }
                    if (err.req.retries < this.maxRetriesOnForward && doRetry) {
                        ++err.req.retries;
                        SolrException.log((Logger)log, (String)("forwarding update to " + oldNodeUrl + " failed - retrying ... retries: " + err.req.retries + " " + err.req.cmd.toString() + " params:" + err.req.uReq.getParams() + " rsp:" + rspCode), (Throwable)err.e);
                        try {
                            Thread.sleep(this.retryPause);
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            log.warn(null, (Throwable)e);
                        }
                        resubmitList.add(err);
                        continue;
                    }
                    this.allErrors.add(err);
                    continue;
                }
                this.allErrors.add(err);
            }
            catch (Exception e) {
                log.error("Unexpected Error while doing request retries", (Throwable)e);
            }
        }
        this.clients.clearErrors();
        this.errors.clear();
        for (Error err : resubmitList) {
            this.submit(err.req, false);
        }
        if (resubmitList.size() > 0) {
            this.blockAndDoRetries();
        }
    }

    public void distribDelete(DeleteUpdateCommand cmd, List<Node> nodes, ModifiableSolrParams params) throws IOException {
        this.distribDelete(cmd, nodes, params, false);
    }

    public void distribDelete(DeleteUpdateCommand cmd, List<Node> nodes, ModifiableSolrParams params, boolean sync) throws IOException {
        for (Node node : nodes) {
            UpdateRequest uReq = new UpdateRequest();
            uReq.setParams(params);
            uReq.setCommitWithin(cmd.commitWithin);
            if (cmd.isDeleteById()) {
                uReq.deleteById(cmd.getId(), cmd.getRoute(), Long.valueOf(cmd.getVersion()));
            } else {
                uReq.deleteByQuery(cmd.query);
            }
            this.submit(new Req(cmd, node, uReq, sync), false);
        }
    }

    public void distribAdd(AddUpdateCommand cmd, List<Node> nodes, ModifiableSolrParams params) throws IOException {
        this.distribAdd(cmd, nodes, params, false, null);
    }

    public void distribAdd(AddUpdateCommand cmd, List<Node> nodes, ModifiableSolrParams params, boolean synchronous) throws IOException {
        this.distribAdd(cmd, nodes, params, synchronous, null);
    }

    public void distribAdd(AddUpdateCommand cmd, List<Node> nodes, ModifiableSolrParams params, boolean synchronous, DistributedUpdateProcessor.RequestReplicationTracker rrt) throws IOException {
        for (Node node : nodes) {
            UpdateRequest uReq = new UpdateRequest();
            if (cmd.isLastDocInBatch) {
                uReq.lastDocInBatch();
            }
            uReq.setParams(params);
            uReq.add(cmd.solrDoc, Integer.valueOf(cmd.commitWithin), Boolean.valueOf(cmd.overwrite));
            if (cmd.isInPlaceUpdate()) {
                params.set("distrib.inplace.prevversion", new String[]{String.valueOf(cmd.prevVersion)});
            }
            this.submit(new Req(cmd, node, uReq, synchronous, rrt, cmd.pollQueueTime), false);
        }
    }

    public void distribCommit(CommitUpdateCommand cmd, List<Node> nodes, ModifiableSolrParams params) throws IOException {
        this.blockAndDoRetries();
        UpdateRequest uReq = new UpdateRequest();
        uReq.setParams(params);
        this.addCommit(uReq, cmd);
        log.debug("Distrib commit to: {} params: {}", nodes, (Object)params);
        for (Node node : nodes) {
            this.submit(new Req(cmd, node, uReq, false), true);
        }
    }

    public void blockAndDoRetries() {
        this.clients.blockUntilFinished();
        while (this.pending != null && this.pending.size() > 0) {
            Future<Object> future = null;
            try {
                future = this.completionService.take();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                log.error("blockAndDoRetries interrupted", (Throwable)e);
            }
            if (future == null) break;
            this.pending.remove(future);
        }
        this.doRetriesIfNeeded();
    }

    void addCommit(UpdateRequest ureq, CommitUpdateCommand cmd) {
        if (cmd == null) {
            return;
        }
        ureq.setAction(cmd.optimize ? AbstractUpdateRequest.ACTION.OPTIMIZE : AbstractUpdateRequest.ACTION.COMMIT, false, cmd.waitSearcher, cmd.maxOptimizeSegments, cmd.softCommit, cmd.expungeDeletes, cmd.openSearcher);
    }

    private void submit(Req req, boolean isCommit) {
        if (req.synchronous) {
            this.blockAndDoRetries();
            try (HttpSolrClient client = new HttpSolrClient.Builder(req.node.getUrl()).withHttpClient(this.clients.getHttpClient()).build();){
                client.request((SolrRequest)req.uReq);
            }
            catch (Exception e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Failed synchronous update on shard " + req.node + " update: " + req.uReq, (Throwable)e);
            }
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("sending update to " + req.node.getUrl() + " retry:" + req.retries + " " + req.cmd + " params:" + req.uReq.getParams());
        }
        if (isCommit) {
            this.pending.add(this.completionService.submit(() -> {
                this.doRequest(req);
                return null;
            }));
        } else {
            this.doRequest(req);
        }
    }

    private void doRequest(Req req) {
        try {
            SolrClient solrClient = this.clients.getSolrClient(req);
            solrClient.request((SolrRequest)req.uReq);
        }
        catch (Exception e) {
            SolrException.log((Logger)log, (Throwable)e);
            Error error = new Error();
            error.e = e;
            error.req = req;
            if (e instanceof SolrException) {
                error.statusCode = ((SolrException)((Object)e)).code();
            }
            this.errors.add(error);
        }
    }

    public List<Error> getErrors() {
        return this.allErrors;
    }

    public static class RetryNode
    extends StdNode {
        private ZkStateReader zkStateReader;

        public RetryNode(ZkCoreNodeProps nodeProps, ZkStateReader zkStateReader, String collection, String shardId) {
            super(nodeProps, collection, shardId);
            this.zkStateReader = zkStateReader;
            this.collection = collection;
            this.shardId = shardId;
        }

        @Override
        public boolean checkRetry() {
            ZkCoreNodeProps leaderProps;
            try {
                leaderProps = new ZkCoreNodeProps((ZkNodeProps)this.zkStateReader.getLeaderRetry(this.collection, this.shardId));
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return false;
            }
            catch (Exception e) {
                log.warn(null, (Throwable)e);
                return true;
            }
            this.nodeProps = leaderProps;
            return true;
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (this.collection == null ? 0 : this.collection.hashCode());
            result = 31 * result + (this.shardId == null ? 0 : this.shardId.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            RetryNode other = (RetryNode)obj;
            return !(this.nodeProps.getCoreUrl() == null ? other.nodeProps.getCoreUrl() != null : !this.nodeProps.getCoreUrl().equals(other.nodeProps.getCoreUrl()));
        }
    }

    public static class StdNode
    extends Node {
        protected ZkCoreNodeProps nodeProps;
        protected String collection;
        protected String shardId;

        public StdNode(ZkCoreNodeProps nodeProps) {
            this(nodeProps, null, null);
        }

        public StdNode(ZkCoreNodeProps nodeProps, String collection, String shardId) {
            this.nodeProps = nodeProps;
            this.collection = collection;
            this.shardId = shardId;
        }

        @Override
        public String getCollection() {
            return this.collection;
        }

        @Override
        public String getShardId() {
            return this.shardId;
        }

        @Override
        public String getUrl() {
            return this.nodeProps.getCoreUrl();
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": " + this.nodeProps.getCoreUrl();
        }

        @Override
        public boolean checkRetry() {
            return false;
        }

        @Override
        public String getBaseUrl() {
            return this.nodeProps.getBaseUrl();
        }

        @Override
        public String getCoreName() {
            return this.nodeProps.getCoreName();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            String baseUrl = this.nodeProps.getBaseUrl();
            String coreName = this.nodeProps.getCoreName();
            String url = this.nodeProps.getCoreUrl();
            result = 31 * result + (baseUrl == null ? 0 : baseUrl.hashCode());
            result = 31 * result + (coreName == null ? 0 : coreName.hashCode());
            result = 31 * result + (url == null ? 0 : url.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            StdNode other = (StdNode)obj;
            String baseUrl = this.nodeProps.getBaseUrl();
            String coreName = this.nodeProps.getCoreName();
            String url = this.nodeProps.getCoreUrl();
            if (baseUrl == null ? other.nodeProps.getBaseUrl() != null : !baseUrl.equals(other.nodeProps.getBaseUrl())) {
                return false;
            }
            if (coreName == null ? other.nodeProps.getCoreName() != null : !coreName.equals(other.nodeProps.getCoreName())) {
                return false;
            }
            return !(url == null ? other.nodeProps.getCoreUrl() != null : !url.equals(other.nodeProps.getCoreUrl()));
        }

        @Override
        public ZkCoreNodeProps getNodeProps() {
            return this.nodeProps;
        }
    }

    public static abstract class Node {
        public abstract String getUrl();

        public abstract boolean checkRetry();

        public abstract String getCoreName();

        public abstract String getBaseUrl();

        public abstract ZkCoreNodeProps getNodeProps();

        public abstract String getCollection();

        public abstract String getShardId();
    }

    public static class Error {
        public Exception e;
        public int statusCode = -1;
        public Req req;

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("SolrCmdDistributor$Error: statusCode=").append(this.statusCode);
            sb.append("; exception=").append(String.valueOf(this.e));
            sb.append("; req=").append(String.valueOf(this.req));
            return sb.toString();
        }
    }

    public static class Response {
        public List<Error> errors = new ArrayList<Error>();
    }

    public static class Req {
        public Node node;
        public UpdateRequest uReq;
        public int retries;
        public boolean synchronous;
        public UpdateCommand cmd;
        public DistributedUpdateProcessor.RequestReplicationTracker rfTracker;
        public int pollQueueTime;

        public Req(UpdateCommand cmd, Node node, UpdateRequest uReq, boolean synchronous) {
            this(cmd, node, uReq, synchronous, null, 0);
        }

        public Req(UpdateCommand cmd, Node node, UpdateRequest uReq, boolean synchronous, DistributedUpdateProcessor.RequestReplicationTracker rfTracker, int pollQueueTime) {
            this.node = node;
            this.uReq = uReq;
            this.synchronous = synchronous;
            this.cmd = cmd;
            this.rfTracker = rfTracker;
            this.pollQueueTime = pollQueueTime;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("SolrCmdDistributor$Req: cmd=").append(this.cmd.toString());
            sb.append("; node=").append(String.valueOf(this.node));
            return sb.toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void trackRequestResult(HttpResponse resp, boolean success) {
            if (this.rfTracker != null) {
                Integer rf = null;
                if (resp != null) {
                    InputStream inputStream = null;
                    try {
                        NamedList hdrList;
                        Object rfObj;
                        inputStream = resp.getEntity().getContent();
                        BinaryResponseParser brp = new BinaryResponseParser();
                        NamedList nl = brp.processResponse(inputStream, null);
                        Object hdr = nl.get("responseHeader");
                        if (hdr != null && hdr instanceof NamedList && (rfObj = (hdrList = (NamedList)hdr).get("rf")) != null && rfObj instanceof Integer) {
                            rf = (Integer)rfObj;
                        }
                    }
                    catch (Exception e) {
                        log.warn("Failed to parse response from " + this.node + " during replication factor accounting due to: " + e);
                    }
                    finally {
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Exception exception) {}
                        }
                    }
                }
                this.rfTracker.trackRequestResult(this.node, success, rf);
            }
        }
    }

    public static interface AbortCheck {
        public boolean abortCheck();
    }
}

