/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.response.transform;

import java.io.IOException;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.join.BitSetProducer;
import org.apache.lucene.search.join.ToChildBlockJoinQuery;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.response.DocsStreamer;
import org.apache.solr.response.transform.DocTransformer;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.DocIterator;
import org.apache.solr.search.DocList;

class ChildDocTransformer
extends DocTransformer {
    private final String name;
    private final SchemaField idField;
    private final IndexSchema schema;
    private BitSetProducer parentsFilter;
    private Query childFilterQuery;
    private int limit;

    public ChildDocTransformer(String name, BitSetProducer parentsFilter, SchemaField idField, IndexSchema schema, Query childFilterQuery, int limit) {
        this.name = name;
        this.idField = idField;
        this.schema = schema;
        this.parentsFilter = parentsFilter;
        this.childFilterQuery = childFilterQuery;
        this.limit = limit;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void transform(SolrDocument doc, int docid, float score) {
        FieldType idFt = this.idField.getType();
        Object parentIdField = doc.getFirstValue(this.idField.getName());
        String parentIdExt = parentIdField instanceof IndexableField ? idFt.toExternal((IndexableField)parentIdField) : parentIdField.toString();
        try {
            Query parentQuery = idFt.getFieldQuery(null, this.idField, parentIdExt);
            ToChildBlockJoinQuery query = new ToChildBlockJoinQuery(parentQuery, this.parentsFilter);
            DocList children = this.context.getSearcher().getDocList((Query)query, this.childFilterQuery, new Sort(), 0, this.limit);
            if (children.matches() > 0) {
                DocIterator i = children.iterator();
                while (i.hasNext()) {
                    Integer childDocNum = (Integer)i.next();
                    Document childDoc = this.context.getSearcher().doc(childDocNum);
                    SolrDocument solrChildDoc = DocsStreamer.convertLuceneDocToSolrDoc(childDoc, this.schema);
                    doc.addChildDocument(solrChildDoc);
                }
            }
        }
        catch (IOException e) {
            doc.put(this.name, (Object)"Could not fetch child Documents");
        }
    }
}

