/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.SolrInfoMBean;
import org.apache.solr.handler.RequestHandlerBase;
import org.apache.solr.metrics.SolrMetricManager;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.security.AuthorizationContext;
import org.apache.solr.security.PermissionNameProvider;
import org.apache.solr.util.stats.MetricUtils;

public class MetricsHandler
extends RequestHandlerBase
implements PermissionNameProvider {
    final CoreContainer container;
    final SolrMetricManager metricManager;
    public static final String COMPACT_PARAM = "compact";
    public static final String PREFIX_PARAM = "prefix";
    public static final String REGEX_PARAM = "regex";
    public static final String REGISTRY_PARAM = "registry";
    public static final String GROUP_PARAM = "group";
    public static final String TYPE_PARAM = "type";
    public static final String ALL = "all";

    public MetricsHandler() {
        this.container = null;
        this.metricManager = null;
    }

    public MetricsHandler(CoreContainer container) {
        this.container = container;
        this.metricManager = this.container.getMetricManager();
    }

    @Override
    public PermissionNameProvider.Name getPermissionName(AuthorizationContext request) {
        return PermissionNameProvider.Name.METRICS_READ_PERM;
    }

    @Override
    public void handleRequestBody(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        if (this.container == null) {
            throw new SolrException(SolrException.ErrorCode.INVALID_STATE, "Core container instance not initialized");
        }
        boolean compact = req.getParams().getBool(COMPACT_PARAM, false);
        MetricFilter mustMatchFilter = this.parseMustMatchFilter(req);
        List<MetricType> metricTypes = this.parseMetricTypes(req);
        List<MetricFilter> metricFilters = metricTypes.stream().map(MetricType::asMetricFilter).collect(Collectors.toList());
        Set<String> requestedRegistries = this.parseRegistries(req);
        SimpleOrderedMap response = new SimpleOrderedMap();
        for (String registryName : requestedRegistries) {
            MetricRegistry registry = this.metricManager.registry(registryName);
            response.add(registryName, (Object)MetricUtils.toNamedList(registry, metricFilters, mustMatchFilter, false, false, compact, null));
        }
        rsp.getValues().add("metrics", (Object)response);
    }

    private MetricFilter parseMustMatchFilter(SolrQueryRequest req) {
        String[] prefixes = req.getParams().getParams(PREFIX_PARAM);
        SolrMetricManager.PrefixFilter prefixFilter = null;
        if (prefixes != null && prefixes.length > 0) {
            HashSet prefixSet = new HashSet();
            for (String prefix : prefixes) {
                prefixSet.addAll(StrUtils.splitSmart((String)prefix, (char)','));
            }
            prefixFilter = new SolrMetricManager.PrefixFilter(prefixSet.toArray(new String[prefixSet.size()]));
        }
        String[] regexes = req.getParams().getParams(REGEX_PARAM);
        SolrMetricManager.RegexFilter regexFilter = null;
        if (regexes != null && regexes.length > 0) {
            regexFilter = new SolrMetricManager.RegexFilter(regexes);
        }
        Object mustMatchFilter = prefixFilter == null && regexFilter == null ? MetricFilter.ALL : new SolrMetricManager.OrFilter(prefixFilter, regexFilter);
        return mustMatchFilter;
    }

    private Set<String> parseRegistries(SolrQueryRequest req) {
        List split;
        String[] groupStr = req.getParams().getParams(GROUP_PARAM);
        String[] registryStr = req.getParams().getParams(REGISTRY_PARAM);
        if (!(groupStr != null && groupStr.length != 0 || registryStr != null && registryStr.length != 0)) {
            return this.container.getMetricManager().registryNames();
        }
        boolean allRegistries = false;
        Set<String> initialPrefixes = Collections.emptySet();
        if (groupStr != null && groupStr.length > 0) {
            initialPrefixes = new HashSet<String>();
            for (String g : groupStr) {
                split = StrUtils.splitSmart((String)g, (char)',');
                for (String s : split) {
                    if (s.trim().equals(ALL)) {
                        allRegistries = true;
                        break;
                    }
                    initialPrefixes.add(SolrMetricManager.overridableRegistryName(s.trim()));
                }
                if (!allRegistries) continue;
                return this.container.getMetricManager().registryNames();
            }
        }
        if (registryStr != null && registryStr.length > 0) {
            if (initialPrefixes.isEmpty()) {
                initialPrefixes = new HashSet<String>();
            }
            for (String r : registryStr) {
                split = StrUtils.splitSmart((String)r, (char)',');
                for (String s : split) {
                    if (s.trim().equals(ALL)) {
                        allRegistries = true;
                        break;
                    }
                    initialPrefixes.add(SolrMetricManager.overridableRegistryName(s.trim()));
                }
                if (!allRegistries) continue;
                return this.container.getMetricManager().registryNames();
            }
        }
        HashSet<String> validRegistries = new HashSet<String>();
        block4: for (String r : this.container.getMetricManager().registryNames()) {
            for (String prefix : initialPrefixes) {
                if (!r.startsWith(prefix)) continue;
                validRegistries.add(r);
                continue block4;
            }
        }
        return validRegistries;
    }

    private List<MetricType> parseMetricTypes(SolrQueryRequest req) {
        String[] typeStr = req.getParams().getParams(TYPE_PARAM);
        List types = Collections.emptyList();
        if (typeStr != null && typeStr.length > 0) {
            types = new ArrayList();
            for (String type : typeStr) {
                types.addAll(StrUtils.splitSmart((String)type, (char)','));
            }
        }
        List<MetricType> metricTypes = Collections.singletonList(MetricType.all);
        try {
            if (types.size() > 0) {
                metricTypes = types.stream().map(String::trim).map(MetricType::valueOf).collect(Collectors.toList());
            }
        }
        catch (IllegalArgumentException e) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Invalid metric type in: " + types + " specified. Must be one of " + MetricType.SUPPORTED_TYPES_MSG, (Throwable)e);
        }
        return metricTypes;
    }

    @Override
    public String getDescription() {
        return "A handler to return all the metrics gathered by Solr";
    }

    @Override
    public SolrInfoMBean.Category getCategory() {
        return SolrInfoMBean.Category.ADMIN;
    }

    static enum MetricType {
        histogram(Histogram.class),
        meter(Meter.class),
        timer(Timer.class),
        counter(Counter.class),
        gauge(Gauge.class),
        all(null);

        public static final String SUPPORTED_TYPES_MSG;
        private final Class klass;

        private MetricType(Class klass) {
            this.klass = klass;
        }

        public MetricFilter asMetricFilter() {
            return (name, metric) -> this.klass == null || this.klass.isInstance(metric);
        }

        static {
            SUPPORTED_TYPES_MSG = EnumSet.allOf(MetricType.class).toString();
        }
    }
}

