/*
 * Decompiled with CFR 0.152.
 */
package SevenZip.Archive;

import SevenZip.Archive.SevenZip.MethodID;

public class SevenZipEntry {
    protected long LastWriteTime;
    protected long UnPackSize;
    protected long PackSize;
    protected int Attributes;
    protected long FileCRC;
    protected boolean IsDirectory;
    protected String Name;
    protected String Methods;
    protected long Position;
    static final String kEmptyAttributeChar = ".";
    static final String kDirectoryAttributeChar = "D";
    static final String kReadonlyAttributeChar = "R";
    static final String kHiddenAttributeChar = "H";
    static final String kSystemAttributeChar = "S";
    static final String kArchiveAttributeChar = "A";
    public static final int FILE_ATTRIBUTE_READONLY = 1;
    public static final int FILE_ATTRIBUTE_HIDDEN = 2;
    public static final int FILE_ATTRIBUTE_SYSTEM = 4;
    public static final int FILE_ATTRIBUTE_DIRECTORY = 16;
    public static final int FILE_ATTRIBUTE_ARCHIVE = 32;

    public SevenZipEntry(String name, long packSize, long unPackSize, long crc, long lastWriteTime, long position, boolean isDir, int att, String methods) {
        this.Name = name;
        this.PackSize = packSize;
        this.UnPackSize = unPackSize;
        this.FileCRC = crc;
        this.LastWriteTime = lastWriteTime;
        this.Position = position;
        this.IsDirectory = isDir;
        this.Attributes = att;
        this.Methods = methods;
    }

    public SevenZipEntry(String name, long packSize, long unPackSize, long crc, long lastWriteTime, long position, boolean isDir, int att, MethodID[] methods) {
        this.Name = name;
        this.PackSize = packSize;
        this.UnPackSize = unPackSize;
        this.FileCRC = crc;
        this.LastWriteTime = lastWriteTime;
        this.Position = position;
        this.IsDirectory = isDir;
        this.Attributes = att;
        StringBuffer methodNames = new StringBuffer();
        for (int i = 0; i < methods.length; ++i) {
            if (methods[i].getName() == null) continue;
            if (methodNames.length() > 0) {
                methodNames.append(' ');
            }
            methodNames.append(methods[i].getName());
        }
        this.Methods = methodNames.toString();
    }

    public long getCompressedSize() {
        return this.PackSize;
    }

    public long getSize() {
        return this.UnPackSize;
    }

    public long getCrc() {
        return this.FileCRC;
    }

    public String getName() {
        return this.Name;
    }

    public long getTime() {
        return this.LastWriteTime;
    }

    public long getPosition() {
        return this.Position;
    }

    public boolean isDirectory() {
        return this.IsDirectory;
    }

    public String getAttributesString() {
        String ret = "";
        ret = ret + ((this.Attributes & 0x10) != 0 || this.IsDirectory ? kDirectoryAttributeChar : kEmptyAttributeChar);
        ret = ret + ((this.Attributes & 1) != 0 ? kReadonlyAttributeChar : kEmptyAttributeChar);
        ret = ret + ((this.Attributes & 2) != 0 ? kHiddenAttributeChar : kEmptyAttributeChar);
        ret = ret + ((this.Attributes & 4) != 0 ? kSystemAttributeChar : kEmptyAttributeChar);
        ret = ret + ((this.Attributes & 0x20) != 0 ? kArchiveAttributeChar : kEmptyAttributeChar);
        return ret;
    }

    public String getMethods() {
        return this.Methods;
    }
}

