/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xmp.impl;

import com.adobe.xmp.impl.Utils;
import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;

public class FixASCIIControlsReader
extends PushbackReader {
    private static final int STATE_START = 0;
    private static final int STATE_AMP = 1;
    private static final int STATE_HASH = 2;
    private static final int STATE_HEX = 3;
    private static final int STATE_DIG1 = 4;
    private static final int STATE_ERROR = 5;
    private static final int BUFFER_SIZE = 8;
    private int state = 0;
    private int control = 0;
    private int digits = 0;

    public FixASCIIControlsReader(Reader reader) {
        super(reader, 8);
    }

    @Override
    public int read(char[] cArray, int n, int n2) throws IOException {
        int n3 = 0;
        int n4 = 0;
        int n5 = n;
        char[] cArray2 = new char[8];
        boolean bl = true;
        while (bl && n4 < n2) {
            boolean bl2 = bl = super.read(cArray2, n3, 1) == 1;
            if (bl) {
                int n6 = this.processChar(cArray2[n3]);
                if (this.state == 0) {
                    if (Utils.isControlChar((char)n6)) {
                        n6 = 32;
                    }
                    cArray[n5++] = n6;
                    n3 = 0;
                    ++n4;
                    continue;
                }
                if (this.state == 5) {
                    this.unread(cArray2, 0, n3 + 1);
                    n3 = 0;
                    continue;
                }
                ++n3;
                continue;
            }
            if (n3 <= 0) continue;
            this.unread(cArray2, 0, n3);
            this.state = 5;
            n3 = 0;
            bl = true;
        }
        return n4 > 0 || bl ? n4 : -1;
    }

    private char processChar(char c) {
        switch (this.state) {
            case 0: {
                if (c == '&') {
                    this.state = 1;
                }
                return c;
            }
            case 1: {
                this.state = c == '#' ? 2 : 5;
                return c;
            }
            case 2: {
                if (c == 'x') {
                    this.control = 0;
                    this.digits = 0;
                    this.state = 3;
                } else if ('0' <= c && c <= '9') {
                    this.control = Character.digit(c, 10);
                    this.digits = 1;
                    this.state = 4;
                } else {
                    this.state = 5;
                }
                return c;
            }
            case 4: {
                if ('0' <= c && c <= '9') {
                    this.control = this.control * 10 + Character.digit(c, 10);
                    ++this.digits;
                    this.state = this.digits <= 5 ? 4 : 5;
                } else {
                    if (c == ';' && Utils.isControlChar((char)this.control)) {
                        this.state = 0;
                        return (char)this.control;
                    }
                    this.state = 5;
                }
                return c;
            }
            case 3: {
                if ('0' <= c && c <= '9' || 'a' <= c && c <= 'f' || 'A' <= c && c <= 'F') {
                    this.control = this.control * 16 + Character.digit(c, 16);
                    ++this.digits;
                    this.state = this.digits <= 4 ? 3 : 5;
                } else {
                    if (c == ';' && Utils.isControlChar((char)this.control)) {
                        this.state = 0;
                        return (char)this.control;
                    }
                    this.state = 5;
                }
                return c;
            }
            case 5: {
                this.state = 0;
                return c;
            }
        }
        return c;
    }
}

