/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module;

import VASSAL.build.AbstractConfigurable;
import VASSAL.build.AutoConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.build.module.Chatter;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.properties.MutableProperty;
import VASSAL.build.module.properties.PropertySource;
import VASSAL.command.Command;
import VASSAL.command.NullCommand;
import VASSAL.command.PlayAudioClipCommand;
import VASSAL.configure.AudioClipConfigurer;
import VASSAL.configure.Configurer;
import VASSAL.configure.ConfigurerFactory;
import VASSAL.configure.FormattedExpressionConfigurer;
import VASSAL.configure.IconConfigurer;
import VASSAL.configure.ListConfigurer;
import VASSAL.configure.NamedHotKeyConfigurer;
import VASSAL.configure.PlayerIdFormattedStringConfigurer;
import VASSAL.configure.PropertyExpression;
import VASSAL.configure.StringEnumConfigurer;
import VASSAL.configure.VisibilityCondition;
import VASSAL.i18n.Resources;
import VASSAL.i18n.TranslatableConfigurerFactory;
import VASSAL.tools.FormattedString;
import VASSAL.tools.LaunchButton;
import VASSAL.tools.LoopControl;
import VASSAL.tools.NamedKeyStroke;
import VASSAL.tools.RecursionLimitException;
import VASSAL.tools.RecursionLimiter;
import VASSAL.tools.SequenceEncoder;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DoActionButton
extends AbstractConfigurable
implements RecursionLimiter.Loopable {
    public static final String BUTTON_TEXT = "text";
    public static final String TOOLTIP = "tooltip";
    public static final String NAME = "name";
    public static final String HOTKEY = "hotkey";
    public static final String ICON = "icon";
    public static final String DO_REPORT = "doReport";
    public static final String REPORT_FORMAT = "reportFormat";
    public static final String DO_SOUND = "doSound";
    public static final String SOUND_CLIP = "soundClip";
    public static final String DO_HOTKEY = "doHotkey";
    public static final String HOTKEYS = "hotkeys";
    public static final String DO_LOOP = "doLoop";
    public static final String LOOP_TYPE = "loopType";
    public static final String LOOP_COUNT = "loopCount";
    public static final String WHILE_EXPRESSION = "whileExpression";
    public static final String UNTIL_EXPRESSION = "untilExpression";
    public static final String PRE_LOOP_HOTKEY = "preLoopKey";
    public static final String POST_LOOP_HOTKEY = "postLoopKey";
    public static final String INDEX = "index";
    public static final String INDEX_PROPERTY = "indexProperty";
    public static final String INDEX_START = "indexStart";
    public static final String INDEX_STEP = "indexStep";
    protected LaunchButton launch;
    protected boolean doReport = false;
    protected FormattedString reportFormat = new FormattedString(GameModule.getGameModule());
    protected boolean doSound = false;
    protected String soundClip = "";
    protected boolean doHotkey = false;
    protected List<NamedKeyStroke> hotkeys = new ArrayList<NamedKeyStroke>();
    protected boolean doLoop = false;
    protected String loopType = "counted";
    protected FormattedString loopCount = new FormattedString("1");
    protected PropertyExpression whileExpression = new PropertyExpression();
    protected PropertyExpression untilExpression = new PropertyExpression();
    protected NamedKeyStroke preLoopKey = NamedKeyStroke.NULL_KEYSTROKE;
    protected NamedKeyStroke postLoopKey = NamedKeyStroke.NULL_KEYSTROKE;
    protected boolean hasIndex = false;
    protected String indexProperty = "";
    protected int indexStart = 1;
    protected int indexStep = 1;
    protected int indexValue;
    protected MutableProperty.Impl loopIndexProperty = new MutableProperty.Impl("", this);
    protected boolean loopPropertyRegistered = false;

    public DoActionButton() {
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    DoActionButton.this.doActions();
                }
                catch (RecursionLimitException recursionLimitException) {
                    RecursionLimiter.infiniteLoop(recursionLimitException);
                }
            }
        };
        String string = Resources.getString("Editor.DoAction.component_type");
        this.launch = new LaunchButton(string, TOOLTIP, BUTTON_TEXT, HOTKEY, ICON, actionListener);
        this.setAttribute(NAME, string);
        this.setAttribute(TOOLTIP, string);
        this.launch.setAttribute(BUTTON_TEXT, string);
    }

    public static String getConfigureTypeName() {
        return Resources.getString("Editor.DoAction.component_type");
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{NAME, BUTTON_TEXT, TOOLTIP, ICON, HOTKEY, DO_REPORT, REPORT_FORMAT, DO_SOUND, SOUND_CLIP, DO_HOTKEY, HOTKEYS, DO_LOOP, LOOP_TYPE, LOOP_COUNT, WHILE_EXPRESSION, UNTIL_EXPRESSION, PRE_LOOP_HOTKEY, POST_LOOP_HOTKEY, INDEX, INDEX_PROPERTY, INDEX_START, INDEX_STEP};
    }

    @Override
    public String[] getAttributeDescriptions() {
        return new String[]{Resources.getString("Editor.description_label"), Resources.getString("Editor.button_text_label"), Resources.getString("Editor.tooltip_text_label"), Resources.getString("Editor.button_icon_label"), Resources.getString("Editor.hotkey_label"), Resources.getString("Editor.DoAction.display_message"), Resources.getString("Editor.report_format"), Resources.getString("Editor.DoAction.play_sound"), Resources.getString("Editor.DoAction.sound_clip"), Resources.getString("Editor.DoAction.send_hotkeys"), Resources.getString("Editor.DoAction.hotkeys"), Resources.getString("Editor.DoAction.repeat_actions"), Resources.getString("Editor.LoopControl.type_of_loop"), Resources.getString("Editor.LoopControl.loop_how_many"), Resources.getString("Editor.LoopControl.looping_continues"), Resources.getString("Editor.LoopControl.looping_ends"), Resources.getString("Editor.DoAction.perform_before"), Resources.getString("Editor.DoAction.perform_after"), Resources.getString("Editor.LoopControl.loop_index"), Resources.getString("Editor.LoopControl.index_name"), Resources.getString("Editor.LoopControl.index_start"), Resources.getString("Editor.LoopControl.index_step")};
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return new Class[]{String.class, String.class, String.class, IconConfig.class, NamedKeyStroke.class, Boolean.class, ReportFormatConfig.class, Boolean.class, SoundConfig.class, Boolean.class, HotkeyConfig.class, Boolean.class, LoopConfig.class, LoopCountConfig.class, PropertyExpression.class, PropertyExpression.class, NamedKeyStroke.class, NamedKeyStroke.class, Boolean.class, String.class, Integer.class, Integer.class};
    }

    @Override
    public void addTo(Buildable buildable) {
        GameModule.getGameModule().getToolBar().add(this.getComponent());
    }

    protected Component getComponent() {
        return this.launch;
    }

    @Override
    public void setAttribute(String string, Object object) {
        if (NAME.equals(string)) {
            this.setConfigureName((String)object);
        } else if (DO_REPORT.equals(string)) {
            if (object instanceof String) {
                object = Boolean.valueOf((String)object);
            }
            this.doReport = (Boolean)object;
        } else if (REPORT_FORMAT.equals(string)) {
            this.reportFormat.setFormat((String)object);
        } else if (DO_SOUND.equals(string)) {
            if (object instanceof String) {
                object = Boolean.valueOf((String)object);
            }
            this.doSound = (Boolean)object;
        }
        if (SOUND_CLIP.equals(string)) {
            if (object instanceof File) {
                object = ((File)object).getName();
            }
            this.soundClip = (String)object;
        } else if (DO_HOTKEY.equals(string)) {
            if (object instanceof String) {
                object = Boolean.valueOf((String)object);
            }
            this.doHotkey = (Boolean)object;
        } else if (HOTKEYS.equals(string)) {
            if (object instanceof String) {
                object = this.decodeHotkeys((String)object);
            }
            this.hotkeys = (List)object;
        } else if (DO_LOOP.equals(string)) {
            if (object instanceof String) {
                object = Boolean.valueOf((String)object);
            }
            this.doLoop = (Boolean)object;
            this.updateLoopPropertyRegistration();
        } else if (LOOP_TYPE.equals(string)) {
            this.loopType = LoopControl.loopDescToType((String)object);
        } else if (LOOP_COUNT.equals(string)) {
            this.loopCount.setFormat((String)object);
        } else if (WHILE_EXPRESSION.equals(string)) {
            this.whileExpression.setExpression((String)object);
        } else if (UNTIL_EXPRESSION.equals(string)) {
            this.untilExpression.setExpression((String)object);
        } else if (PRE_LOOP_HOTKEY.equals(string)) {
            if (object instanceof String) {
                object = NamedHotKeyConfigurer.decode((String)object);
            }
            this.preLoopKey = (NamedKeyStroke)object;
        } else if (POST_LOOP_HOTKEY.equals(string)) {
            if (object instanceof String) {
                object = NamedHotKeyConfigurer.decode((String)object);
            }
            this.postLoopKey = (NamedKeyStroke)object;
        } else if (INDEX.equals(string)) {
            if (object instanceof String) {
                object = Boolean.valueOf((String)object);
            }
            this.hasIndex = (Boolean)object;
            this.updateLoopPropertyRegistration();
        } else if (INDEX_PROPERTY.equals(string)) {
            this.indexProperty = (String)object;
            this.loopIndexProperty.setPropertyName(this.indexProperty);
            this.updateLoopPropertyRegistration();
        } else if (INDEX_START.equals(string)) {
            if (object instanceof String) {
                object = Integer.valueOf((String)object);
            }
            this.indexStart = (Integer)object;
        } else if (INDEX_STEP.equals(string)) {
            if (object instanceof String) {
                object = Integer.valueOf((String)object);
            }
            this.indexStep = (Integer)object;
        } else {
            this.launch.setAttribute(string, object);
        }
    }

    @Override
    public String getAttributeValueString(String string) {
        if (NAME.equals(string)) {
            return this.getConfigureName();
        }
        if (DO_REPORT.equals(string)) {
            return String.valueOf(this.doReport);
        }
        if (REPORT_FORMAT.equals(string)) {
            return this.reportFormat.getFormat();
        }
        if (DO_SOUND.equals(string)) {
            return String.valueOf(this.doSound);
        }
        if (SOUND_CLIP.equals(string)) {
            return this.soundClip;
        }
        if (DO_HOTKEY.equals(string)) {
            return String.valueOf(this.doHotkey);
        }
        if (HOTKEYS.equals(string)) {
            return this.encodeHotkeys();
        }
        if (DO_LOOP.equals(string)) {
            return String.valueOf(this.doLoop);
        }
        if (LOOP_TYPE.equals(string)) {
            return this.loopType;
        }
        if (LOOP_COUNT.equals(string)) {
            return this.loopCount.getFormat();
        }
        if (WHILE_EXPRESSION.equals(string)) {
            return this.whileExpression.getExpression();
        }
        if (UNTIL_EXPRESSION.equals(string)) {
            return this.untilExpression.getExpression();
        }
        if (PRE_LOOP_HOTKEY.equals(string)) {
            return NamedHotKeyConfigurer.encode(this.preLoopKey);
        }
        if (POST_LOOP_HOTKEY.equals(string)) {
            return NamedHotKeyConfigurer.encode(this.postLoopKey);
        }
        if (INDEX.equals(string)) {
            return String.valueOf(this.hasIndex);
        }
        if (INDEX_PROPERTY.equals(string)) {
            return this.indexProperty;
        }
        if (INDEX_START.equals(string)) {
            return String.valueOf(this.indexStart);
        }
        if (INDEX_STEP.equals(string)) {
            return String.valueOf(this.indexStep);
        }
        return this.launch.getAttributeValueString(string);
    }

    @Override
    public VisibilityCondition getAttributeVisibility(String string) {
        if (REPORT_FORMAT.equals(string)) {
            return new VisibilityCondition(){

                public boolean shouldBeVisible() {
                    return DoActionButton.this.doReport;
                }
            };
        }
        if (SOUND_CLIP.equals(string)) {
            return new VisibilityCondition(){

                public boolean shouldBeVisible() {
                    return DoActionButton.this.doSound;
                }
            };
        }
        if (HOTKEYS.equals(string)) {
            return new VisibilityCondition(){

                public boolean shouldBeVisible() {
                    return DoActionButton.this.doHotkey;
                }
            };
        }
        if (LOOP_COUNT.equals(string)) {
            return new VisibilityCondition(){

                public boolean shouldBeVisible() {
                    return DoActionButton.this.doLoop && "counted".equals(DoActionButton.this.loopType);
                }
            };
        }
        if (WHILE_EXPRESSION.equals(string)) {
            return new VisibilityCondition(){

                public boolean shouldBeVisible() {
                    return DoActionButton.this.doLoop && "while".equals(DoActionButton.this.loopType);
                }
            };
        }
        if (UNTIL_EXPRESSION.equals(string)) {
            return new VisibilityCondition(){

                public boolean shouldBeVisible() {
                    return DoActionButton.this.doLoop && "until".equals(DoActionButton.this.loopType);
                }
            };
        }
        if (LOOP_TYPE.equals(string) || PRE_LOOP_HOTKEY.equals(string) || POST_LOOP_HOTKEY.equals(string) || INDEX.equals(string)) {
            return new VisibilityCondition(){

                public boolean shouldBeVisible() {
                    return DoActionButton.this.doLoop;
                }
            };
        }
        if (INDEX_PROPERTY.equals(string) || INDEX_START.equals(string) || INDEX_STEP.equals(string)) {
            return new VisibilityCondition(){

                public boolean shouldBeVisible() {
                    return DoActionButton.this.doLoop && DoActionButton.this.hasIndex;
                }
            };
        }
        return null;
    }

    protected String encodeHotkeys() {
        SequenceEncoder sequenceEncoder = new SequenceEncoder(',');
        for (NamedKeyStroke namedKeyStroke : this.hotkeys) {
            sequenceEncoder.append(NamedHotKeyConfigurer.encode(namedKeyStroke));
        }
        String string = sequenceEncoder.getValue();
        return string == null ? "" : string;
    }

    protected List<NamedKeyStroke> decodeHotkeys(String string) {
        ArrayList<NamedKeyStroke> arrayList = new ArrayList<NamedKeyStroke>();
        SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string, ',');
        while (decoder.hasMoreTokens()) {
            NamedKeyStroke namedKeyStroke = NamedHotKeyConfigurer.decode(decoder.nextToken());
            arrayList.add(namedKeyStroke);
        }
        return arrayList;
    }

    public Class<?>[] getAllowableConfigureComponents() {
        return new Class[0];
    }

    @Override
    public void removeFrom(Buildable buildable) {
        GameModule.getGameModule().getToolBar().remove(this.getComponent());
        GameModule.getGameModule().getToolBar().revalidate();
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("DoActionButton.htm");
    }

    protected void updateLoopPropertyRegistration() {
        boolean bl;
        boolean bl2 = bl = this.doLoop && this.hasIndex && this.indexProperty.length() > 0;
        if (bl && !this.loopPropertyRegistered) {
            this.loopIndexProperty.addTo(GameModule.getGameModule());
            this.loopPropertyRegistered = true;
        } else if (!bl && this.loopPropertyRegistered) {
            this.loopIndexProperty.removeFromContainer();
            this.loopPropertyRegistered = false;
        }
    }

    protected void setIndexPropertyValue() {
        this.loopIndexProperty.setPropertyValue(String.valueOf(this.indexValue));
    }

    protected void doActions() throws RecursionLimitException {
        NullCommand nullCommand = new NullCommand();
        GameModule gameModule = GameModule.getGameModule();
        RecursionLimitException recursionLimitException = null;
        if (!this.doLoop) {
            this.executeActions(nullCommand);
            gameModule.sendAndLog(nullCommand);
            return;
        }
        this.indexValue = this.indexStart;
        this.setIndexPropertyValue();
        this.doHotKey(nullCommand, this.preLoopKey);
        int n = 0;
        int n2 = 0;
        if ("counted".equals(this.loopType)) {
            n2 = this.loopCount.getTextAsInt((PropertySource)gameModule, Resources.getString("Editor.LoopControl.loop_count"), this);
        }
        while (!"while".equals(this.loopType) || this.whileExpression.isTrue(gameModule)) {
            try {
                this.executeActions(nullCommand);
            }
            catch (RecursionLimitException recursionLimitException2) {
                recursionLimitException = recursionLimitException2;
                break;
            }
            if ("until".equals(this.loopType) && this.untilExpression.isTrue(gameModule)) break;
            ++n;
            if ("counted".equals(this.loopType)) {
                if (n >= n2) {
                    break;
                }
            } else if (n >= 500) {
                recursionLimitException = new RecursionLimitException(this);
                break;
            }
            this.indexValue += this.indexStep;
            this.setIndexPropertyValue();
        }
        this.doHotKey(nullCommand, this.postLoopKey);
        gameModule.sendAndLog(nullCommand);
        if (recursionLimitException != null) {
            throw recursionLimitException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeActions(Command command) throws RecursionLimitException {
        GameModule gameModule = GameModule.getGameModule();
        boolean bl = gameModule.pauseLogging();
        try {
            Object object2;
            RecursionLimiter.startExecution(this);
            if (this.doReport) {
                object2 = "* " + this.reportFormat.getLocalizedText();
                Chatter.DisplayText object3 = new Chatter.DisplayText(gameModule.getChatter(), (String)object2);
                object3.execute();
                gameModule.sendAndLog(object3);
            }
            if (this.doSound) {
                object2 = new FormattedString(this.soundClip).getText(gameModule);
                PlayAudioClipCommand playAudioClipCommand = new PlayAudioClipCommand((String)object2);
                playAudioClipCommand.execute();
                gameModule.sendAndLog(playAudioClipCommand);
            }
            if (this.doHotkey) {
                for (NamedKeyStroke namedKeyStroke : this.hotkeys) {
                    gameModule.fireKeyStroke(namedKeyStroke);
                }
            }
        }
        finally {
            RecursionLimiter.endExecution();
            if (bl) {
                command.append(gameModule.resumeLogging());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doHotKey(Command command, NamedKeyStroke namedKeyStroke) {
        if (!namedKeyStroke.isNull()) {
            GameModule gameModule = GameModule.getGameModule();
            boolean bl = gameModule.pauseLogging();
            try {
                gameModule.fireKeyStroke(namedKeyStroke);
            }
            finally {
                if (bl) {
                    command.append(gameModule.resumeLogging());
                }
            }
        }
    }

    @Override
    public String getComponentTypeName() {
        return DoActionButton.getConfigureTypeName();
    }

    @Override
    public String getComponentName() {
        return this.getConfigureName();
    }

    @Override
    public List<String> getPropertyNames() {
        if (this.doLoop && this.hasIndex) {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(this.indexProperty);
            return arrayList;
        }
        return super.getPropertyNames();
    }

    public static class LoopCountConfig
    implements ConfigurerFactory {
        public Configurer getConfigurer(AutoConfigurable autoConfigurable, String string, String string2) {
            return new FormattedExpressionConfigurer(string, string2, ((DoActionButton)autoConfigurable).loopCount);
        }
    }

    public static class LoopTypeConfig
    extends StringEnumConfigurer {
        public LoopTypeConfig(String string, String string2, String string3) {
            super(string, string2, LoopControl.LOOP_TYPE_DESCS);
            this.setValue(LoopControl.loopTypeToDesc(string3));
        }

        public String[] getValidValues(AutoConfigurable autoConfigurable) {
            return LoopControl.LOOP_TYPE_DESCS;
        }

        public String getValueString() {
            return LoopControl.loopDescToType(super.getValueString());
        }
    }

    public static class LoopConfig
    implements ConfigurerFactory {
        public Configurer getConfigurer(AutoConfigurable autoConfigurable, String string, String string2) {
            return new LoopTypeConfig(string, string2, ((DoActionButton)autoConfigurable).loopType);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NamedHotkeyListConfigurer
    extends ListConfigurer {
        public NamedHotkeyListConfigurer(String string, String string2, List<NamedKeyStroke> list) {
            super(string, string2, list);
        }

        @Override
        protected Configurer buildChildConfigurer() {
            return new NamedHotKeyConfigurer(null, Resources.getString("Editor.hotkey_label"));
        }
    }

    public static class HotkeyConfig
    implements ConfigurerFactory {
        public Configurer getConfigurer(AutoConfigurable autoConfigurable, String string, String string2) {
            return new NamedHotkeyListConfigurer(string, string2, ((DoActionButton)autoConfigurable).hotkeys);
        }
    }

    public static class ReportFormatConfig
    implements TranslatableConfigurerFactory {
        public Configurer getConfigurer(AutoConfigurable autoConfigurable, String string, String string2) {
            return new PlayerIdFormattedStringConfigurer(string, string2, new String[0]);
        }
    }

    public static class SoundConfig
    implements ConfigurerFactory {
        public Configurer getConfigurer(AutoConfigurable autoConfigurable, String string, String string2) {
            return new AudioClipConfigurer(string, string2, GameModule.getGameModule().getArchiveWriter());
        }
    }

    public static class IconConfig
    implements ConfigurerFactory {
        public Configurer getConfigurer(AutoConfigurable autoConfigurable, String string, String string2) {
            return new IconConfigurer(string, string2, null);
        }
    }
}

